/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.net;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.cache.ConcurrentDiskUtil;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Domain;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.TenantInfo;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.HttpClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.IOUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.RandomUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.SpasUtil;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.UtilAndComs;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class VIPServerProxy {
    static final String SERVER_PORT = System.getProperty("vipserver.server.port", "80");
    static final String TLS_SERVER_PORT = System.getProperty("vipserver.tls.server.port", "443");
    static final String ADDRESS_SERVER_URL = System.getProperty("vipserver.address.server.url", "/vipserver/serverlist");
    public static final int TIME_OUT_MILLIS = Integer.parseInt(System.getProperty("com.alibaba.ans.shaded.com.taobao.vipserver.address-server.timeout", "3000"));
    public static final int CON_TIME_OUT_MILLIS = Integer.parseInt(System.getProperty("com.alibaba.ans.shaded.com.taobao.vipserver.address-server.connect.timeout", "1000"));
    private static List<String> vipServers = new ArrayList<String>();
    private static Map<String, List<String>> site2List = new ConcurrentHashMap<String, List<String>>();
    private static List<String> serversWithPort = new ArrayList<String>();
    private static List<String> lastServers = new ArrayList<String>();
    private static Map<String, String> ip2Site = new ConcurrentHashMap<String, String>();
    private static List<Host> vipserverHosts;
    private static List<Host> lastVipserverHosts;
    private static long lastSrvRefTime;
    private static long lastVIPServerSrvRefTime;
    public static String LOCAL_IP;
    private static String serverlistFilePath;
    private static long lastSrvSiteRefreshTime;
    private static long lastLocalHostSiteRefreshTime;
    private static long VIP_SRV_REF_INTER_MILLIS;
    private static final long VIP_SRV_SITE_REF_INTER_MILLIS;
    private static AtomicLong curSrvIndex;
    private static ConcurrentHashMap<String, List<String>> site2serverIP;
    private static String localHostSite;
    private static ScheduledExecutorService executorService;

    private static void loadServerList() {
        try {
            File serverlistFile = new File(serverlistFilePath);
            String content = ConcurrentDiskUtil.getFileContent(serverlistFile, Charset.defaultCharset().toString());
            if (StringUtils.isEmpty(content)) {
                VIPClient.LOG.warn("content from disk  is empty, fileName: " + serverlistFilePath);
            }
            VIPServerProxy.processJSONDom(content);
        }
        catch (Exception e) {
            VIPClient.LOG.warn("failed to load server list from disk.", e);
        }
    }

    private static void classifyServers() {
        try {
            ArrayList<String> ips = new ArrayList<String>();
            ConcurrentHashMap tmpSite2ServerIP = new ConcurrentHashMap();
            if (CollectionUtils.isEmpty(vipServers)) {
                Iterator<String> iterator = serversWithPort.iterator();
                while (iterator.hasNext()) {
                    String ipPort;
                    String ip = ipPort = iterator.next();
                    if (ipPort.contains(":")) {
                        ip = ipPort.split(":")[0];
                    }
                    ips.add(ip);
                }
            } else {
                ips.addAll(vipServers);
            }
            for (String ip : ips) {
                String serverSite = ip2Site.get(ip);
                if (StringUtils.isEmpty(serverSite)) {
                    serverSite = "unknown";
                }
                if (tmpSite2ServerIP.get(serverSite) == null) {
                    tmpSite2ServerIP.put(serverSite, new ArrayList());
                }
                if (((List)tmpSite2ServerIP.get(serverSite)).contains(ip)) continue;
                ((List)tmpSite2ServerIP.get(serverSite)).add(ip);
            }
            lastSrvSiteRefreshTime = System.currentTimeMillis();
            site2serverIP = tmpSite2ServerIP;
        }
        catch (Throwable e) {
            VIPClient.LOG.warn("failed to classify server list", e);
        }
    }

    private static void updateSite(List<String> list) {
        ConcurrentHashMap tmpSite2ServerIP = new ConcurrentHashMap();
        HashMap<String, String> params = new HashMap<String, String>();
        for (String server : list) {
            params.clear();
            params.put("action", "query");
            params.put("ip", server);
            params.put("getServerSite", "true");
            try {
                NodeString serverNode;
                String serverNodeString = VIPServerProxy.reqAPI("armoryNode", params);
                if (StringUtils.isEmpty(serverNodeString) || (serverNode = JSON.parseObject(serverNodeString, NodeString.class)) == null) continue;
                Node node = JSON.parseObject(serverNode.msg, Node.class);
                String serverSite = node.getSite();
                ip2Site.put(server, serverSite);
            }
            catch (Exception e) {
                VIPClient.LOG.warn("fail to query server site: ", e);
            }
        }
        VIPClient.LOG.info("SERVER-LIST", "server site is updated: " + JSON.toJSONString(ip2Site));
    }

    private static void refreshSrvSiteIfNeed() {
        if (!CollectionUtils.isEmpty(serversWithPort)) {
            return;
        }
        try {
            if (System.currentTimeMillis() - lastSrvSiteRefreshTime > VIP_SRV_SITE_REF_INTER_MILLIS || !CollectionUtils.isEqualCollection(vipServers, lastServers)) {
                List<String> newIps = new ArrayList<String>(CollectionUtils.subtract(vipServers, lastServers));
                lastServers = vipServers;
                if (newIps.size() == 0) {
                    newIps = vipServers;
                }
                VIPServerProxy.updateSite(newIps);
                VIPClient.LOG.info("SERVER-LIST", "update site of ips: " + newIps);
            }
        }
        catch (Throwable e) {
            VIPClient.LOG.warn("fail to query server site: ", e);
        }
    }

    private static String getAddressServerUrl() {
        return "http://" + VIPClient.getJmenv() + ADDRESS_SERVER_URL;
    }

    private static void refreshSrvIfNeed() {
        try {
            String serverList = System.getProperty("com.alibaba.ans.shaded.com.taobao.vipserver.serverlist", "");
            if (StringUtils.isNotEmpty(serverList)) {
                serversWithPort = Arrays.asList(serverList.split(","));
            }
            if (!CollectionUtils.isEmpty(serversWithPort)) {
                VIPClient.LOG.info("server list provided by user: " + serversWithPort);
                return;
            }
            if (System.currentTimeMillis() - lastSrvRefTime < VIP_SRV_REF_INTER_MILLIS) {
                return;
            }
            String urlString = VIPServerProxy.getAddressServerUrl();
            List<String> headers = Arrays.asList("User-Agent", "VIPServer-Java-Client:v4.7.6", "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive");
            HttpClient.HttpResult result = HttpClient.httpGet(urlString, headers, null, VIPClient.getEncoding(), TIME_OUT_MILLIS, CON_TIME_OUT_MILLIS);
            if (200 != result.code) {
                throw new IOException("Error while requesting: " + urlString + "'. Server returned: " + result.code);
            }
            String content = result.content;
            ArrayList<String> list = new ArrayList<String>();
            for (String line : IOUtils.readLines(new StringReader(content))) {
                if (line.trim().isEmpty()) continue;
                list.add(line.trim());
            }
            if (list.isEmpty()) {
                throw new Exception("Can not acquire vipserver list");
            }
            if (!CollectionUtils.isEqualCollection(list, vipServers)) {
                VIPClient.LOG.info("SERVER-LIST", "server list is updated: " + list);
            }
            vipServers = list;
            lastSrvRefTime = System.currentTimeMillis();
        }
        catch (Throwable e) {
            VIPClient.LOG.warn("failed to update server list", e);
        }
    }

    public static Domain processJSONDom(String json) {
        try {
            Domain domain = JSON.parseObject(json, Domain.class);
            if (domain == null) {
                throw new IOException("Error while process server list from server, content: " + json);
            }
            List<Host> list = domain.getHosts();
            if (CollectionUtils.isEmpty(list)) {
                throw new Exception("no vipserver server available.");
            }
            if (list.isEmpty()) {
                throw new Exception("Can not acquire vipserver list");
            }
            vipserverHosts = list;
            lastVIPServerSrvRefTime = System.currentTimeMillis();
            return domain;
        }
        catch (Exception e) {
            VIPClient.LOG.warn("failed to process dom json", e);
            return null;
        }
    }

    public static ConcurrentHashMap<String, List<String>> getSameSiteServers(String ip) {
        List<String> snapshot = vipServers;
        ConcurrentHashMap<String, List<String>> servers = new ConcurrentHashMap<String, List<String>>();
        if (!CollectionUtils.isEmpty(serversWithPort)) {
            servers.put("sameSite", serversWithPort);
            servers.put("otherSite", new ArrayList());
            return servers;
        }
        if (UtilAndComs.mock) {
            servers.put("sameSite", snapshot);
            servers.put("otherSite", new ArrayList());
            return servers;
        }
        servers.put("sameSite", new ArrayList());
        servers.put("otherSite", new ArrayList());
        if (!StringUtils.isEmpty(ip) || StringUtils.isEmpty(localHostSite) || System.currentTimeMillis() - lastLocalHostSiteRefreshTime > VIP_SRV_SITE_REF_INTER_MILLIS) {
            try {
                NodeString nodeString;
                String localHostIP = InetAddress.getLocalHost().getHostAddress();
                if (StringUtils.isEmpty(localHostIP)) {
                    servers.put("otherSite", snapshot);
                }
                if (!StringUtils.isEmpty(ip)) {
                    localHostIP = ip;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "query");
                params.put("ip", localHostIP);
                params.put("getServerSite", "true");
                String localhostNodeString = VIPServerProxy.reqAPI("armoryNode", params);
                if (StringUtils.isEmpty(localhostNodeString)) {
                    VIPClient.LOG.info("can not query localHost from armory.");
                    servers.put("otherSite", snapshot);
                }
                if ((nodeString = JSON.parseObject(localhostNodeString, NodeString.class)) == null) {
                    VIPClient.LOG.info("can not query localHost from armory.");
                    servers.put("otherSite", snapshot);
                    return servers;
                }
                Node localHostNode = JSON.parseObject(nodeString.msg, Node.class);
                if (localHostNode == null) {
                    VIPClient.LOG.info("can not query localHost from armory.");
                    servers.put("otherSite", snapshot);
                    return servers;
                }
                localHostSite = localHostNode.getSite();
                List<String> sameSite = site2serverIP.get(localHostSite);
                if (sameSite == null) {
                    sameSite = new ArrayList<String>();
                }
                servers.put("sameSite", sameSite);
                servers.put("otherSite", new ArrayList(CollectionUtils.subtract(snapshot, sameSite)));
                lastLocalHostSiteRefreshTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                servers.put("otherSite", snapshot);
                VIPClient.LOG.warn("failed to get same site servers: ", e);
            }
        } else {
            List<String> sameSite = site2serverIP.get(localHostSite);
            if (sameSite == null) {
                sameSite = new ArrayList<String>();
            }
            servers.put("sameSite", sameSite);
            servers.put("otherSite", new ArrayList(CollectionUtils.subtract(snapshot, sameSite)));
        }
        VIPClient.LOG.debug("sameSiteServers:" + servers.toString());
        return servers;
    }

    public static void regDom(String dom, String ip, int port, float weight, String cluster, Map<String, Object> metadata) throws Exception {
        String meta = JSON.toJSONString(metadata);
        if (meta.length() >= 20480) {
            throw new IllegalArgumentException("metadata is too long, must be less than 20kB");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dom", dom);
        params.put("ip", ip);
        params.put("port", String.valueOf(port));
        params.put("weight", String.valueOf(weight));
        params.put("cluster", cluster);
        params.put("properties", meta);
        try {
            VIPServerProxy.doRegDom(params);
        }
        catch (Exception e) {
            Thread.sleep(1000L);
            VIPServerProxy.doRegDom(params);
        }
    }

    private static String doRegDom(Map<String, String> params) throws Exception {
        String api = "regService";
        return VIPServerProxy.reqAPI(api, params);
    }

    public static void deRegDom(String dom, String ip, int port, String cluster) throws Exception {
        List<String> doms = Arrays.asList(dom.split(","));
        String api = "deRegService";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ip", ip);
        params.put("port", String.valueOf(port));
        params.put("cluster", cluster);
        for (String domName : doms) {
            params.put("dom", domName);
            try {
                VIPServerProxy.reqAPI(api, params);
                VIPClient.dom2Beat.remove(dom);
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "faild to deRegDom: " + JSON.toJSONString(params), e);
            }
        }
    }

    public static String reqAPIAsync(final String api, final Map<String, String> params, long timeout) {
        FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return VIPServerProxy.reqAPI(api, params);
            }
        });
        Thread getDomThread = new Thread(futureTask);
        getDomThread.start();
        if (timeout <= 0L) {
            timeout = 10000L;
        }
        try {
            return futureTask.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            VIPClient.LOG.error("[reqAPI]", "api:" + api + "params: " + JSON.toJSONString(params), e);
        }
        catch (ExecutionException e) {
            VIPClient.LOG.error("[reqAPI]", "api:" + api + "params: " + JSON.toJSONString(params), e);
        }
        catch (TimeoutException e) {
            VIPClient.LOG.error("[reqAPI]", "api:" + api + "params: " + JSON.toJSONString(params), e);
        }
        throw new IllegalStateException("failed to req API:/api/" + api + " after " + 10000L + " ms.");
    }

    public static String reqAPI(String api, Map<String, String> params, long timeout) {
        return VIPServerProxy.reqAPIAsync(api, params, timeout);
    }

    private static String getSignature(String signData) throws Exception {
        return SpasUtil.sign(signData, TenantInfo.tenantSK);
    }

    private static String getSignData(Map<String, String> params) {
        String data = "";
        if (params.containsKey("dom")) {
            return String.valueOf(System.currentTimeMillis()) + "@@" + params.get("dom");
        }
        return String.valueOf(System.currentTimeMillis());
    }

    public static String callAllSites(String api, Map<String, String> params) throws Exception {
        VIPServerProxy.setParams(params);
        String result = "";
        for (Map.Entry<String, List<String>> entry : site2serverIP.entrySet()) {
            try {
                if (entry.getValue().size() == 0) continue;
                result = VIPServerProxy.reqAPI(api, params, entry.getValue());
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "req api:" + api + " failed, site (" + entry.getKey() + "), servers: " + entry.getValue(), e);
            }
        }
        if (StringUtils.isNotEmpty(result)) {
            return result;
        }
        throw new IllegalStateException("failed to req API:/api/" + api + " after all sites(" + vipServers + ") tried");
    }

    private static void setParams(Map<String, String> params) throws Exception {
        if (StringUtils.isNotEmpty(TenantInfo.tenantId)) {
            String signData = VIPServerProxy.getSignData(params);
            String signature = VIPServerProxy.getSignature(signData);
            params.put("signature", signature);
            params.put("data", signData);
            params.put("tid", TenantInfo.tenantId);
            String ak = System.getProperty("vipserver.test.ak", "");
            if (StringUtils.isNotEmpty(ak)) {
                params.put("ak", ak);
            } else {
                params.put("ak", TenantInfo.tenantAk);
            }
        }
        params.put("app", TenantInfo.tenantApp);
        params.put("env", TenantInfo.tenantEnv);
    }

    public static String reqAPI(String api, Map<String, String> params) throws Exception {
        VIPServerProxy.setParams(params);
        if (!(vipServers != null && vipServers.size() > 0 || serversWithPort != null && serversWithPort.size() > 0)) {
            throw new IllegalStateException("no vipserver available");
        }
        int loopCount = vipServers.size();
        List<String> snapshot = vipServers;
        if (!CollectionUtils.isEmpty(serversWithPort)) {
            snapshot = serversWithPort;
            loopCount = serversWithPort.size();
        }
        ConcurrentHashMap<String, List<String>> classifiedServers = null;
        for (int i = 0; i < loopCount; ++i) {
            String curServer;
            if (params.containsKey("getServerSite") && params.get("getServerSite").equals("true")) {
                curServer = snapshot.get((int)curSrvIndex.incrementAndGet() % snapshot.size());
            } else {
                if (classifiedServers == null) {
                    classifiedServers = VIPServerProxy.getSameSiteServers("");
                }
                if (classifiedServers.size() <= 0) {
                    throw new IllegalArgumentException("no vipserver available");
                }
                List<String> sameSiteServers = classifiedServers.get("sameSite");
                List<String> otherSiteServers = classifiedServers.get("otherSite");
                VIPClient.LOG.debug("sameSite: " + sameSiteServers.toString());
                VIPClient.LOG.debug("otherSite: " + otherSiteServers.toString());
                int totalSameSiteServers = sameSiteServers.size();
                int totalOtherSiteServers = otherSiteServers.size();
                if (i < totalSameSiteServers) {
                    curServer = sameSiteServers.get((int)(curSrvIndex.incrementAndGet() % (long)totalSameSiteServers));
                    VIPClient.LOG.debug("sameSiteServer: " + curServer);
                } else if (totalOtherSiteServers > 0) {
                    curServer = otherSiteServers.get((int)(curSrvIndex.incrementAndGet() % (long)totalOtherSiteServers));
                    VIPClient.LOG.debug("otherSiteServer: " + curServer);
                } else {
                    throw new IllegalArgumentException("no vipserver available");
                }
            }
            try {
                return VIPServerProxy.callServer(api, params, curServer);
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "req api:" + api + " failed, server(" + curServer + ")", e);
                continue;
            }
        }
        throw new IllegalStateException("failed to req API:/api/" + api + " after all servers(" + vipServers + ") tried");
    }

    public static String callServer(String api, Map<String, String> params, String curServer) throws Exception {
        List<String> headers = Arrays.asList("User-Agent", "VIPServer-Java-Client:v4.7.6", "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive");
        String mockServer = System.getProperty("vipserver.mock.server", "");
        if (!mockServer.equals("")) {
            curServer = mockServer;
        }
        String url = "";
        url = curServer.contains(":") ? HttpClient.getPrefix() + curServer + "/vipserver/api/" + api : HttpClient.getPrefix() + curServer + ":" + HttpClient.getServerPort() + "/vipserver/api/" + api;
        HttpClient.HttpResult result = HttpClient.httpGet(url, headers, params, VIPClient.getEncoding());
        if (200 == result.code) {
            return result.content;
        }
        if (304 == result.code) {
            return "";
        }
        throw new IOException("failed to req API:" + HttpClient.getPrefix() + curServer + ":" + HttpClient.getServerPort() + "/vipserver/api/" + api + ". code:" + result.code + " msg: " + result.content);
    }

    public static String localIP() {
        try {
            if (!StringUtils.isEmpty(LOCAL_IP)) {
                return LOCAL_IP;
            }
            String localIP = System.getProperty("com.alibaba.ans.shaded.com.taobao.vipserver.localIP", "");
            LOCAL_IP = !StringUtils.isEmpty(localIP) ? localIP : InetAddress.getLocalHost().getHostAddress();
            return LOCAL_IP;
        }
        catch (UnknownHostException e) {
            return "resolve_failed";
        }
    }

    public static void updateLocalHostSite() {
        try {
            String localHostIP = VIPServerProxy.localIP();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", "query");
            params.put("ip", localHostIP);
            params.put("getServerSite", "true");
            String localhostNodeString = VIPServerProxy.reqAPI("armoryNode", params);
            if (StringUtils.isEmpty(localhostNodeString)) {
                return;
            }
            NodeString nodeString = JSON.parseObject(localhostNodeString, NodeString.class);
            if (nodeString == null) {
                return;
            }
            Node localHostNode = JSON.parseObject(nodeString.msg, Node.class);
            if (!StringUtils.isEmpty(localHostNode.getSite())) {
                localHostSite = localHostNode.getSite();
            }
        }
        catch (Throwable e) {
            VIPClient.LOG.warn("failed to get site of localhost.", e);
        }
    }

    public static String getLocalHostSite() {
        if (localHostSite == null || localHostSite.equals("")) {
            VIPServerProxy.updateLocalHostSite();
        }
        return localHostSite;
    }

    public static String reqAPI(String api, Map<String, String> params, List<String> servers) {
        if (servers.size() == 0) {
            throw new IllegalArgumentException("no server available");
        }
        Random random = new Random(System.currentTimeMillis());
        int index = random.nextInt(servers.size());
        boolean count = false;
        for (int i = 0; i < servers.size(); ++i) {
            String server = servers.get(index);
            try {
                String result = VIPServerProxy.callServer(api, params, server);
                return result;
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "req api:" + api + " failed, server(" + server + ")", e);
                index = (index + 1) % servers.size();
                continue;
            }
        }
        throw new IllegalStateException("failed to req API:/api/" + api + " after all servers(" + servers + ") tried");
    }

    public static void main(String[] args) throws Exception {
        VIPServerProxy.refreshSrvIfNeed();
    }

    static {
        lastSrvRefTime = 0L;
        lastVIPServerSrvRefTime = 0L;
        serverlistFilePath = System.getProperty("user.home") + File.separator + "vipsrv-cache" + File.separator + "00-00---000-VIPSRV_SERVERR_LIST-000---00-00";
        lastSrvSiteRefreshTime = 0L;
        lastLocalHostSiteRefreshTime = 0L;
        VIP_SRV_REF_INTER_MILLIS = TimeUnit.SECONDS.toMillis(30L);
        VIP_SRV_SITE_REF_INTER_MILLIS = TimeUnit.HOURS.toMillis(12L);
        curSrvIndex = new AtomicLong(RandomUtils.nextInt() % Short.MAX_VALUE);
        site2serverIP = new ConcurrentHashMap();
        localHostSite = "";
        executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("VIPSERVER-SERVERLIST-UPDATER");
                t.setDaemon(true);
                return t;
            }
        });
        executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                VIPServerProxy.refreshSrvIfNeed();
                VIPServerProxy.refreshSrvSiteIfNeed();
                VIPServerProxy.classifyServers();
            }
        }, 0L, VIP_SRV_REF_INTER_MILLIS, TimeUnit.MILLISECONDS);
        executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                VIPServerProxy.getLocalHostSite();
            }
        }, 0L, VIP_SRV_SITE_REF_INTER_MILLIS, TimeUnit.MILLISECONDS);
        VIPServerProxy.refreshSrvIfNeed();
        VIPServerProxy.refreshSrvSiteIfNeed();
        VIPServerProxy.classifyServers();
    }

    public static class Node {
        private String dns_ip;
        private String site;
        private String nodegroup;
        private String nodename;
        private String appName;
        private String state;
        private String app_use_type;
        public long birthTime = -1L;

        public void setBirthTime(long birthTime) {
            this.birthTime = birthTime;
        }

        public String getNodegroup() {
            return this.nodegroup;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setNodegroup(String nodegroup) {
            this.nodegroup = nodegroup;
        }

        public String getNodename() {
            return this.nodename;
        }

        public void setNodename(String nodename) {
            this.nodename = nodename;
        }

        public String getSite() {
            return this.site;
        }

        public void setSite(String site) {
            this.site = site;
        }

        public String getDns_ip() {
            return this.dns_ip;
        }

        public void setDns_ip(String dns_ip) {
            this.dns_ip = dns_ip;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getApp_use_type() {
            return this.app_use_type;
        }

        public void setApp_use_type(String app_use_type) {
            this.app_use_type = app_use_type;
        }
    }

    public static class NodeString {
        String msg;

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

