/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.Env;
import com.alibaba.csp.sentinel.ErrorEntryFreeException;
import com.alibaba.csp.sentinel.Sph;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.context.NullContext;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slotchain.MethodResourceWrapper;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotChain;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slotchain.StringResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CtSph
implements Sph {
    private static final Object[] OBJECTS0 = new Object[0];
    private static Map<ResourceWrapper, ProcessorSlotChain> chainMap = new HashMap<ResourceWrapper, ProcessorSlotChain>();
    private static final Object LOCK = new Object();

    public Entry entry(ResourceWrapper resourceWrapper, int count, Object ... args) throws BlockException {
        Context context = ContextUtil.getContext();
        if (context instanceof NullContext) {
            return new CtEntry(resourceWrapper, null, context);
        }
        if (context == null) {
            context = MyContextUtil.myEnter("default_context_name", "", resourceWrapper.getType());
        }
        if (!Constants.ON) {
            return new CtEntry(resourceWrapper, null, context);
        }
        ProcessorSlot<Object> chain = this.lookProcessChain(resourceWrapper);
        if (chain == null) {
            return new CtEntry(resourceWrapper, null, context);
        }
        CtEntry e = new CtEntry(resourceWrapper, chain, context);
        try {
            chain.entry(context, resourceWrapper, null, count, args);
        }
        catch (BlockException e1) {
            ((Entry)e).exit(count, args);
            throw e1;
        }
        catch (Throwable e1) {
            RecordLog.info("sentinel unexpected exception", e1);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessorSlot<Object> lookProcessChain(ResourceWrapper resourceWrapper) {
        ProcessorSlotChain chain = chainMap.get(resourceWrapper);
        if (chain == null) {
            Object object = LOCK;
            synchronized (object) {
                chain = chainMap.get(resourceWrapper);
                if (chain == null) {
                    if (chainMap.size() >= 6000) {
                        return null;
                    }
                    chain = Env.slotsChainbuilder.build();
                    HashMap<ResourceWrapper, ProcessorSlotChain> newMap = new HashMap<ResourceWrapper, ProcessorSlotChain>(chainMap.size() + 1);
                    newMap.putAll(chainMap);
                    newMap.put(resourceWrapper, chain);
                    chainMap = newMap;
                }
            }
        }
        return chain;
    }

    @Override
    public Entry entry(String name) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, EntryType.OUT);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, EntryType.OUT);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(String name, EntryType type) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, 1, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type, int count) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(String name, EntryType type, int count) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, int count) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, EntryType.OUT);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(String name, int count) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, EntryType.OUT);
        return this.entry(resource, count, OBJECTS0);
    }

    @Override
    public Entry entry(Method method, EntryType type, int count, Object ... args) throws BlockException {
        MethodResourceWrapper resource = new MethodResourceWrapper(method, type);
        return this.entry(resource, count, args);
    }

    @Override
    public Entry entry(String name, EntryType type, int count, Object ... args) throws BlockException {
        StringResourceWrapper resource = new StringResourceWrapper(name, type);
        return this.entry(resource, count, args);
    }

    private static final class MyContextUtil
    extends ContextUtil {
        private MyContextUtil() {
        }

        static Context myEnter(String name, String origin, EntryType type) {
            return MyContextUtil.trueEnter(name, origin);
        }
    }

    private static class CtEntry
    extends Entry {
        protected Entry parent = null;
        protected Entry child = null;
        private ProcessorSlot<Object> chain;
        private Context context;

        CtEntry(ResourceWrapper resourceWrapper, ProcessorSlot<Object> chain, Context context) {
            super(resourceWrapper);
            this.chain = chain;
            this.context = context;
            this.parent = context.getCurEntry();
            if (this.parent != null) {
                ((CtEntry)this.parent).child = this;
            }
            context.setCurEntry(this);
        }

        @Override
        public void exit(int count, Object ... args) throws ErrorEntryFreeException {
            this.trueExit(count, args);
        }

        @Override
        protected Entry trueExit(int count, Object ... args) throws ErrorEntryFreeException {
            if (this.context != null) {
                if (this.context.getCurEntry() != this) {
                    CtEntry e = (CtEntry)this.context.getCurEntry();
                    while (e != null) {
                        e.exit(count, args);
                        e = (CtEntry)e.parent;
                    }
                    throw new ErrorEntryFreeException("The order of entry free is can't be paired with the order of entry");
                }
                if (this.chain != null) {
                    this.chain.exit(this.context, this.resourceWrapper, count, args);
                }
                this.context.setCurEntry(this.parent);
                if (this.parent != null) {
                    ((CtEntry)this.parent).child = null;
                }
                if (this.parent == null) {
                    ContextUtil.exit();
                }
                this.context = null;
            }
            return this.parent;
        }

        @Override
        public Node getLastNode() {
            return this.parent == null ? null : this.parent.getCurNode();
        }
    }
}

