/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.config;

import com.alibaba.csp.sentinel.log.LogBase;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SentinelConfig {
    private static final Map<String, String> props = new ConcurrentHashMap<String, String>();
    public static final String CHARSET = "csp.sentinel.charset";
    public static final String SINGLE_METRIC_FILE_SIZE = "csp.sentinel.metric.file.single.size";
    public static final String TOTAL_METRIC_FILE_COUNT = "csp.sentinel.metric.file.total.count";
    public static final String COLD_FACTOR = "csp.sentinel.flow.cold.factor";
    static final long DEFAULT_SINGLE_METRIC_FILE_SIZE = 0x3200000L;
    static final int DEFAULT_TOTAL_METRIC_FILE_COUNT = 6;

    private static void initialize() {
        SentinelConfig.setConfig(CHARSET, "UTF-8");
        SentinelConfig.setConfig(SINGLE_METRIC_FILE_SIZE, String.valueOf(0x3200000L));
        SentinelConfig.setConfig(TOTAL_METRIC_FILE_COUNT, String.valueOf(6));
        SentinelConfig.setConfig(COLD_FACTOR, String.valueOf(3));
    }

    private static void loadProps() {
        block8: {
            AppNameUtil.resolveAppName();
            try {
                String fileName;
                File file;
                String appName = AppNameUtil.getAppName();
                if (appName == null) {
                    appName = "";
                }
                if (!(file = new File(fileName = LogBase.getLogBaseDir() + appName + ".properties")).exists()) break block8;
                RecordLog.info("read SentinelConfig from " + fileName);
                FileInputStream fis = new FileInputStream(fileName);
                Properties fileProps = new Properties();
                fileProps.load(fis);
                fis.close();
                for (Object key : fileProps.keySet()) {
                    SentinelConfig.setConfig((String)key, (String)fileProps.get(key));
                    try {
                        String systemValue = System.getProperty((String)key);
                        if (!StringUtil.isEmpty(systemValue)) {
                            SentinelConfig.setConfig((String)key, systemValue);
                        }
                    }
                    catch (Exception e) {
                        RecordLog.info(e.getMessage(), e);
                    }
                    RecordLog.info(key + " value: " + SentinelConfig.getConfig((String)key));
                }
            }
            catch (Throwable ioe) {
                RecordLog.info(ioe.getMessage(), ioe);
            }
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            SentinelConfig.setConfig(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public static String getConfig(String key) {
        return props.get(key);
    }

    public static void setConfig(String key, String value) {
        props.put(key, value);
    }

    public static void setConfigIfAbsent(String key, String value) {
        String v = props.get(key);
        if (v == null) {
            props.put(key, value);
        }
    }

    public static String getAppName() {
        return AppNameUtil.getAppName();
    }

    public static String charset() {
        return props.get(CHARSET);
    }

    public static long singleMetricFileSize() {
        try {
            return Long.parseLong(props.get(SINGLE_METRIC_FILE_SIZE));
        }
        catch (Throwable throwable) {
            RecordLog.info("SentinelConfig get singleMetricFileSize fail, use default value: 52428800", throwable);
            return 0x3200000L;
        }
    }

    public static int totalMetricFileCount() {
        try {
            return Integer.parseInt(props.get(TOTAL_METRIC_FILE_COUNT));
        }
        catch (Throwable throwable) {
            RecordLog.info("SentinelConfig get totalMetricFileCount fail, use default value: 6", throwable);
            return 6;
        }
    }

    static {
        SentinelConfig.initialize();
        SentinelConfig.loadProps();
    }
}

