/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.context;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.Node;

public class Context {
    private String name;
    private DefaultNode entranceNode;
    private Entry curEntry;
    private String origin = "";

    public Context(DefaultNode entranceNode, String name) {
        this.name = name;
        this.entranceNode = entranceNode;
    }

    public String getName() {
        return this.name;
    }

    public Node getCurNode() {
        return this.curEntry.getCurNode();
    }

    public void setCurNode(Node node) {
        this.curEntry.setCurNode(node);
    }

    public Entry getCurEntry() {
        return this.curEntry;
    }

    public void setCurEntry(Entry curEntry) {
        this.curEntry = curEntry;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public double getOriginTotalQps() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().totalQps();
    }

    public double getOriginBlockedQps() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().blockedQps();
    }

    public double getOriginPassedReqQps() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().successQps();
    }

    public double getOriginPassedQps() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().passQps();
    }

    public long getOriginTotalRequest() {
        return this.getOriginNode() == null ? 0L : this.getOriginNode().totalRequest();
    }

    public long getOriginBlockedRequest() {
        return this.getOriginNode() == null ? 0L : this.getOriginNode().blockedRequest();
    }

    public double getOriginAvgRt() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().avgRt();
    }

    public int getOriginCurThreadNum() {
        return this.getOriginNode() == null ? 0 : this.getOriginNode().curThreadNum();
    }

    public DefaultNode getEntranceNode() {
        return this.entranceNode;
    }

    public Node getLastNode() {
        if (this.curEntry != null && this.curEntry.getLastNode() != null) {
            return this.curEntry.getLastNode();
        }
        return this.entranceNode;
    }

    public Node getOriginNode() {
        return this.curEntry == null ? null : this.curEntry.getOriginNode();
    }
}

