/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;

public class EntranceNode
extends DefaultNode {
    public EntranceNode(ResourceWrapper id, ClusterNode clusterNode) {
        super(id, clusterNode);
    }

    @Override
    public long avgRt() {
        long rt = 0L;
        long totalQps = 0L;
        for (Node node : this.getChildList()) {
            rt += node.avgRt() * node.passQps();
            totalQps += node.passQps();
        }
        return rt / (totalQps == 0L ? 1L : totalQps);
    }

    @Override
    public long blockedQps() {
        int blockQps = 0;
        for (Node node : this.getChildList()) {
            blockQps = (int)((long)blockQps + node.blockedQps());
        }
        return blockQps;
    }

    @Override
    public long blockedRequest() {
        long r = 0L;
        for (Node node : this.getChildList()) {
            r += node.blockedRequest();
        }
        return r;
    }

    @Override
    public int curThreadNum() {
        int r = 0;
        for (Node node : this.getChildList()) {
            r += node.curThreadNum();
        }
        return r;
    }

    @Override
    public long totalQps() {
        int r = 0;
        for (Node node : this.getChildList()) {
            r = (int)((long)r + node.totalQps());
        }
        return r;
    }

    @Override
    public long successQps() {
        int r = 0;
        for (Node node : this.getChildList()) {
            r = (int)((long)r + node.successQps());
        }
        return r;
    }

    @Override
    public long passQps() {
        int r = 0;
        for (Node node : this.getChildList()) {
            r = (int)((long)r + node.passQps());
        }
        return r;
    }

    @Override
    public long totalRequest() {
        long r = 0L;
        for (Node node : this.getChildList()) {
            r += node.totalRequest();
        }
        return r;
    }
}

