/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.property.SimplePropertyListener;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;

public class SampleCountProperty {
    public static volatile int sampleCount = 2;

    public static void init(SentinelProperty<Integer> property) {
        try {
            property.addListener((PropertyListener<Integer>)new SimplePropertyListener<Integer>(){

                @Override
                public void configUpdate(Integer value) {
                    if (value != null) {
                        sampleCount = value;
                        for (ClusterNode node : ClusterBuilderSlot.getClusterNodeMap().values()) {
                            node.reset();
                        }
                    }
                    RecordLog.info("Current SampleCount: " + sampleCount);
                }
            });
        }
        catch (Exception e) {
            RecordLog.info(e.getMessage(), e);
        }
    }
}

