/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.system;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.property.SimplePropertyListener;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemStatusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SystemRuleManager {
    private static volatile double highestSystemLoad = Double.MAX_VALUE;
    private static volatile double qps = Double.MAX_VALUE;
    private static volatile long maxRt = Long.MAX_VALUE;
    private static volatile long maxThread = Long.MAX_VALUE;
    private static volatile boolean highestSystemLoadIsSet = false;
    private static volatile boolean qpsIsSet = false;
    private static volatile boolean maxRtIsSet = false;
    private static volatile boolean maxThreadIsSet = false;
    static AtomicBoolean checkSystemStatus = new AtomicBoolean(false);
    private static SystemStatusListener statusListener = null;
    private static final SystemPropertyListener listener = new SystemPropertyListener();
    private static SentinelProperty<List<SystemRule>> currentProperty = new DynamicSentinelProperty<List<SystemRule>>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<SystemRule>> property) {
        SystemPropertyListener systemPropertyListener = listener;
        synchronized (systemPropertyListener) {
            currentProperty.removeListener(listener);
            property.addListener(listener);
            currentProperty = property;
        }
    }

    public static void loadRules(List<SystemRule> rules) {
        currentProperty.updateValue(rules);
    }

    public static List<SystemRule> getRules() {
        ArrayList<SystemRule> result = new ArrayList<SystemRule>();
        if (!checkSystemStatus.get()) {
            return result;
        }
        if (highestSystemLoadIsSet) {
            SystemRule loadRule = new SystemRule();
            loadRule.setHighestSystemLoad(highestSystemLoad);
            result.add(loadRule);
        }
        if (maxRtIsSet) {
            SystemRule rtRule = new SystemRule();
            rtRule.setAvgRt(maxRt);
            result.add(rtRule);
        }
        if (maxThreadIsSet) {
            SystemRule threadRule = new SystemRule();
            threadRule.setMaxThread(maxThread);
            result.add(threadRule);
        }
        if (qpsIsSet) {
            SystemRule qpsRule = new SystemRule();
            qpsRule.setQps(qps);
            result.add(qpsRule);
        }
        return result;
    }

    public static double getQps() {
        return qps;
    }

    public static void setQps(double qps) {
        SystemRuleManager.qps = qps;
    }

    public static long getMaxRt() {
        return maxRt;
    }

    public static long getMaxThread() {
        return maxThread;
    }

    public static Boolean getCheckSystemStatus() {
        return checkSystemStatus.get();
    }

    public static double getHighestSystemLoad() {
        return highestSystemLoad;
    }

    public static void setHighestSystemLoad(double highestSystemLoad) {
        SystemRuleManager.highestSystemLoad = highestSystemLoad;
    }

    public static void loadSystemConf(SystemRule rule) {
        boolean checkStatus = false;
        if (rule.getHighestSystemLoad() > 0.0) {
            highestSystemLoad = Math.min(highestSystemLoad, rule.getHighestSystemLoad());
            highestSystemLoadIsSet = true;
            checkStatus = true;
        }
        if (rule.getAvgRt() > 0L) {
            maxRt = Math.min(maxRt, rule.getAvgRt());
            maxRtIsSet = true;
            checkStatus = true;
        }
        if (rule.getMaxThread() > 0L) {
            maxThread = Math.min(maxThread, rule.getMaxThread());
            maxThreadIsSet = true;
            checkStatus = true;
        }
        if (rule.getQps() > 0.0) {
            qps = Math.min(qps, rule.getQps());
            qpsIsSet = true;
            checkStatus = true;
        }
        checkSystemStatus.set(checkStatus);
    }

    public static void checkSystem(ResourceWrapper resourceWrapper) throws BlockException {
        double rt;
        int currentThread;
        double currentQps;
        if (!checkSystemStatus.get()) {
            return;
        }
        if (resourceWrapper.getType() != EntryType.IN) {
            return;
        }
        double d = currentQps = Constants.ENTRY_NODE == null ? 0.0 : (double)Constants.ENTRY_NODE.successQps();
        if (currentQps > qps) {
            throw new SystemBlockException(resourceWrapper.getName(), "qps");
        }
        int n = currentThread = Constants.ENTRY_NODE == null ? 0 : Constants.ENTRY_NODE.curThreadNum();
        if ((long)currentThread > maxThread) {
            throw new SystemBlockException(resourceWrapper.getName(), "thread");
        }
        double d2 = rt = Constants.ENTRY_NODE == null ? 0.0 : (double)Constants.ENTRY_NODE.avgRt();
        if (rt > (double)maxRt) {
            throw new SystemBlockException(resourceWrapper.getName(), "rt");
        }
        if (highestSystemLoadIsSet && SystemRuleManager.getCurrentSystemAvgLoad() > highestSystemLoad && currentThread > 1 && (long)currentThread > Constants.ENTRY_NODE.maxSuccessQps() * Constants.ENTRY_NODE.minRt() / 1000L) {
            throw new SystemBlockException(resourceWrapper.getName(), "load");
        }
    }

    public static double getCurrentSystemAvgLoad() {
        return statusListener.getSystemAverageLoad();
    }

    static {
        checkSystemStatus.set(false);
        statusListener = new SystemStatusListener();
        scheduler.scheduleAtFixedRate(statusListener, 5L, 1L, TimeUnit.SECONDS);
        currentProperty.addListener(listener);
    }

    static class SystemPropertyListener
    extends SimplePropertyListener<List<SystemRule>> {
        SystemPropertyListener() {
        }

        @Override
        public void configUpdate(List<SystemRule> rules) {
            this.restoreSetting();
            if (rules != null && rules.size() >= 1) {
                for (SystemRule rule : rules) {
                    SystemRuleManager.loadSystemConf(rule);
                }
            } else {
                checkSystemStatus.set(false);
            }
            RecordLog.info("current system system status : " + checkSystemStatus.get());
            RecordLog.info("current highestSystemLoad status : " + highestSystemLoad);
            RecordLog.info("current maxRt : " + maxRt);
            RecordLog.info("current maxThread : " + maxThread);
            RecordLog.info("current qps : " + qps);
        }

        protected void restoreSetting() {
            checkSystemStatus.set(false);
            highestSystemLoad = Double.MAX_VALUE;
            maxRt = Long.MAX_VALUE;
            maxThread = Long.MAX_VALUE;
            qps = Double.MAX_VALUE;
            highestSystemLoadIsSet = false;
            maxRtIsSet = false;
            maxThreadIsSet = false;
            qpsIsSet = false;
        }
    }
}

