/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.util;

import com.alibaba.csp.sentinel.log.RecordLog;
import java.io.File;

public final class AppNameUtil {
    public static final String APP_NAME = "project.name";
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static String appName;

    private AppNameUtil() {
    }

    public static void resolveAppName() {
        String app = System.getProperty(APP_NAME);
        if (!AppNameUtil.isEmpty(app)) {
            appName = app;
            return;
        }
        String command = System.getProperty(SUN_JAVA_COMMAND);
        if (AppNameUtil.isEmpty(command)) {
            return;
        }
        if ((command = command.split("\\s")[0]).contains(File.separator)) {
            String[] strs = command.split(File.separator);
            command = strs[strs.length - 1];
        }
        if (command.endsWith(".jar") || command.endsWith(".JAR")) {
            command = command.substring(0, command.length() - 4);
        }
        appName = command;
    }

    public static String getAppName() {
        return appName;
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    static {
        AppNameUtil.resolveAppName();
        RecordLog.info("app name resolved: " + appName);
    }
}

