/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.filters;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.netflix.zuul.context.RequestContext;
import java.util.Deque;

final class SentinelEntryUtils {
    static void tryExitFromCurrentContext() {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (ctx.containsKey((Object)"_sentinel_entries")) {
            Deque asyncEntries = (Deque)ctx.get((Object)"_sentinel_entries");
            while (!asyncEntries.isEmpty()) {
                AsyncEntry entry = (AsyncEntry)asyncEntries.pop();
                entry.exit();
            }
            ctx.remove((Object)"_sentinel_entries");
        }
        ContextUtil.exit();
    }

    static void tryTraceExceptionThenExitFromCurrentContext(Throwable t) {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (ctx.containsKey((Object)"_sentinel_entries")) {
            Deque asyncEntries = (Deque)ctx.get((Object)"_sentinel_entries");
            while (!asyncEntries.isEmpty()) {
                AsyncEntry entry = (AsyncEntry)asyncEntries.pop();
                Tracer.traceEntry((Throwable)t, (Entry)entry);
                entry.exit();
            }
            ctx.remove((Object)"_sentinel_entries");
        }
        ContextUtil.exit();
    }

    private SentinelEntryUtils() {
    }
}

