/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.spring.stat;

import com.alibaba.druid.support.spring.stat.SpringMethodInfo;
import com.alibaba.druid.support.spring.stat.SpringMethodStat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SpringStat {
    private ConcurrentMap<SpringMethodInfo, SpringMethodStat> methodStats = new ConcurrentHashMap<SpringMethodInfo, SpringMethodStat>();

    public void reset() {
        for (SpringMethodStat stat : this.methodStats.values()) {
            stat.reset();
        }
    }

    public SpringMethodStat getMethodStat(SpringMethodInfo methodInfo, boolean create) {
        SpringMethodStat methodStat = (SpringMethodStat)this.methodStats.get(methodInfo);
        if (methodStat != null) {
            return methodStat;
        }
        if (create) {
            this.methodStats.putIfAbsent(methodInfo, new SpringMethodStat(methodInfo));
            methodStat = (SpringMethodStat)this.methodStats.get(methodInfo);
        }
        return methodStat;
    }

    public List<Map<String, Object>> getMethodStatDataList() {
        ArrayList<Map<String, Object>> methodStatDataList = new ArrayList<Map<String, Object>>(this.methodStats.size());
        for (SpringMethodStat methodStat : this.methodStats.values()) {
            Map<String, Object> methodStatData = methodStat.getStatData();
            int runningCount = ((Number)methodStatData.get("RunningCount")).intValue();
            long executeCount = (Long)methodStatData.get("ExecuteCount");
            if (runningCount == 0 && executeCount == 0L) continue;
            methodStatDataList.add(methodStatData);
        }
        return methodStatDataList;
    }

    public Map<String, Object> getMethodStatData(String clazz, String method) {
        for (SpringMethodStat methodStat : this.methodStats.values()) {
            SpringMethodInfo methodInfo = methodStat.getMethodInfo();
            if (!methodInfo.getClassName().equals(clazz) || !methodInfo.getSignature().equals(method)) continue;
            return methodStat.getStatData();
        }
        return null;
    }
}

