/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallSqlFunctionStat;
import com.alibaba.druid.wall.WallSqlTableStat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class WallSqlStat {
    private volatile long executeCount;
    private volatile long effectRowCount;
    static final AtomicLongFieldUpdater<WallSqlStat> executeCountUpdater = AtomicLongFieldUpdater.newUpdater(WallSqlStat.class, "executeCount");
    static final AtomicLongFieldUpdater<WallSqlStat> effectRowCountUpdater = AtomicLongFieldUpdater.newUpdater(WallSqlStat.class, "effectRowCount");
    private final Map<String, WallSqlTableStat> tableStats;
    private final List<Violation> violations;
    private final Map<String, WallSqlFunctionStat> functionStats;
    private final boolean syntaxError;

    public WallSqlStat(Map<String, WallSqlTableStat> tableStats, Map<String, WallSqlFunctionStat> functionStats, boolean syntaxError) {
        this(tableStats, functionStats, Collections.emptyList(), syntaxError);
    }

    public WallSqlStat(Map<String, WallSqlTableStat> tableStats, Map<String, WallSqlFunctionStat> functionStats, List<Violation> violations, boolean syntaxError) {
        this.violations = violations;
        this.tableStats = tableStats;
        this.functionStats = functionStats;
        this.syntaxError = syntaxError;
    }

    public long incrementAndGetExecuteCount() {
        return executeCountUpdater.incrementAndGet(this);
    }

    public long getExecuteCount() {
        return this.executeCount;
    }

    public long incrementAndGetEffectRowCount() {
        return effectRowCountUpdater.incrementAndGet(this);
    }

    public long addAndGetEffectRowCount(long delta) {
        return effectRowCountUpdater.addAndGet(this, delta);
    }

    public long getEffectRowCount() {
        return this.effectRowCount;
    }

    public Map<String, WallSqlTableStat> getTableStats() {
        return this.tableStats;
    }

    public Map<String, WallSqlFunctionStat> getFunctionStats() {
        return this.functionStats;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public boolean isSyntaxError() {
        return this.syntaxError;
    }
}

