/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.filter;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class FilterManager {
    private static final Log LOG = LogFactory.getLog(FilterManager.class);
    private static final ConcurrentHashMap<String, String> aliasMap = new ConcurrentHashMap(16, 0.75f, 1);

    public static final String getFilter(String alias) {
        return aliasMap.get(alias);
    }

    public static Properties loadFilterConfig() throws IOException {
        Properties filterProperties = new Properties();
        FilterManager.loadFilterConfig(filterProperties, ClassLoader.getSystemClassLoader());
        FilterManager.loadFilterConfig(filterProperties, FilterManager.class.getClassLoader());
        FilterManager.loadFilterConfig(filterProperties, Thread.currentThread().getContextClassLoader());
        FilterManager.loadFilterConfig(filterProperties, FilterManager.class.getClassLoader());
        return filterProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFilterConfig(Properties filterProperties, ClassLoader classLoader) throws IOException {
        if (classLoader == null) {
            return;
        }
        Enumeration<URL> e = classLoader.getResources("META-INF/druid-filter.properties");
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            Properties property = new Properties();
            InputStream is = null;
            try {
                is = url.openStream();
                property.load(is);
            }
            finally {
                JdbcUtils.close(is);
            }
            filterProperties.putAll((Map<?, ?>)property);
        }
    }

    public static void loadFilter(List<Filter> filters, String filterName) throws SQLException {
        if (filterName.length() == 0) {
            return;
        }
        String filterClassNames = FilterManager.getFilter(filterName);
        if (filterClassNames != null) {
            for (String filterClassName : filterClassNames.split(",")) {
                Filter filter;
                if (FilterManager.existsFilter(filters, filterClassName)) continue;
                Class<?> filterClass = Utils.loadClass(filterClassName);
                if (filterClass == null) {
                    LOG.error("load filter error, filter not found : " + filterClassName);
                    continue;
                }
                try {
                    filter = (Filter)filterClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new SQLException("load managed jdbc driver event listener error. " + filterName, e);
                }
                catch (IllegalAccessException e) {
                    throw new SQLException("load managed jdbc driver event listener error. " + filterName, e);
                }
                filters.add(filter);
            }
            return;
        }
        if (FilterManager.existsFilter(filters, filterName)) {
            return;
        }
        Class<?> filterClass = Utils.loadClass(filterName);
        if (filterClass == null) {
            LOG.error("load filter error, filter not found : " + filterName);
            return;
        }
        try {
            Filter filter = (Filter)filterClass.newInstance();
            filters.add(filter);
        }
        catch (Exception e) {
            throw new SQLException("load managed jdbc driver event listener error. " + filterName, e);
        }
    }

    private static boolean existsFilter(List<Filter> filterList, String filterClassName) {
        for (Filter filter : filterList) {
            String itemFilterClassName = filter.getClass().getName();
            if (!itemFilterClassName.equalsIgnoreCase(filterClassName)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            Properties filterProperties = FilterManager.loadFilterConfig();
            for (Map.Entry<Object, Object> entry : filterProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("druid.filters.")) continue;
                String name = key.substring("druid.filters.".length());
                aliasMap.put(name, (String)entry.getValue());
            }
        }
        catch (Throwable e) {
            LOG.error("load filter config error", e);
        }
    }
}

