/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.visitor;

import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithClause;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithQuery;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGBoxExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCidrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCircleExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGExtractExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGInetExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGIntervalExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGLineSegmentsExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGMacAddrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPointExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPolygonExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGTypeCastExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGShowStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGValuesQuery;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class PGOutputVisitor
extends SQLASTOutputVisitor
implements PGASTVisitor {
    public PGOutputVisitor(Appendable appender) {
        super(appender);
    }

    public PGOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public void endVisit(PGSelectQueryBlock.WindowClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.WindowClause x) {
        this.print0(this.ucase ? "WINDOW " : "window ");
        x.getName().accept(this);
        this.print0(this.ucase ? " AS " : " as ");
        for (int i = 0; i < x.getDefinition().size(); ++i) {
            if (i != 0) {
                this.println(", ");
            }
            this.print('(');
            x.getDefinition().get(i).accept(this);
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(PGSelectQueryBlock.FetchClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.FetchClause x) {
        this.print0(this.ucase ? "FETCH " : "fetch ");
        if (PGSelectQueryBlock.FetchClause.Option.FIRST.equals((Object)x.getOption())) {
            this.print0(this.ucase ? "FIRST " : "first ");
        } else if (PGSelectQueryBlock.FetchClause.Option.NEXT.equals((Object)x.getOption())) {
            this.print0(this.ucase ? "NEXT " : "next ");
        }
        x.getCount().accept(this);
        this.print0(this.ucase ? " ROWS ONLY" : " rows only");
        return false;
    }

    @Override
    public void endVisit(PGSelectQueryBlock.ForClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.ForClause x) {
        this.print0(this.ucase ? "FOR " : "for ");
        if (PGSelectQueryBlock.ForClause.Option.UPDATE.equals((Object)x.getOption())) {
            this.print0(this.ucase ? "UPDATE " : "update ");
        } else if (PGSelectQueryBlock.ForClause.Option.SHARE.equals((Object)x.getOption())) {
            this.print0(this.ucase ? "SHARE " : "share ");
        }
        if (x.getOf().size() > 0) {
            for (int i = 0; i < x.getOf().size(); ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                x.getOf().get(i).accept(this);
            }
        }
        if (x.isNoWait()) {
            this.print0(this.ucase ? " NOWAIT" : " nowait");
        }
        return false;
    }

    @Override
    public void endVisit(PGWithQuery x) {
    }

    @Override
    public boolean visit(PGWithQuery x) {
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print0(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        this.println();
        this.print0(this.ucase ? "AS" : "as");
        this.println();
        this.print('(');
        this.incrementIndent();
        this.println();
        x.getQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(PGWithClause x) {
    }

    @Override
    public boolean visit(PGWithClause x) {
        this.print0(this.ucase ? "WITH" : "with");
        if (x.isRecursive()) {
            this.print0(this.ucase ? " RECURSIVE " : " recursive ");
        }
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getWithQuery(), ", ");
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(PGSelectQueryBlock x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
            if (x.getDistinctOn() != null && x.getDistinctOn().size() > 0) {
                this.print0(this.ucase ? "ON " : "on ");
                this.printAndAccept(x.getDistinctOn(), ", ");
            }
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            if (x.getIntoOption() != null) {
                this.print0(x.getIntoOption().name());
                this.print(' ');
            }
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getWindow() != null) {
            this.println();
            x.getWindow().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        if (x.getFetch() != null) {
            this.println();
            x.getFetch().accept(this);
        }
        if (x.getForClause() != null) {
            this.println();
            x.getForClause().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLTruncateStatement x) {
        this.print0(this.ucase ? "TRUNCATE TABLE " : "truncate table ");
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY " : "only ");
        }
        this.printlnAndAccept(x.getTableSources(), ", ");
        if (x.getRestartIdentity() != null) {
            if (x.getRestartIdentity().booleanValue()) {
                this.print0(this.ucase ? " RESTART IDENTITY" : " restart identity");
            } else {
                this.print0(this.ucase ? " CONTINUE IDENTITY" : " continue identity");
            }
        }
        if (x.getCascade() != null) {
            if (x.getCascade().booleanValue()) {
                this.print0(this.ucase ? " CASCADE" : " cascade");
            } else {
                this.print0(this.ucase ? " RESTRICT" : " restrict");
            }
        }
        return false;
    }

    @Override
    public void endVisit(PGDeleteStatement x) {
    }

    @Override
    public boolean visit(PGDeleteStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print0(this.ucase ? "DELETE FROM " : "delete from ");
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY " : "only ");
        }
        this.printTableSourceExpr(x.getTableName());
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        if (x.getUsing().size() > 0) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            this.printAndAccept(x.getUsing(), ", ");
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            this.incrementIndent();
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        if (x.isReturning()) {
            this.println();
            this.print0(this.ucase ? "RETURNING *" : "returning *");
        }
        return false;
    }

    @Override
    public void endVisit(PGInsertStatement x) {
    }

    @Override
    public boolean visit(PGInsertStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print0(this.ucase ? "INSERT INTO " : "insert into ");
        x.getTableSource().accept(this);
        this.printInsertColumns(x.getColumns());
        if (x.getValues() != null) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printlnAndAccept(x.getValuesList(), ", ");
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if (x.getReturning() != null) {
            this.println();
            this.print0(this.ucase ? "RETURNING " : "returning ");
            x.getReturning().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(PGSelectStatement x) {
    }

    @Override
    public boolean visit(PGSelectStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        return this.visit((SQLSelectStatement)x);
    }

    @Override
    public void endVisit(PGUpdateStatement x) {
    }

    @Override
    public boolean visit(PGUpdateStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print0(this.ucase ? "UPDATE " : "update ");
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY " : "only ");
        }
        x.getTableSource().accept(this);
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            this.incrementIndent();
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        if (x.getReturning().size() > 0) {
            this.println();
            this.print0(this.ucase ? "RETURNING " : "returning ");
            this.printAndAccept(x.getReturning(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(PGSelectQueryBlock x) {
    }

    @Override
    public boolean visit(PGFunctionTableSource x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        if (x.getParameters().size() > 0) {
            this.print('(');
            this.printAndAccept(x.getParameters(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(PGFunctionTableSource x) {
    }

    @Override
    public void endVisit(PGTypeCastExpr x) {
    }

    @Override
    public boolean visit(PGTypeCastExpr x) {
        x.getExpr().accept(this);
        this.print0("::");
        x.getDataType().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGValuesQuery x) {
    }

    @Override
    public boolean visit(PGValuesQuery x) {
        this.print0(this.ucase ? "VALUES(" : "values(");
        this.printAndAccept(x.getValues(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(PGExtractExpr x) {
    }

    @Override
    public boolean visit(PGExtractExpr x) {
        this.print0(this.ucase ? "EXTRACT (" : "extract (");
        this.print0(x.getField().name());
        this.print0(this.ucase ? " FROM " : " from ");
        x.getSource().accept(this);
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(PGBoxExpr x) {
        this.print0(this.ucase ? "BOX " : "box ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGBoxExpr x) {
    }

    @Override
    public boolean visit(PGPointExpr x) {
        this.print0(this.ucase ? "POINT " : "point ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGPointExpr x) {
    }

    @Override
    public boolean visit(PGMacAddrExpr x) {
        this.print0("macaddr ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGMacAddrExpr x) {
    }

    @Override
    public boolean visit(PGInetExpr x) {
        this.print0("inet ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGInetExpr x) {
    }

    @Override
    public boolean visit(PGCidrExpr x) {
        this.print0("cidr ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGCidrExpr x) {
    }

    @Override
    public boolean visit(PGPolygonExpr x) {
        this.print0("polygon ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGPolygonExpr x) {
    }

    @Override
    public boolean visit(PGCircleExpr x) {
        this.print0("circle ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGCircleExpr x) {
    }

    @Override
    public boolean visit(PGLineSegmentsExpr x) {
        this.print0("lseg ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(PGIntervalExpr x) {
    }

    @Override
    public boolean visit(PGIntervalExpr x) {
        this.print0(this.ucase ? "INTERVAL " : "interval ");
        x.getValue().accept(this);
        return true;
    }

    @Override
    public void endVisit(PGLineSegmentsExpr x) {
    }

    @Override
    public boolean visit(SQLBinaryExpr x) {
        this.print0(this.ucase ? "B'" : "b'");
        this.print0(x.getValue());
        this.print('\'');
        return false;
    }

    @Override
    public void endVisit(PGShowStatement x) {
    }

    @Override
    public boolean visit(PGShowStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLLimit x) {
        this.print0(this.ucase ? "LIMIT " : "limit ");
        x.getRowCount().accept(this);
        if (x.getOffset() != null) {
            this.print0(this.ucase ? " OFFSET " : " offset ");
            x.getOffset().accept(this);
        }
        return false;
    }
}

