/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.ValidConnectionCheckerAdapter;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class OracleValidConnectionChecker
extends ValidConnectionCheckerAdapter
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = -2227528634302168877L;
    private static final Log LOG = LogFactory.getLog(OracleValidConnectionChecker.class);
    private final Class<?> clazz;
    private final Method ping;
    private static final Object[] params = new Object[]{new Integer(5000)};

    public OracleValidConnectionChecker() {
        try {
            this.clazz = Utils.loadClass("oracle.jdbc.driver.OracleConnection");
            this.ping = this.clazz != null ? this.clazz.getMethod("pingDatabase", Integer.TYPE) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resolve pingDatabase method:", e);
        }
        this.configFromProperties(System.getProperties());
    }

    @Override
    public void configFromProperties(Properties properties) {
        String property = properties.getProperty("druid.oracle.pingTimeout");
        if (property != null && property.length() > 0) {
            int value = Integer.parseInt(property);
            this.setTimeout(value);
        }
    }

    public void setTimeout(int timeout) {
        OracleValidConnectionChecker.params[0] = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValidConnection(Connection conn, String valiateQuery, int validationQueryTimeout) {
        try {
            if (conn.isClosed()) {
                return false;
            }
        }
        catch (SQLException ex) {
            return false;
        }
        try {
            boolean bl;
            if (conn instanceof DruidPooledConnection) {
                conn = ((DruidPooledConnection)conn).getConnection();
            }
            if (conn instanceof ConnectionProxy) {
                conn = ((ConnectionProxy)conn).getRawObject();
            }
            if (this.clazz != null && this.clazz.isAssignableFrom(conn.getClass())) {
                Integer status = (Integer)this.ping.invoke((Object)conn, params);
                return status >= 0;
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(valiateQuery);
                bl = true;
            }
            catch (SQLException e) {
                boolean bl2 = false;
                {
                    catch (Throwable throwable) {
                        JdbcUtils.close(rs);
                        JdbcUtils.close(stmt);
                        throw throwable;
                    }
                }
                JdbcUtils.close(rs);
                JdbcUtils.close(stmt);
                return bl2;
                catch (Exception e2) {
                    LOG.warn("Unexpected error in ping", e2);
                    boolean bl3 = false;
                    JdbcUtils.close(rs);
                    JdbcUtils.close(stmt);
                    return bl3;
                }
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            return bl;
        }
        catch (Exception e) {
            LOG.warn("Unexpected error in pingDatabase", e);
            return false;
        }
    }
}

