/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.filter.FilterManager;
import com.alibaba.druid.pool.DruidAbstractDataSourceMBean;
import com.alibaba.druid.pool.DruidDataSourceStatLogger;
import com.alibaba.druid.pool.DruidDataSourceStatLoggerImpl;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ExceptionSorter;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.WrapperAdapter;
import com.alibaba.druid.pool.vendor.NullExceptionSorter;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.TransactionInfo;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.stat.JdbcSqlStat;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.DruidPasswordCallback;
import com.alibaba.druid.util.Histogram;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.util.Utils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.sql.DataSource;

public abstract class DruidAbstractDataSource
extends WrapperAdapter
implements DruidAbstractDataSourceMBean,
DataSource,
DataSourceProxy,
Serializable {
    private static final Log LOG = LogFactory.getLog(DruidAbstractDataSource.class);
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_INITIAL_SIZE = 0;
    public static final int DEFAULT_MAX_ACTIVE_SIZE = 8;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final int DEFAULT_MAX_WAIT = -1;
    public static final String DEFAULT_VALIDATION_QUERY = null;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_WHILE_IDLE = true;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = 60000L;
    public static final long DEFAULT_TIME_BETWEEN_CONNECT_ERROR_MILLIS = 30000L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    protected volatile boolean defaultAutoCommit = true;
    protected volatile Boolean defaultReadOnly;
    protected volatile Integer defaultTransactionIsolation;
    protected volatile String defaultCatalog = null;
    protected String name;
    protected volatile String username;
    protected volatile String password;
    protected volatile String jdbcUrl;
    protected volatile String driverClass;
    protected volatile ClassLoader driverClassLoader;
    protected volatile Properties connectProperties = new Properties();
    protected volatile PasswordCallback passwordCallback;
    protected volatile NameCallback userCallback;
    protected volatile int initialSize = 0;
    protected volatile int maxActive = 8;
    protected volatile int minIdle = 0;
    protected volatile int maxIdle = 8;
    protected volatile long maxWait = -1L;
    protected volatile String validationQuery = DEFAULT_VALIDATION_QUERY;
    protected volatile int validationQueryTimeout = -1;
    private volatile boolean testOnBorrow = false;
    private volatile boolean testOnReturn = false;
    private volatile boolean testWhileIdle = true;
    protected volatile boolean poolPreparedStatements = false;
    protected volatile boolean sharePreparedStatements = false;
    protected volatile int maxPoolPreparedStatementPerConnectionSize = 10;
    protected volatile boolean inited = false;
    protected PrintWriter logWriter = new PrintWriter(System.out);
    protected List<Filter> filters = new CopyOnWriteArrayList<Filter>();
    private boolean clearFiltersEnable = true;
    protected volatile ExceptionSorter exceptionSorter = null;
    protected Driver driver;
    protected volatile int queryTimeout;
    protected volatile int transactionQueryTimeout;
    protected AtomicLong createErrorCount = new AtomicLong();
    protected long createTimespan;
    protected volatile int maxWaitThreadCount = -1;
    protected volatile boolean accessToUnderlyingConnectionAllowed = true;
    protected volatile long timeBetweenEvictionRunsMillis = 60000L;
    protected volatile int numTestsPerEvictionRun = 3;
    protected volatile long minEvictableIdleTimeMillis = 1800000L;
    protected volatile boolean removeAbandoned;
    protected volatile long removeAbandonedTimeoutMillis = 300000L;
    protected volatile boolean logAbandoned;
    protected volatile int maxOpenPreparedStatements = -1;
    protected volatile List<String> connectionInitSqls;
    protected volatile String dbType;
    protected volatile long timeBetweenConnectErrorMillis = 30000L;
    protected volatile ValidConnectionChecker validConnectionChecker = null;
    protected final AtomicLong errorCount = new AtomicLong();
    protected final AtomicLong dupCloseCount = new AtomicLong();
    protected final Map<DruidPooledConnection, Object> activeConnections = new IdentityHashMap<DruidPooledConnection, Object>();
    protected static final Object PRESENT = new Object();
    protected long id;
    protected final Date createdTime = new Date();
    protected Date initedTime;
    protected int connectionErrorRetryAttempts = 30;
    protected boolean breakAfterAcquireFailure = false;
    protected long transactionThresholdMillis = 0L;
    protected final AtomicLong commitCount = new AtomicLong();
    protected final AtomicLong startTransactionCount = new AtomicLong();
    protected final AtomicLong rollbackCount = new AtomicLong();
    protected final AtomicLong cachedPreparedStatementHitCount = new AtomicLong();
    protected final AtomicLong preparedStatementCount = new AtomicLong();
    protected final AtomicLong closedPreparedStatementCount = new AtomicLong();
    protected final AtomicLong cachedPreparedStatementCount = new AtomicLong();
    protected final AtomicLong cachedPreparedStatementDeleteCount = new AtomicLong();
    protected final AtomicLong cachedPreparedStatementMissCount = new AtomicLong();
    protected final Histogram transactionHistogram = new Histogram(10L, 100L, 1000L, 10000L, 100000L);
    private boolean dupCloseLogEnable = false;
    private ObjectName objectName;
    protected final AtomicLong executeCount = new AtomicLong();
    protected volatile Throwable createError;
    protected volatile Throwable lastError;
    protected volatile long lastErrorTimeMillis;
    protected volatile Throwable lastCreateError;
    protected volatile long lastCreateErrorTimeMillis;
    protected boolean isOracle = false;
    protected boolean useOracleImplicitCache = true;
    protected ReentrantLock lock;
    protected Condition notEmpty;
    protected Condition empty;
    protected AtomicLong createCount = new AtomicLong();
    protected AtomicLong destroyCount = new AtomicLong();
    private Boolean useUnfairLock = null;
    private boolean useLocalSessionState = true;
    protected long timeBetweenLogStatsMillis;
    protected DruidDataSourceStatLogger statLogger = new DruidDataSourceStatLoggerImpl();
    protected final AtomicLong connectionIdSeed = new AtomicLong(10000L);
    protected final AtomicLong statementIdSeed = new AtomicLong(20000L);
    protected final AtomicLong resultSetIdSeed = new AtomicLong(50000L);
    protected final AtomicLong transactionIdSeed = new AtomicLong(60000L);
    protected final AtomicLong metaDataIdSeed = new AtomicLong(80000L);

    public DruidAbstractDataSource(boolean lockFair) {
        this.lock = new ReentrantLock(lockFair);
        this.notEmpty = this.lock.newCondition();
        this.empty = this.lock.newCondition();
    }

    public boolean isUseLocalSessionState() {
        return this.useLocalSessionState;
    }

    public void setUseLocalSessionState(boolean useLocalSessionState) {
        this.useLocalSessionState = useLocalSessionState;
    }

    public DruidDataSourceStatLogger getStatLogger() {
        return this.statLogger;
    }

    public void setStatLoggerClassName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            DruidDataSourceStatLogger statLogger = (DruidDataSourceStatLogger)clazz.newInstance();
            this.setStatLogger(statLogger);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(className, e);
        }
    }

    public void setStatLogger(DruidDataSourceStatLogger statLogger) {
        this.statLogger = statLogger;
    }

    public long getTimeBetweenLogStatsMillis() {
        return this.timeBetweenLogStatsMillis;
    }

    public void setTimeBetweenLogStatsMillis(long timeBetweenLogStatsMillis) {
        this.timeBetweenLogStatsMillis = timeBetweenLogStatsMillis;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public void setOracle(boolean isOracle) {
        if (this.inited) {
            throw new IllegalStateException();
        }
        this.isOracle = isOracle;
    }

    public boolean isUseUnfairLock() {
        return this.lock.isFair();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseUnfairLock(boolean useUnfairLock) {
        if (this.lock.isFair() == !useUnfairLock) {
            return;
        }
        if (!this.inited) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (!this.inited) {
                    this.lock = new ReentrantLock(!useUnfairLock);
                    this.notEmpty = this.lock.newCondition();
                    this.empty = this.lock.newCondition();
                    this.useUnfairLock = useUnfairLock;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public boolean isUseOracleImplicitCache() {
        return this.useOracleImplicitCache;
    }

    @Override
    public void setUseOracleImplicitCache(boolean useOracleImplicitCache) {
        if (this.useOracleImplicitCache != useOracleImplicitCache) {
            boolean isOracleDriver10;
            this.useOracleImplicitCache = useOracleImplicitCache;
            boolean bl = isOracleDriver10 = this.isOracle() && this.driver != null && this.driver.getMajorVersion() == 10;
            if (isOracleDriver10 && useOracleImplicitCache) {
                this.getConnectProperties().setProperty("oracle.jdbc.FreeMemoryOnEnterImplicitCache", "true");
            } else {
                this.getConnectProperties().remove("oracle.jdbc.FreeMemoryOnEnterImplicitCache");
            }
        }
    }

    public Throwable getLastCreateError() {
        return this.lastCreateError;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public long getLastErrorTimeMillis() {
        return this.lastErrorTimeMillis;
    }

    public Date getLastErrorTime() {
        if (this.lastErrorTimeMillis <= 0L) {
            return null;
        }
        return new Date(this.lastErrorTimeMillis);
    }

    public long getLastCreateErrorTimeMillis() {
        return this.lastCreateErrorTimeMillis;
    }

    public Date getLastCreateErrorTime() {
        if (this.lastCreateErrorTimeMillis <= 0L) {
            return null;
        }
        return new Date(this.lastCreateErrorTimeMillis);
    }

    @Override
    public int getTransactionQueryTimeout() {
        if (this.transactionQueryTimeout <= 0) {
            return this.queryTimeout;
        }
        return this.transactionQueryTimeout;
    }

    public void setTransactionQueryTimeout(int transactionQueryTimeout) {
        this.transactionQueryTimeout = transactionQueryTimeout;
    }

    public long getExecuteCount() {
        return this.executeCount.get();
    }

    public void incrementExecuteCount() {
        this.executeCount.incrementAndGet();
    }

    public boolean isDupCloseLogEnable() {
        return this.dupCloseLogEnable;
    }

    public void setDupCloseLogEnable(boolean dupCloseLogEnable) {
        this.dupCloseLogEnable = dupCloseLogEnable;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public Histogram getTransactionHistogram() {
        return this.transactionHistogram;
    }

    public void incrementCachedPreparedStatementCount() {
        this.cachedPreparedStatementCount.incrementAndGet();
    }

    public void decrementCachedPreparedStatementCount() {
        this.cachedPreparedStatementCount.decrementAndGet();
    }

    public void incrementCachedPreparedStatementDeleteCount() {
        this.cachedPreparedStatementDeleteCount.incrementAndGet();
    }

    public void incrementCachedPreparedStatementMissCount() {
        this.cachedPreparedStatementMissCount.incrementAndGet();
    }

    @Override
    public long getCachedPreparedStatementMissCount() {
        return this.cachedPreparedStatementMissCount.get();
    }

    @Override
    public long getCachedPreparedStatementAccessCount() {
        return this.cachedPreparedStatementMissCount.get() + this.cachedPreparedStatementHitCount.get();
    }

    @Override
    public long getCachedPreparedStatementDeleteCount() {
        return this.cachedPreparedStatementDeleteCount.get();
    }

    @Override
    public long getCachedPreparedStatementCount() {
        return this.cachedPreparedStatementCount.get();
    }

    public void incrementClosedPreparedStatementCount() {
        this.closedPreparedStatementCount.incrementAndGet();
    }

    @Override
    public long getClosedPreparedStatementCount() {
        return this.closedPreparedStatementCount.get();
    }

    public void incrementPreparedStatementCount() {
        this.preparedStatementCount.incrementAndGet();
    }

    @Override
    public long getPreparedStatementCount() {
        return this.preparedStatementCount.get();
    }

    public void incrementCachedPreparedStatementHitCount() {
        this.cachedPreparedStatementHitCount.incrementAndGet();
    }

    @Override
    public long getCachedPreparedStatementHitCount() {
        return this.cachedPreparedStatementHitCount.get();
    }

    @Override
    public long getTransactionThresholdMillis() {
        return this.transactionThresholdMillis;
    }

    @Override
    public void setTransactionThresholdMillis(long transactionThresholdMillis) {
        this.transactionThresholdMillis = transactionThresholdMillis;
    }

    public abstract void logTransaction(TransactionInfo var1);

    @Override
    public long[] getTransactionHistogramValues() {
        return this.transactionHistogram.toArray();
    }

    public long[] getTransactionHistogramRanges() {
        return this.transactionHistogram.getRanges();
    }

    @Override
    public long getCommitCount() {
        return this.commitCount.get();
    }

    public void incrementCommitCount() {
        this.commitCount.incrementAndGet();
    }

    @Override
    public long getRollbackCount() {
        return this.rollbackCount.get();
    }

    public void incrementRollbackCount() {
        this.rollbackCount.incrementAndGet();
    }

    @Override
    public long getStartTransactionCount() {
        return this.startTransactionCount.get();
    }

    public void incrementStartTransactionCount() {
        this.startTransactionCount.incrementAndGet();
    }

    @Override
    public boolean isBreakAfterAcquireFailure() {
        return this.breakAfterAcquireFailure;
    }

    public void setBreakAfterAcquireFailure(boolean breakAfterAcquireFailure) {
        this.breakAfterAcquireFailure = breakAfterAcquireFailure;
    }

    @Override
    public int getConnectionErrorRetryAttempts() {
        return this.connectionErrorRetryAttempts;
    }

    public void setConnectionErrorRetryAttempts(int connectionErrorRetryAttempts) {
        this.connectionErrorRetryAttempts = connectionErrorRetryAttempts;
    }

    @Override
    public long getDupCloseCount() {
        return this.dupCloseCount.get();
    }

    @Override
    public int getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    @Override
    public void setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        this.poolPreparedStatements = maxPoolPreparedStatementPerConnectionSize > 0;
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
    }

    @Override
    public boolean isSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public void setSharePreparedStatements(boolean sharePreparedStatements) {
        this.sharePreparedStatements = sharePreparedStatements;
    }

    public void incrementDupCloseCount() {
        this.dupCloseCount.incrementAndGet();
    }

    public ValidConnectionChecker getValidConnectionChecker() {
        return this.validConnectionChecker;
    }

    public void setValidConnectionChecker(ValidConnectionChecker validConnectionChecker) {
        this.validConnectionChecker = validConnectionChecker;
    }

    @Override
    public String getValidConnectionCheckerClassName() {
        if (this.validConnectionChecker == null) {
            return null;
        }
        return this.validConnectionChecker.getClass().getName();
    }

    public void setValidConnectionCheckerClassName(String validConnectionCheckerClass) throws Exception {
        Class<?> clazz = Utils.loadClass(validConnectionCheckerClass);
        ValidConnectionChecker validConnectionChecker = null;
        if (clazz != null) {
            this.validConnectionChecker = validConnectionChecker = (ValidConnectionChecker)clazz.newInstance();
        } else {
            LOG.error("load validConnectionCheckerClass error : " + validConnectionCheckerClass);
        }
    }

    @Override
    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void addConnectionProperty(String name, String value) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.connectProperties.put(name, value);
    }

    public Collection<String> getConnectionInitSqls() {
        List<String> result = this.connectionInitSqls;
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public void setConnectionInitSqls(Collection<? extends Object> connectionInitSqls) {
        if (connectionInitSqls != null && connectionInitSqls.size() > 0) {
            ArrayList<String> newVal = null;
            for (Object object : connectionInitSqls) {
                if (object == null) continue;
                String s = object.toString();
                if ((s = s.trim()).length() == 0) continue;
                if (newVal == null) {
                    newVal = new ArrayList<String>();
                }
                newVal.add(s);
            }
            this.connectionInitSqls = newVal;
        } else {
            this.connectionInitSqls = null;
        }
    }

    @Override
    public long getTimeBetweenConnectErrorMillis() {
        return this.timeBetweenConnectErrorMillis;
    }

    public void setTimeBetweenConnectErrorMillis(long timeBetweenConnectErrorMillis) {
        this.timeBetweenConnectErrorMillis = timeBetweenConnectErrorMillis;
    }

    @Override
    public int getMaxOpenPreparedStatements() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.setMaxPoolPreparedStatementPerConnectionSize(maxOpenPreparedStatements);
    }

    @Override
    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    @Override
    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public int getRemoveAbandonedTimeout() {
        return (int)(this.removeAbandonedTimeoutMillis / 1000L);
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.removeAbandonedTimeoutMillis = (long)removeAbandonedTimeout * 1000L;
    }

    public void setRemoveAbandonedTimeoutMillis(long removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
    }

    @Override
    public long getRemoveAbandonedTimeoutMillis() {
        return this.removeAbandonedTimeoutMillis;
    }

    @Override
    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    @Override
    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        if (minEvictableIdleTimeMillis < 30000L) {
            LOG.error("minEvictableIdleTimeMillis should be greater than 30000");
        }
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Deprecated
    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    @Override
    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    @Override
    public int getMaxWaitThreadCount() {
        return this.maxWaitThreadCount;
    }

    public void setMaxWaitThreadCount(int maxWaithThreadCount) {
        this.maxWaitThreadCount = maxWaithThreadCount;
    }

    @Override
    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    @Override
    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean accessToUnderlyingConnectionAllowed) {
        this.accessToUnderlyingConnectionAllowed = accessToUnderlyingConnectionAllowed;
    }

    @Override
    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    @Override
    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    @Override
    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    @Override
    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Override
    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    @Override
    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public Integer getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(Integer defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public PasswordCallback getPasswordCallback() {
        return this.passwordCallback;
    }

    public void setPasswordCallback(PasswordCallback passwordCallback) {
        this.passwordCallback = passwordCallback;
    }

    public void setPasswordCallbackClassName(String passwordCallbackClassName) throws Exception {
        Class<?> clazz = Utils.loadClass(passwordCallbackClassName);
        if (clazz != null) {
            this.passwordCallback = (PasswordCallback)clazz.newInstance();
        } else {
            LOG.error("load passwordCallback error : " + passwordCallbackClassName);
            this.passwordCallback = null;
        }
    }

    public NameCallback getUserCallback() {
        return this.userCallback;
    }

    public void setUserCallback(NameCallback userCallback) {
        this.userCallback = userCallback;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "DataSource-" + System.identityHashCode(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public abstract void setPoolPreparedStatements(boolean var1);

    @Override
    public long getMaxWait() {
        return this.maxWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxWait(long maxWaitMillis) {
        if (maxWaitMillis == this.maxWait) {
            return;
        }
        if (maxWaitMillis > 0L && this.useUnfairLock == null && !this.inited) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (!this.inited && !lock.isFair()) {
                    this.lock = new ReentrantLock(true);
                    this.notEmpty = this.lock.newCondition();
                    this.empty = this.lock.newCondition();
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (this.inited) {
            LOG.error("maxWait changed : " + this.maxWait + " -> " + maxWaitMillis);
        }
        this.maxWait = maxWaitMillis;
    }

    @Override
    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int value) {
        if (value == this.minIdle) {
            return;
        }
        if (this.inited && value > this.maxActive) {
            throw new IllegalArgumentException("minIdle greater than maxActive, " + this.maxActive + " < " + this.minIdle);
        }
        this.minIdle = value;
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    @Deprecated
    public void setMaxIdle(int maxIdle) {
        LOG.error("maxIdle is deprecated");
        this.maxIdle = maxIdle;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (this.initialSize == initialSize) {
            return;
        }
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.initialSize = initialSize;
    }

    @Override
    public long getCreateErrorCount() {
        return this.createErrorCount.get();
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    @Override
    public abstract void setMaxActive(int var1);

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (StringUtils.equals(this.password, password)) {
            return;
        }
        if (this.inited) {
            LOG.info("password changed");
        }
        this.password = password;
    }

    @Override
    public Properties getConnectProperties() {
        return this.connectProperties;
    }

    public abstract void setConnectProperties(Properties var1);

    public void setConnectionProperties(String connectionProperties) {
        if (connectionProperties == null || connectionProperties.trim().length() == 0) {
            this.setConnectProperties(null);
            return;
        }
        String[] entries = connectionProperties.split(";");
        Properties properties = new Properties();
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i];
            if (entry.length() <= 0) continue;
            int index = entry.indexOf(61);
            if (index > 0) {
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                properties.setProperty(name, value);
                continue;
            }
            properties.setProperty(entry, "");
        }
        this.setConnectProperties(properties);
    }

    @Override
    public String getUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getRawJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        if (jdbcUrl != null) {
            jdbcUrl = jdbcUrl.trim();
        }
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public String getDriverClassName() {
        return this.driverClass;
    }

    public void setDriverClassName(String driverClass) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.driverClass = driverClass;
    }

    public ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    public void setDriverClassLoader(ClassLoader driverClassLoader) {
        this.driverClassLoader = driverClassLoader;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public int getDriverMajorVersion() {
        if (this.driver == null) {
            return -1;
        }
        return this.driver.getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        if (this.driver == null) {
            return -1;
        }
        return this.driver.getMinorVersion();
    }

    public ExceptionSorter getExceptionSorter() {
        return this.exceptionSorter;
    }

    @Override
    public String getExceptionSorterClassName() {
        if (this.exceptionSorter == null) {
            return null;
        }
        return this.exceptionSorter.getClass().getName();
    }

    public void setExceptionSorter(ExceptionSorter exceptionSoter) {
        this.exceptionSorter = exceptionSoter;
    }

    public void setExceptionSorterClassName(String exceptionSorter) throws Exception {
        this.setExceptionSorter(exceptionSorter);
    }

    public void setExceptionSorter(String exceptionSorter) throws SQLException {
        if (exceptionSorter == null) {
            this.exceptionSorter = NullExceptionSorter.getInstance();
            return;
        }
        if ((exceptionSorter = exceptionSorter.trim()).length() == 0) {
            this.exceptionSorter = NullExceptionSorter.getInstance();
            return;
        }
        Class<?> clazz = Utils.loadClass(exceptionSorter);
        if (clazz == null) {
            LOG.error("load exceptionSorter error : " + exceptionSorter);
        } else {
            try {
                this.exceptionSorter = (ExceptionSorter)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new SQLException("create exceptionSorter error", ex);
            }
        }
    }

    @Override
    public List<Filter> getProxyFilters() {
        return this.filters;
    }

    public void setProxyFilters(List<Filter> filters) {
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public String[] getFilterClasses() {
        List<Filter> filterConfigList = this.getProxyFilters();
        ArrayList<String> classes = new ArrayList<String>();
        for (Filter filter : filterConfigList) {
            classes.add(filter.getClass().getName());
        }
        return classes.toArray(new String[classes.size()]);
    }

    public void setFilters(String filters) throws SQLException {
        if (filters != null && filters.startsWith("!")) {
            filters = filters.substring(1);
            this.clearFilters();
        }
        this.addFilters(filters);
    }

    public void addFilters(String filters) throws SQLException {
        String[] filterArray;
        if (filters == null || filters.length() == 0) {
            return;
        }
        for (String item : filterArray = filters.split("\\,")) {
            FilterManager.loadFilter(this.filters, item);
        }
    }

    public void clearFilters() {
        if (!this.isClearFiltersEnable()) {
            return;
        }
        this.filters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection(Connection conn) throws SQLException {
        String query = this.getValidationQuery();
        if (conn.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        if (this.validConnectionChecker != null) {
            if (!this.validConnectionChecker.isValidConnection(conn, this.validationQuery, this.validationQueryTimeout)) {
                throw new SQLException("validateConnection false");
            }
            return;
        }
        if (null != query) {
            ResultSet rs;
            Statement stmt;
            block7: {
                stmt = null;
                rs = null;
                try {
                    stmt = conn.createStatement();
                    if (this.getValidationQueryTimeout() > 0) {
                        stmt.setQueryTimeout(this.getValidationQueryTimeout());
                    }
                    if ((rs = stmt.executeQuery(query)).next()) break block7;
                    throw new SQLException("validationQuery didn't return a row");
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(rs);
                    JdbcUtils.close(stmt);
                    throw throwable;
                }
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testConnectionInternal(Connection conn) {
        String sqlFile = JdbcSqlStat.getContextSqlFile();
        String sqlName = JdbcSqlStat.getContextSqlName();
        if (sqlFile != null) {
            JdbcSqlStat.setContextSqlFile(null);
        }
        if (sqlName != null) {
            JdbcSqlStat.setContextSqlName(null);
        }
        try {
            ResultSet rset;
            Statement stmt;
            block19: {
                boolean bl;
                if (this.validConnectionChecker != null) {
                    boolean bl2 = this.validConnectionChecker.isValidConnection(conn, this.validationQuery, this.validationQueryTimeout);
                    return bl2;
                }
                if (conn.isClosed()) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (null == this.validationQuery) {
                    boolean bl4 = true;
                    return bl4;
                }
                stmt = null;
                rset = null;
                try {
                    stmt = conn.createStatement();
                    if (this.getValidationQueryTimeout() > 0) {
                        stmt.setQueryTimeout(this.validationQueryTimeout);
                    }
                    if ((rset = stmt.executeQuery(this.validationQuery)).next()) break block19;
                    bl = false;
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(rset);
                    JdbcUtils.close(stmt);
                    throw throwable;
                }
                JdbcUtils.close(rset);
                JdbcUtils.close(stmt);
                return bl;
            }
            JdbcUtils.close(rset);
            JdbcUtils.close(stmt);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sqlFile != null) {
                JdbcSqlStat.setContextSqlFile(sqlFile);
            }
            if (sqlName != null) {
                JdbcSqlStat.setContextSqlName(sqlName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DruidPooledConnection> getActiveConnections() {
        Map<DruidPooledConnection, Object> map = this.activeConnections;
        synchronized (map) {
            return new HashSet<DruidPooledConnection>(this.activeConnections.keySet());
        }
    }

    @Override
    public List<String> getActiveConnectionStackTrace() {
        ArrayList<String> list = new ArrayList<String>();
        for (DruidPooledConnection conn : this.getActiveConnections()) {
            list.add(Utils.toString(conn.getConnectStackTrace()));
        }
        return list;
    }

    public long getCreateTimespanNano() {
        return this.createTimespan;
    }

    @Override
    public long getCreateTimespanMillis() {
        return this.createTimespan / 1000000L;
    }

    @Override
    public Driver getRawDriver() {
        return this.driver;
    }

    public boolean isClearFiltersEnable() {
        return this.clearFiltersEnable;
    }

    public void setClearFiltersEnable(boolean clearFiltersEnable) {
        this.clearFiltersEnable = clearFiltersEnable;
    }

    @Override
    public long createConnectionId() {
        return this.connectionIdSeed.incrementAndGet();
    }

    @Override
    public long createStatementId() {
        return this.statementIdSeed.getAndIncrement();
    }

    @Override
    public long createMetaDataId() {
        return this.metaDataIdSeed.getAndIncrement();
    }

    @Override
    public long createResultSetId() {
        return this.resultSetIdSeed.getAndIncrement();
    }

    @Override
    public long createTransactionId() {
        return this.transactionIdSeed.getAndIncrement();
    }

    void initStatement(DruidPooledConnection conn, Statement stmt) throws SQLException {
        int queryTimeout;
        boolean transaction = !conn.getConnectionHolder().isUnderlyingAutoCommit();
        int n = queryTimeout = transaction ? this.getTransactionQueryTimeout() : this.getQueryTimeout();
        if (queryTimeout > 0) {
            stmt.setQueryTimeout(queryTimeout);
        }
    }

    public abstract void handleConnectionException(DruidPooledConnection var1, Throwable var2) throws SQLException;

    protected abstract void recycle(DruidPooledConnection var1) throws SQLException;

    public Connection createPhysicalConnection(String url, Properties info) throws SQLException {
        Connection conn = this.getProxyFilters().size() == 0 ? this.getDriver().connect(url, info) : new FilterChainImpl(this).connection_connect(info);
        this.createCount.incrementAndGet();
        return conn;
    }

    public Connection createPhysicalConnection() throws SQLException {
        Connection conn;
        String url = this.getUrl();
        Properties connectProperties = this.getConnectProperties();
        String user = this.getUserCallback() != null ? this.getUserCallback().getName() : this.getUsername();
        String password = this.getPassword();
        PasswordCallback passwordCallback = this.getPasswordCallback();
        if (passwordCallback != null) {
            char[] chars;
            if (passwordCallback instanceof DruidPasswordCallback) {
                DruidPasswordCallback druidPasswordCallback = (DruidPasswordCallback)passwordCallback;
                druidPasswordCallback.setUrl(url);
                druidPasswordCallback.setProperties(connectProperties);
            }
            if ((chars = passwordCallback.getPassword()) != null) {
                password = new String(chars);
            }
        }
        Properties physicalConnectProperties = new Properties();
        if (connectProperties != null) {
            physicalConnectProperties.putAll((Map<?, ?>)connectProperties);
        }
        if (user != null && user.length() != 0) {
            physicalConnectProperties.put("user", user);
        }
        if (password != null && password.length() != 0) {
            physicalConnectProperties.put("password", password);
        }
        long startNano = System.nanoTime();
        try {
            conn = this.createPhysicalConnection(url, physicalConnectProperties);
            if (conn == null) {
                throw new SQLException("connect error, url " + url + ", driverClass " + this.driverClass);
            }
            this.initPhysicalConnection(conn);
            this.validateConnection(conn);
            this.createError = null;
        }
        catch (SQLException ex) {
            this.createErrorCount.incrementAndGet();
            this.createError = ex;
            this.lastCreateError = ex;
            this.lastCreateErrorTimeMillis = System.currentTimeMillis();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.createErrorCount.incrementAndGet();
            this.createError = ex;
            this.lastCreateError = ex;
            this.lastCreateErrorTimeMillis = System.currentTimeMillis();
            throw ex;
        }
        catch (Error ex) {
            this.createErrorCount.incrementAndGet();
            throw ex;
        }
        finally {
            long nano = System.nanoTime() - startNano;
            this.createTimespan += nano;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPhysicalConnection(Connection conn) throws SQLException {
        Collection<String> initSqls;
        if (conn.getAutoCommit() != this.defaultAutoCommit) {
            conn.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.getDefaultReadOnly() != null && conn.isReadOnly() != this.getDefaultReadOnly().booleanValue()) {
            conn.setReadOnly(this.getDefaultReadOnly());
        }
        if (this.getDefaultTransactionIsolation() != null && conn.getTransactionIsolation() != this.getDefaultTransactionIsolation().intValue()) {
            conn.setTransactionIsolation(this.getDefaultTransactionIsolation());
        }
        if (this.getDefaultCatalog() != null && this.getDefaultCatalog().length() != 0) {
            conn.setCatalog(this.getDefaultCatalog());
        }
        if ((initSqls = this.getConnectionInitSqls()).size() == 0) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            for (String sql : initSqls) {
                if (sql == null) continue;
                stmt.execute(sql);
            }
        }
        finally {
            JdbcUtils.close(stmt);
        }
    }

    public abstract int getActivePeak();

    public CompositeDataSupport getCompositeData() throws JMException {
        JdbcDataSourceStat stat = this.getDataSourceStat();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", this.getID());
        map.put("URL", this.getUrl());
        map.put("Name", this.getName());
        map.put("FilterClasses", this.getFilterClasses());
        map.put("CreatedTime", this.getCreatedTime());
        map.put("RawDriverClassName", this.getDriverClassName());
        map.put("RawUrl", this.getUrl());
        map.put("RawDriverMajorVersion", this.getRawDriverMajorVersion());
        map.put("RawDriverMinorVersion", this.getRawDriverMinorVersion());
        map.put("Properties", this.getProperties());
        map.put("ConnectionActiveCount", Long.valueOf(this.getActiveCount()));
        map.put("ConnectionActiveCountMax", this.getActivePeak());
        map.put("ConnectionCloseCount", this.getCloseCount());
        map.put("ConnectionCommitCount", this.getCommitCount());
        map.put("ConnectionRollbackCount", this.getRollbackCount());
        map.put("ConnectionConnectLastTime", stat.getConnectionStat().getConnectLastTime());
        map.put("ConnectionConnectErrorCount", this.getCreateCount());
        if (this.createError != null) {
            map.put("ConnectionConnectErrorLastTime", this.getLastCreateErrorTime());
            map.put("ConnectionConnectErrorLastMessage", this.createError.getMessage());
            map.put("ConnectionConnectErrorLastStackTrace", Utils.getStackTrace(this.createError));
        } else {
            map.put("ConnectionConnectErrorLastTime", null);
            map.put("ConnectionConnectErrorLastMessage", null);
            map.put("ConnectionConnectErrorLastStackTrace", null);
        }
        map.put("StatementCreateCount", stat.getStatementStat().getCreateCount());
        map.put("StatementPrepareCount", stat.getStatementStat().getPrepareCount());
        map.put("StatementPreCallCount", stat.getStatementStat().getPrepareCallCount());
        map.put("StatementExecuteCount", stat.getStatementStat().getExecuteCount());
        map.put("StatementRunningCount", stat.getStatementStat().getRunningCount());
        map.put("StatementConcurrentMax", stat.getStatementStat().getConcurrentMax());
        map.put("StatementCloseCount", stat.getStatementStat().getCloseCount());
        map.put("StatementErrorCount", stat.getStatementStat().getErrorCount());
        map.put("StatementLastErrorTime", null);
        map.put("StatementLastErrorMessage", null);
        map.put("StatementLastErrorStackTrace", null);
        map.put("StatementExecuteMillisTotal", stat.getStatementStat().getMillisTotal());
        map.put("StatementExecuteLastTime", stat.getStatementStat().getExecuteLastTime());
        map.put("ConnectionConnectingCount", stat.getConnectionStat().getConnectingCount());
        map.put("ResultSetCloseCount", stat.getResultSetStat().getCloseCount());
        map.put("ResultSetOpenCount", stat.getResultSetStat().getOpenCount());
        map.put("ResultSetOpenningCount", stat.getResultSetStat().getOpenningCount());
        map.put("ResultSetOpenningMax", stat.getResultSetStat().getOpenningMax());
        map.put("ResultSetFetchRowCount", stat.getResultSetStat().getFetchRowCount());
        map.put("ResultSetLastOpenTime", stat.getResultSetStat().getLastOpenTime());
        map.put("ResultSetErrorCount", stat.getResultSetStat().getErrorCount());
        map.put("ResultSetOpenningMillisTotal", stat.getResultSetStat().getAliveMillisTotal());
        map.put("ResultSetLastErrorTime", stat.getResultSetStat().getLastErrorTime());
        map.put("ResultSetLastErrorMessage", null);
        map.put("ResultSetLastErrorStackTrace", null);
        map.put("ConnectionConnectCount", this.getConnectCount());
        if (this.createError != null) {
            map.put("ConnectionErrorLastMessage", this.createError.getMessage());
            map.put("ConnectionErrorLastStackTrace", Utils.getStackTrace(this.createError));
        } else {
            map.put("ConnectionErrorLastMessage", null);
            map.put("ConnectionErrorLastStackTrace", null);
        }
        map.put("ConnectionConnectMillisTotal", stat.getConnectionStat().getConnectMillis());
        map.put("ConnectionConnectingCountMax", stat.getConnectionStat().getConnectingMax());
        map.put("ConnectionConnectMillisMax", stat.getConnectionStat().getConnectMillisMax());
        map.put("ConnectionErrorLastTime", stat.getConnectionStat().getErrorLastTime());
        map.put("ConnectionAliveMillisMax", stat.getConnectionConnectAliveMillisMax());
        map.put("ConnectionAliveMillisMin", stat.getConnectionConnectAliveMillisMin());
        map.put("ConnectionHistogram", stat.getConnectionHistogramValues());
        map.put("StatementHistogram", stat.getStatementStat().getHistogramValues());
        return new CompositeDataSupport(JdbcStatManager.getDataSourceCompositeType(), map);
    }

    public long getID() {
        return this.id;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public abstract int getRawDriverMajorVersion();

    @Override
    public abstract int getRawDriverMinorVersion();

    @Override
    public abstract String getProperties();

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void closePreapredStatement(PreparedStatementHolder stmtHolder) {
        if (stmtHolder == null) {
            return;
        }
        this.closedPreparedStatementCount.incrementAndGet();
        this.decrementCachedPreparedStatementCount();
        this.incrementCachedPreparedStatementDeleteCount();
        JdbcUtils.close(stmtHolder.getStatement());
    }

    protected void cloneTo(DruidAbstractDataSource to) {
        to.defaultAutoCommit = this.defaultAutoCommit;
        to.defaultReadOnly = this.defaultReadOnly;
        to.defaultTransactionIsolation = this.defaultTransactionIsolation;
        to.defaultCatalog = this.defaultCatalog;
        to.name = this.name;
        to.username = this.username;
        to.password = this.password;
        to.jdbcUrl = this.jdbcUrl;
        to.driverClass = this.driverClass;
        to.connectProperties = this.connectProperties;
        to.passwordCallback = this.passwordCallback;
        to.userCallback = this.userCallback;
        to.initialSize = this.initialSize;
        to.maxActive = this.maxActive;
        to.minIdle = this.minIdle;
        to.maxIdle = this.maxIdle;
        to.maxWait = this.maxWait;
        to.validationQuery = this.validationQuery;
        to.validationQueryTimeout = this.validationQueryTimeout;
        to.testOnBorrow = this.testOnBorrow;
        to.testOnReturn = this.testOnReturn;
        to.testWhileIdle = this.testWhileIdle;
        to.poolPreparedStatements = this.poolPreparedStatements;
        to.sharePreparedStatements = this.sharePreparedStatements;
        to.maxPoolPreparedStatementPerConnectionSize = this.maxPoolPreparedStatementPerConnectionSize;
        to.logWriter = this.logWriter;
        if (this.filters != null) {
            to.filters = new ArrayList<Filter>(this.filters);
        }
        to.exceptionSorter = this.exceptionSorter;
        to.driver = this.driver;
        to.queryTimeout = this.queryTimeout;
        to.transactionQueryTimeout = this.transactionQueryTimeout;
        to.accessToUnderlyingConnectionAllowed = this.accessToUnderlyingConnectionAllowed;
        to.timeBetweenEvictionRunsMillis = this.timeBetweenEvictionRunsMillis;
        to.numTestsPerEvictionRun = this.numTestsPerEvictionRun;
        to.minEvictableIdleTimeMillis = this.minEvictableIdleTimeMillis;
        to.removeAbandoned = this.removeAbandoned;
        to.removeAbandonedTimeoutMillis = this.removeAbandonedTimeoutMillis;
        to.logAbandoned = this.logAbandoned;
        to.maxOpenPreparedStatements = this.maxOpenPreparedStatements;
        if (this.connectionInitSqls != null) {
            to.connectionInitSqls = new ArrayList<String>(this.connectionInitSqls);
        }
        to.dbType = this.dbType;
        to.timeBetweenConnectErrorMillis = this.timeBetweenConnectErrorMillis;
        to.validConnectionChecker = this.validConnectionChecker;
        to.connectionErrorRetryAttempts = this.connectionErrorRetryAttempts;
        to.breakAfterAcquireFailure = this.breakAfterAcquireFailure;
        to.transactionThresholdMillis = this.transactionThresholdMillis;
        to.dupCloseLogEnable = this.dupCloseLogEnable;
        to.isOracle = this.isOracle;
        to.useOracleImplicitCache = this.useOracleImplicitCache;
    }

    public abstract void discardConnection(Connection var1);
}

