/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLKeep;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLAggregateExpr
extends SQLExprImpl
implements Serializable,
SQLReplaceable {
    private static final long serialVersionUID = 1L;
    protected String methodName;
    protected long methodNameHashCod64;
    protected SQLAggregateOption option;
    protected final List<SQLExpr> arguments = new ArrayList<SQLExpr>();
    protected SQLKeep keep;
    protected SQLExpr filter;
    protected SQLOver over;
    protected SQLName overRef;
    protected SQLOrderBy withinGroup;
    protected Boolean ignoreNulls = false;

    public SQLAggregateExpr(String methodName) {
        this.methodName = methodName;
    }

    public SQLAggregateExpr(String methodName, SQLAggregateOption option) {
        this.methodName = methodName;
        this.option = option;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public long methodNameHashCod64() {
        if (this.methodNameHashCod64 == 0L) {
            this.methodNameHashCod64 = FnvHash.hashCode64(this.methodName);
        }
        return this.methodNameHashCod64;
    }

    public SQLOrderBy getWithinGroup() {
        return this.withinGroup;
    }

    public void setWithinGroup(SQLOrderBy withinGroup) {
        if (withinGroup != null) {
            withinGroup.setParent(this);
        }
        this.withinGroup = withinGroup;
    }

    public SQLAggregateOption getOption() {
        return this.option;
    }

    public void setOption(SQLAggregateOption option) {
        this.option = option;
    }

    public List<SQLExpr> getArguments() {
        return this.arguments;
    }

    public void addArgument(SQLExpr argument) {
        if (argument != null) {
            argument.setParent(this);
        }
        this.arguments.add(argument);
    }

    public SQLOver getOver() {
        return this.over;
    }

    public void setOver(SQLOver over) {
        if (over != null) {
            over.setParent(this);
        }
        this.over = over;
    }

    public SQLName getOverRef() {
        return this.overRef;
    }

    public void setOverRef(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.overRef = x;
    }

    public SQLKeep getKeep() {
        return this.keep;
    }

    public void setKeep(SQLKeep keep) {
        if (keep != null) {
            keep.setParent(this);
        }
        this.keep = keep;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls != null && this.ignoreNulls != false;
    }

    public Boolean getIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.arguments);
            this.acceptChild(visitor, this.keep);
            this.acceptChild(visitor, this.over);
            this.acceptChild(visitor, this.overRef);
            this.acceptChild(visitor, this.withinGroup);
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.addAll(this.arguments);
        if (this.keep != null) {
            children.add(this.keep);
        }
        if (this.over != null) {
            children.add(this.over);
        }
        if (this.withinGroup != null) {
            children.add(this.withinGroup);
        }
        return children;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLAggregateExpr that = (SQLAggregateExpr)o;
        if (this.methodNameHashCod64 != that.methodNameHashCod64) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.option != that.option) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.keep != null ? !this.keep.equals(that.keep) : that.keep != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.over != null ? !this.over.equals(that.over) : that.over != null) {
            return false;
        }
        if (this.overRef != null ? !this.overRef.equals(that.overRef) : that.overRef != null) {
            return false;
        }
        if (this.withinGroup != null ? !this.withinGroup.equals(that.withinGroup) : that.withinGroup != null) {
            return false;
        }
        return this.ignoreNulls != null ? this.ignoreNulls.equals(that.ignoreNulls) : that.ignoreNulls == null;
    }

    @Override
    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (int)(this.methodNameHashCod64 ^ this.methodNameHashCod64 >>> 32);
        result = 31 * result + (this.option != null ? this.option.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.keep != null ? this.keep.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.over != null ? this.over.hashCode() : 0);
        result = 31 * result + (this.overRef != null ? this.overRef.hashCode() : 0);
        result = 31 * result + (this.withinGroup != null ? this.withinGroup.hashCode() : 0);
        result = 31 * result + (this.ignoreNulls != null ? this.ignoreNulls.hashCode() : 0);
        return result;
    }

    @Override
    public SQLAggregateExpr clone() {
        SQLAggregateExpr x = new SQLAggregateExpr(this.methodName);
        x.option = this.option;
        for (SQLExpr arg : this.arguments) {
            x.addArgument(arg.clone());
        }
        if (this.keep != null) {
            x.setKeep(this.keep.clone());
        }
        if (this.filter != null) {
            x.setFilter(this.filter.clone());
        }
        if (this.over != null) {
            x.setOver(this.over.clone());
        }
        if (this.overRef != null) {
            x.setOverRef(this.overRef.clone());
        }
        if (this.withinGroup != null) {
            x.setWithinGroup(this.withinGroup.clone());
        }
        x.ignoreNulls = this.ignoreNulls;
        return x;
    }

    public SQLExpr getFilter() {
        return this.filter;
    }

    public void setFilter(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.filter = x;
    }

    @Override
    public SQLDataType computeDataType() {
        SQLDataType dataType;
        long hash = this.methodNameHashCod64();
        if (hash == FnvHash.Constants.COUNT || hash == FnvHash.Constants.ROW_NUMBER) {
            return SQLIntegerExpr.DEFAULT_DATA_TYPE;
        }
        if (this.arguments.size() > 0 && (dataType = this.arguments.get(0).computeDataType()) != null) {
            return dataType;
        }
        if (hash == FnvHash.Constants.WM_CONCAT || hash == FnvHash.Constants.GROUP_CONCAT) {
            return SQLCharExpr.DEFAULT_DATA_TYPE;
        }
        return null;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != expr) continue;
            this.arguments.set(i, target);
            target.setParent(this);
            return true;
        }
        if (this.overRef == expr) {
            this.setOverRef((SQLName)target);
            return true;
        }
        if (this.filter == expr) {
            this.filter = target;
            target.setParent(this);
            return true;
        }
        return false;
    }
}

