/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLMethodInvokeExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private SQLExpr owner;
    private final List<SQLExpr> parameters = new ArrayList<SQLExpr>();
    private SQLExpr from;
    private SQLExpr using;
    private SQLExpr _for;
    private String trimOption;
    private long nameHashCode64;

    public SQLMethodInvokeExpr() {
    }

    public SQLMethodInvokeExpr(String methodName) {
        this.name = methodName;
    }

    public SQLMethodInvokeExpr(String methodName, long nameHashCode64) {
        this.name = methodName;
        this.nameHashCode64 = nameHashCode64;
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner) {
        this.name = methodName;
        this.setOwner(owner);
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner, SQLExpr ... params) {
        this.name = methodName;
        this.setOwner(owner);
        for (SQLExpr param : params) {
            this.addParameter(param);
        }
    }

    public long methodNameHashCode64() {
        if (this.nameHashCode64 == 0L && this.name != null) {
            this.nameHashCode64 = FnvHash.hashCode64(this.name);
        }
        return this.nameHashCode64;
    }

    public String getMethodName() {
        return this.name;
    }

    public void setMethodName(String methodName) {
        this.name = methodName;
        this.nameHashCode64 = 0L;
    }

    public SQLExpr getOwner() {
        return this.owner;
    }

    public void setOwner(SQLExpr owner) {
        if (owner != null) {
            owner.setParent(this);
        }
        this.owner = owner;
    }

    public SQLExpr getFrom() {
        return this.from;
    }

    public void setFrom(SQLExpr from) {
        this.from = from;
    }

    public List<SQLExpr> getParameters() {
        return this.parameters;
    }

    public void addParameter(SQLExpr param) {
        if (param != null) {
            param.setParent(this);
        }
        this.parameters.add(param);
    }

    @Override
    public void output(StringBuffer buf) {
        if (this.owner != null) {
            this.owner.output(buf);
            buf.append(".");
        }
        buf.append(this.name);
        buf.append("(");
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            this.parameters.get(i).output(buf);
        }
        buf.append(")");
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.owner);
            this.acceptChild(visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        if (this.owner == null) {
            return this.parameters;
        }
        ArrayList<SQLExpr> children = new ArrayList<SQLExpr>();
        children.add(this.owner);
        children.addAll(this.parameters);
        return children;
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.owner);
            this.acceptChild((SQLASTVisitor)visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLMethodInvokeExpr that = (SQLMethodInvokeExpr)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return this.from != null ? this.from.equals(that.from) : that.from == null;
    }

    @Override
    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }

    @Override
    public SQLMethodInvokeExpr clone() {
        SQLMethodInvokeExpr x = new SQLMethodInvokeExpr();
        x.name = this.name;
        if (this.owner != null) {
            x.setOwner(this.owner.clone());
        }
        for (SQLExpr param : this.parameters) {
            x.addParameter(param.clone());
        }
        if (this.from != null) {
            x.setFrom(this.from.clone());
        }
        if (this.using != null) {
            x.setUsing(this.using.clone());
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != expr) continue;
            this.parameters.set(i, target);
            target.setParent(this);
            return true;
        }
        return false;
    }

    public boolean match(String owner, String function) {
        if (function == null) {
            return false;
        }
        if (!SQLUtils.nameEquals(function, this.name)) {
            return false;
        }
        if (owner == null && this.owner == null) {
            return true;
        }
        if (owner == null || this.owner == null) {
            return false;
        }
        if (this.owner instanceof SQLIdentifierExpr) {
            return SQLUtils.nameEquals(((SQLIdentifierExpr)this.owner).name, owner);
        }
        return false;
    }

    @Override
    public SQLDataType computeDataType() {
        if (SQLUtils.nameEquals("to_date", this.name) || SQLUtils.nameEquals("add_months", this.name)) {
            return SQLDateExpr.DEFAULT_DATA_TYPE;
        }
        if (this.parameters.size() == 1) {
            if (SQLUtils.nameEquals("trunc", this.name)) {
                return this.parameters.get(0).computeDataType();
            }
        } else if (this.parameters.size() == 2) {
            SQLExpr param0 = this.parameters.get(0);
            SQLExpr param1 = this.parameters.get(1);
            if (SQLUtils.nameEquals("nvl", this.name) || SQLUtils.nameEquals("ifnull", this.name)) {
                SQLDataType dataType = param0.computeDataType();
                if (dataType != null) {
                    return dataType;
                }
                return param1.computeDataType();
            }
        }
        return null;
    }

    public SQLExpr getUsing() {
        return this.using;
    }

    public void setUsing(SQLExpr using) {
        if (using != null) {
            using.setParent(this);
        }
        this.using = using;
    }

    public SQLExpr getFor() {
        return this._for;
    }

    public void setFor(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this._for = x;
    }

    public String getTrimOption() {
        return this.trimOption;
    }

    public void setTrimOption(String trimOption) {
        this.trimOption = trimOption;
    }
}

