/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.queue.send;

import com.alibaba.dts.client.executor.grid.queue.TaskEvent;
import com.alibaba.dts.client.executor.grid.queue.send.MergingTaskGroup;
import com.alibaba.dts.client.executor.grid.queue.send.TaskMergeMonitor;
import com.alibaba.dts.client.executor.grid.queue.send.TaskMerger;
import com.alibaba.dts.client.executor.grid.queue.send.TaskRouter;
import com.alibaba.dts.client.executor.grid.queue.send.TaskSender;
import com.alibaba.dts.client.executor.grid.unit.FlexibleThreadPoolExecutor;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SendManager {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SendManager.class);
    private AtomicBoolean readyForSend = new AtomicBoolean(false);
    private ClientContextImpl clientContext;
    private int routeQueueSize = 0x100000;
    private int mergeQueueSize = 0x100000;
    private int sendQueueSize = 0x100000;
    private int routeThreadCount = 4;
    private int mergeThreadCount = 1;
    private int sendThreadCount = 16;
    private BlockingQueue<TaskEvent> routeQueue;
    private BlockingQueue<TaskEvent> mergeQueue;
    private BlockingQueue<TaskEvent> sendQueue;
    private ConcurrentHashMap<String, ConcurrentHashMap<Long, MergingTaskGroup>> mergingTaskGroupMapByTargetMachine = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<Long, MergingTaskGroup>> mergingTaskGroupMapByTargetMachineCompensation = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, List<RemoteMachine>> machinesByJob = new ConcurrentHashMap();

    public void init(ClientContextImpl clientContext) throws InitException {
        try {
            this.clientContext = clientContext;
            this.routeQueue = new ArrayBlockingQueue<TaskEvent>(this.routeQueueSize);
            this.mergeQueue = new ArrayBlockingQueue<TaskEvent>(this.mergeQueueSize);
            this.sendQueue = new ArrayBlockingQueue<TaskEvent>(this.sendQueueSize);
            FlexibleThreadPoolExecutor routeThreadPool = new FlexibleThreadPoolExecutor(this.routeThreadCount, this.routeThreadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("SchedulerX-Task-Route#"));
            for (int i = 0; i < this.routeThreadCount; ++i) {
                TaskRouter taskRouter = new TaskRouter(clientContext, this);
                routeThreadPool.submit(taskRouter);
            }
            FlexibleThreadPoolExecutor mergeThreadPool = new FlexibleThreadPoolExecutor(this.mergeThreadCount, this.mergeThreadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("SchedulerX-Task-Merge#"));
            for (int i = 0; i < this.mergeThreadCount; ++i) {
                mergeThreadPool.submit(new TaskMerger(clientContext, this));
            }
            FlexibleThreadPoolExecutor sendThreadPool = new FlexibleThreadPoolExecutor(this.sendThreadCount, this.sendThreadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("SchedulerX-Task-Send#"));
            for (int i = 0; i < this.sendThreadCount; ++i) {
                sendThreadPool.submit(new TaskSender(clientContext, this));
            }
            Executors.newScheduledThreadPool(1, new NamedThreadFactory("SchedulerX-TaskMergeMonitor -")).scheduleAtFixedRate(new TaskMergeMonitor(this), 0L, 2L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            throw new InitException("failed to init SendManager", throwable);
        }
    }

    public void putTasksToRouteQueue(List<TaskEvent> taskEvents, long jobInstanceId) {
        if (this.clientContext.getGridJobManager().containsInterruptedJobInstance(jobInstanceId)) {
            return;
        }
        for (TaskEvent taskEvent : taskEvents) {
            this.putSingleTaskToRouteQueue(taskEvent);
        }
    }

    public void putSingleTaskToRouteQueue(TaskEvent taskEvent) {
        try {
            this.routeQueue.put(taskEvent);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void resetRoutesMachines(long jobId, List<RemoteMachine> machines) {
        this.machinesByJob.put(jobId, machines);
    }

    public void clearMergingTaskGroupMap(long jobInstanceId) {
        try {
            for (ConcurrentHashMap<Long, MergingTaskGroup> remoteMachineMapByJobInstanceId : this.mergingTaskGroupMapByTargetMachine.values()) {
                remoteMachineMapByJobInstanceId.remove(jobInstanceId);
            }
            for (ConcurrentHashMap<Long, MergingTaskGroup> remoteMachineMapByJobInstanceId : this.mergingTaskGroupMapByTargetMachineCompensation.values()) {
                remoteMachineMapByJobInstanceId.remove(jobInstanceId);
            }
        }
        catch (Throwable throwable) {
            logger.error("faild to clearMergingTaskGroupMap, jobInstanceId=" + jobInstanceId, throwable);
        }
    }

    public BlockingQueue<TaskEvent> getRouteQueue() {
        return this.routeQueue;
    }

    public BlockingQueue<TaskEvent> getMergeQueue() {
        return this.mergeQueue;
    }

    public BlockingQueue<TaskEvent> getSendQueue() {
        return this.sendQueue;
    }

    public ConcurrentHashMap<Long, List<RemoteMachine>> getMachinesByJob() {
        return this.machinesByJob;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Long, MergingTaskGroup>> getMergingTaskGroupMapByTargetMachine() {
        return this.mergingTaskGroupMapByTargetMachine;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Long, MergingTaskGroup>> getMergingTaskGroupMapByTargetMachineCompensation() {
        return this.mergingTaskGroupMapByTargetMachineCompensation;
    }

    public AtomicBoolean getReadyForSend() {
        return this.readyForSend;
    }

    public ClientContextImpl getClientContext() {
        return this.clientContext;
    }

    public void setRouteQueueSize(int routeQueueSize) {
        this.routeQueueSize = routeQueueSize;
    }

    public void setMergeQueueSize(int mergeQueueSize) {
        this.mergeQueueSize = mergeQueueSize;
    }

    public void setSendQueueSize(int sendQueueSize) {
        this.sendQueueSize = sendQueueSize;
    }

    public void setRouteThreadCount(int routeThreadCount) {
        this.routeThreadCount = routeThreadCount;
    }

    public void setMergeThreadCount(int mergeThreadCount) {
        this.mergeThreadCount = mergeThreadCount;
    }

    public void setSendThreadCount(int sendThreadCount) {
        this.sendThreadCount = sendThreadCount;
    }
}

