/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.timer;

import com.alibaba.dts.client.executor.grid.GridTaskSender;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.ExecutionCounter;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.exception.AccessException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CompensationTimer {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(CompensationTimer.class);
    private ClientContextImpl clientContext;
    private List<Job> jobs = new ArrayList<Job>();
    private List<JobInstanceSnapshot> jobInstanceSnapshots = new ArrayList<JobInstanceSnapshot>();
    private int status = 0;

    public CompensationTimer(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String serverAddress = CompensationTimer.this.clientContext.getNodeConfig().getLocalAddress();
                    if (1 == CompensationTimer.this.status) {
                        logger.warn("[Compensation]: start compensation task is running, so return, serverAddress:" + serverAddress);
                        return;
                    }
                    GridTaskSender gridSender = CompensationTimer.this.clientContext.getGridTaskSender();
                    List compensationTasks = CompensationTimer.this.listRetryTasks(0L, 1000);
                    while (compensationTasks != null && !compensationTasks.isEmpty()) {
                        ArrayList<ExecutableTask> executableTasks = new ArrayList<ExecutableTask>();
                        for (TaskSnapshot compensationTask : compensationTasks) {
                            ExecutableTask executableTask;
                            Job job;
                            compensationTask.setCompensation(true);
                            long jobInstanceId = compensationTask.getJobInstanceId();
                            JobInstanceSnapshot jobInstanceSnapshot = CompensationTimer.this.getJobInstanceExisted(jobInstanceId);
                            if (jobInstanceSnapshot == null) {
                                Result result = CompensationTimer.this.getJobInstance(jobInstanceId);
                                if (result == null || result.getResultCode() != ResultCode.SUCCESS || result.getData() == null) continue;
                                jobInstanceSnapshot = (JobInstanceSnapshot)result.getData();
                                CompensationTimer.this.jobInstanceSnapshots.add(jobInstanceSnapshot);
                            }
                            if ((job = CompensationTimer.this.getJobExisted(jobInstanceSnapshot.getJobId())) == null) {
                                Result result = CompensationTimer.this.getJob(jobInstanceSnapshot.getJobId());
                                if (result == null || result.getResultCode() != ResultCode.SUCCESS || result.getData() == null) continue;
                                job = (Job)result.getData();
                                CompensationTimer.this.jobs.add(job);
                            }
                            if ((executableTask = this.getExecutableTask(executableTasks, jobInstanceId)) == null) {
                                executableTask = new ExecutableTask();
                                executableTask.setJobInstanceSnapshot(jobInstanceSnapshot);
                                executableTask.setJob(job);
                                executableTasks.add(executableTask);
                            }
                            executableTask.getTaskSnapshotList().add(compensationTask);
                        }
                        for (ExecutableTask executableTask : executableTasks) {
                            JobContextImpl jobContext = new JobContextImpl();
                            jobContext.setJob(executableTask.getJob());
                            jobContext.setJobInstanceSnapshot(executableTask.getJobInstanceSnapshot());
                            CompensationTimer.this.updateTasksStatus2Retrying(executableTask);
                            Result<Boolean> result = gridSender.dispatchCompensateTaskList(executableTask.getTaskSnapshotList(), jobContext);
                            if (result != null && result.getData().booleanValue()) {
                                for (TaskSnapshot taskSnapshot : executableTask.getTaskSnapshotList()) {
                                    String receiveNodeAddress = taskSnapshot.getReceiveNodeAddress();
                                    String taskName = taskSnapshot.getTaskName();
                                    ExecutionCounter executionCounter = CompensationTimer.this.clientContext.getExecutionCounterTable().get(executableTask.getJobInstanceSnapshot().getId()).get(receiveNodeAddress).get(taskName);
                                    if (executionCounter == null) continue;
                                    executionCounter.getFailCounter().getAndDecrement();
                                    executionCounter.getTotalCounter().getAndDecrement();
                                }
                                continue;
                            }
                            CompensationTimer.this.updateTasksStatus2Failure(executableTask);
                        }
                        long start = ((TaskSnapshot)compensationTasks.get(compensationTasks.size() - 1)).getId();
                        compensationTasks = CompensationTimer.this.listRetryTasks(start, 1000);
                    }
                }
                catch (Throwable throwable) {
                    logger.error(throwable.getMessage(), throwable);
                }
                finally {
                    CompensationTimer.this.status = 0;
                }
            }

            private ExecutableTask getExecutableTask(List<ExecutableTask> executableTasks, long jobInstanceId) {
                for (ExecutableTask executableTask : executableTasks) {
                    if (executableTask.getJobInstanceSnapshot().getId() != jobInstanceId) continue;
                    return executableTask;
                }
                return null;
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    private Job getJobExisted(long jobId) {
        for (Job job : this.jobs) {
            if (job.getId() != jobId) continue;
            return job;
        }
        return null;
    }

    private JobInstanceSnapshot getJobInstanceExisted(long jobInstanceId) {
        for (JobInstanceSnapshot jobInstanceSnapshot : this.jobInstanceSnapshots) {
            if (jobInstanceSnapshot == null || jobInstanceSnapshot.getId() != jobInstanceId) continue;
            return jobInstanceSnapshot;
        }
        return null;
    }

    private List<TaskSnapshot> listRetryTasks(long start, int limit) {
        List<TaskSnapshot> taskSnapshots = null;
        try {
            taskSnapshots = this.clientContext.getStore().getTaskSnapshotDao().listTaskSnapshotsFromStartId(start, limit);
        }
        catch (AccessException e) {
            logger.error("listRetryTasks error, start id {}, limit {} ", start, limit, e);
            return null;
        }
        return taskSnapshots;
    }

    public void removeJobInstanceSnapshot(long jobInstanceId) {
        Iterator<JobInstanceSnapshot> iterator = this.jobInstanceSnapshots.iterator();
        while (iterator.hasNext()) {
            JobInstanceSnapshot jobInstanceSnapshot = iterator.next();
            if (jobInstanceSnapshot.getId() != jobInstanceId) continue;
            iterator.remove();
            return;
        }
    }

    private Result<JobInstanceSnapshot> getJobInstance(long jobInstanceId) {
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        Result<JobInstanceSnapshot> result = null;
        for (String server : serverList) {
            InvocationContext.setRemoteMachine(new RemoteMachine(server));
            result = this.clientContext.getServerService().getJobInstanceById(jobInstanceId);
            if (result != null) break;
            logger.error("clientContext getServerService getJobInstanceById error from server {} with job instance id {}", (Object)server, (Object)jobInstanceId);
        }
        return result;
    }

    private Result<Job> getJob(long jobId) {
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        Result<Job> result = null;
        for (String server : serverList) {
            InvocationContext.setRemoteMachine(new RemoteMachine(server));
            result = this.clientContext.getServerService().getJobById(jobId);
            if (result != null) break;
            logger.error("clientContext getServerService getJobById error from server {} with job id {}", (Object)server, (Object)jobId);
        }
        return result;
    }

    private void updateTasksStatus2Retrying(ExecutableTask executableTask) {
        try {
            this.clientContext.getStore().getTaskSnapshotDao().updateStatusBatch(executableTask.getTaskSnapshotList(), 9);
        }
        catch (Throwable throwable) {
            logger.error("update tasksnapshot status error, id={}", (Object)executableTask, (Object)throwable);
        }
    }

    private void updateTasksStatus2Failure(ExecutableTask executableTask) {
        try {
            this.clientContext.getStore().getTaskSnapshotDao().updateStatusBatch(executableTask.getTaskSnapshotList(), 4);
        }
        catch (Throwable throwable) {
            logger.error("update tasksnapshot status error, id={}", (Object)executableTask, (Object)throwable);
        }
    }
}

