/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.timer;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.domain.store.ExecutionCounter;
import com.alibaba.dts.common.exception.AccessException;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ExecutionCounterUpdateTimer {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ExecutionCounterUpdateTimer.class);
    private ClientContextImpl clientContext;

    public ExecutionCounterUpdateTimer(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() throws InitException {
        final ConcurrentHashMap<Long, ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>> executionCounterTable = this.clientContext.getExecutionCounterTable();
        try {
            this.loadExecutionCounters(executionCounterTable);
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Map.Entry executionCounterEntry : executionCounterTable.entrySet()) {
                            Long jobInstanceId = (Long)executionCounterEntry.getKey();
                            ConcurrentHashMap executionCounterMapByReceiveNode = (ConcurrentHashMap)executionCounterEntry.getValue();
                            for (Map.Entry entryByReceiveNode : executionCounterMapByReceiveNode.entrySet()) {
                                String receiveNode = (String)entryByReceiveNode.getKey();
                                ConcurrentHashMap executionCounterMapByTaskName = (ConcurrentHashMap)entryByReceiveNode.getValue();
                                for (Map.Entry entryByTaskName : executionCounterMapByTaskName.entrySet()) {
                                    String taskName = (String)entryByTaskName.getKey();
                                    ExecutionCounter executionCounter = (ExecutionCounter)entryByTaskName.getValue();
                                    executionCounter.setJobInstanceId(jobInstanceId);
                                    executionCounter.setReceiveNode(receiveNode);
                                    executionCounter.setTaskName(taskName);
                                    ExecutionCounter executionCounterDb = ExecutionCounterUpdateTimer.this.clientContext.getStore().getExecutionCounterDao().getByJobInstanceAndExecutionNodeAndTaskName(jobInstanceId, receiveNode, taskName);
                                    if (executionCounterDb == null) {
                                        ExecutionCounterUpdateTimer.this.clientContext.getStore().getExecutionCounterDao().createExecutionCounter(executionCounter);
                                        continue;
                                    }
                                    if (executionCounter.getId() == 0L) {
                                        executionCounter.setId(executionCounterDb.getId());
                                    }
                                    ExecutionCounterUpdateTimer.this.clientContext.getStore().getExecutionCounterDao().updateExecutionCounter(executionCounter);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        logger.error(throwable.getMessage(), throwable);
                    }
                }
            }, 10L, 1L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            logger.error("ExecutionCounterUpdateTimer init error");
            throw new InitException("ExecutionCounterUpdateTimer init error", throwable);
        }
    }

    private void loadExecutionCounters(ConcurrentHashMap<Long, ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>> executionCounterTable) {
        List<ExecutionCounter> executionCounters = null;
        try {
            executionCounters = this.clientContext.getStore().getExecutionCounterDao().list();
        }
        catch (AccessException e) {
            logger.error("list executions failed", e);
        }
        if (executionCounters == null || executionCounters.isEmpty()) {
            return;
        }
        for (ExecutionCounter executionCounter : executionCounters) {
            ConcurrentHashMap<String, ExecutionCounter> executionCounterMapByTaskNameExist;
            ConcurrentHashMap<String, ExecutionCounter> executionCounterMapByTaskName;
            Long jobInstanceId = executionCounter.getJobInstanceId();
            String receiveNode = executionCounter.getReceiveNode();
            String taskName = executionCounter.getTaskName();
            ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>> executionCounterMapByReceiveNode = executionCounterTable.get(jobInstanceId);
            if (executionCounterMapByReceiveNode == null) {
                executionCounterMapByReceiveNode = new ConcurrentHashMap();
                ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>> executionCounterMapByReceiveNodeExist = this.clientContext.getExecutionCounterTable().putIfAbsent(jobInstanceId, executionCounterMapByReceiveNode);
                if (executionCounterMapByReceiveNodeExist != null) {
                    executionCounterMapByReceiveNode = executionCounterMapByReceiveNodeExist;
                }
            }
            if ((executionCounterMapByTaskName = executionCounterMapByReceiveNode.get(receiveNode)) == null && (executionCounterMapByTaskNameExist = executionCounterMapByReceiveNode.putIfAbsent(receiveNode, executionCounterMapByTaskName = new ConcurrentHashMap())) != null) {
                executionCounterMapByTaskName = executionCounterMapByTaskNameExist;
            }
            executionCounterMapByTaskName.putIfAbsent(taskName, executionCounter);
        }
    }
}

