/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.timer;

import com.alibaba.dts.client.config.NodeConfig;
import com.alibaba.dts.client.executor.grid.timer.SystemMonitor;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.store.Store;
import com.alibaba.dts.common.exception.AccessException;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.NamedThreadFactory;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class HealthChecker {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(HealthChecker.class);
    public static volatile AtomicBoolean h2Alive = new AtomicBoolean(true);
    public static volatile AtomicLong failCounter = new AtomicLong();
    private ClientContextImpl clientContext;
    private ScheduledThreadPoolExecutor HealthCheckThreadPool = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("SchedulerX-H2-Health-Check-Thread-"));

    public HealthChecker(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() {
        this.HealthCheckThreadPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SystemMonitor.getDiskAvailablePercentage().get() < 5) {
                        logger.error("healthCheck error disk usage < 5% !");
                        h2Alive.set(false);
                        return;
                    }
                    HealthChecker.this.clientContext.getStore().getTaskSnapshotDao().queryTotalCount();
                    h2Alive.set(true);
                    failCounter.set(0L);
                }
                catch (AccessException e) {
                    h2Alive.set(false);
                    long count = failCounter.addAndGet(1L);
                    if (count % 6L == 0L) {
                        logger.error("healthCheck error", e);
                        HealthChecker.this.recover();
                    }
                }
                catch (Throwable throwable) {
                    logger.error("healthCheck error", throwable);
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private void recover() {
        logger.info("start recovering, dbPath={}...", (Object)this.clientContext.getNodeConfig().getDbPath());
        try {
            this.closeStore();
            this.deleteDbFile(this.clientContext.getNodeConfig());
            this.reSetStore(this.clientContext);
            h2Alive.set(true);
            logger.info("recovering finished");
        }
        catch (Throwable e) {
            logger.error("recover datasource error", e);
        }
    }

    private void checkDiskSpace() throws IOException {
        if (SystemMonitor.getDiskAvailablePercentage().get() < 10) {
            throw new IOException("disk usable space is less than 10%");
        }
    }

    private void closeStore() {
        this.clientContext.getStore().close();
    }

    private void reSetStore(ClientContextImpl clientContext) throws InitException {
        clientContext.setStore(new Store(clientContext));
        clientContext.getStore().init();
    }

    private void deleteDbFile(NodeConfig nodeConfig) {
        String dbUrl = this.clientContext.getNodeConfig().getDbPath();
        File file = new File(dbUrl);
        if (file.exists() && file.isDirectory()) {
            for (File dbFile : file.listFiles()) {
                if (!dbFile.exists()) continue;
                dbFile.delete();
            }
        }
    }
}

