/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.simple.processor;

import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.client.executor.simple.processor.SimpleJobContext;
import com.alibaba.dts.client.service.JobRunningStateManager;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.BytesUtil;

public class SimpleJobContextImpl
extends JobContextImpl
implements Constants,
SimpleJobContext {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SimpleJobContextImpl.class);
    private Object task;
    private int availableMachineAmount;
    private int currentMachineNumber;

    public SimpleJobContextImpl() {
    }

    public SimpleJobContextImpl(Job job, JobInstanceSnapshot jobInstanceSnapshot, int retryCount) {
        super(job, jobInstanceSnapshot, retryCount);
    }

    @Override
    public void setTask(TaskSnapshot taskSnapshot) {
        if (BytesUtil.isEmpty(taskSnapshot.getBody())) {
            logger.error("[SimpleJobContext]: BytesUtil setTask bytesToObject error, body is empty, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
            return;
        }
        try {
            this.task = BytesUtil.bytesToObject(taskSnapshot.getBody());
        }
        catch (Throwable e) {
            logger.error("[SimpleJobContext]: BytesUtil setTask bytesToObject error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
        }
    }

    @Override
    public void updateJobRunningStatus(String status) {
        JobRunningStateManager.getManageHandler().addJobRunningState(this.jobInstanceSnapshot.getId(), status);
    }

    @Override
    public Object getTask() {
        return this.task;
    }

    @Override
    public int getAvailableMachineAmount() {
        return this.availableMachineAmount;
    }

    @Override
    public void setAvailableMachineAmount(int availableMachineAmount) {
        this.availableMachineAmount = availableMachineAmount;
    }

    @Override
    public int getCurrentMachineNumber() {
        return this.currentMachineNumber;
    }

    @Override
    public void setCurrentMachineNumber(int currentMachineNumber) {
        this.currentMachineNumber = currentMachineNumber;
    }
}

