/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.logger.innerlog;

import com.alibaba.dts.common.logger.innerlog.LoggerMethodEnum;
import com.alibaba.dts.shade.org.apache.commons.lang.ArrayUtils;
import com.alibaba.dts.shade.org.apache.commons.lang.reflect.MethodUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoggerMethodCache {
    static final Class<?>[] ONE_STRING_ARRAY = new Class[]{String.class};
    static final Class<?>[] FORMAT_ONE_ARRAY = new Class[]{String.class, Object.class};
    static final Class<?>[] FORMAT_TWO_ARRAY = new Class[]{String.class, Object.class, Object.class};
    static final Class<?>[] FORMAT_MANY_ARRAY = new Class[]{String.class, Object[].class};
    static final Class<?>[] THROWABLE_ARRAY = new Class[]{String.class, Throwable.class};
    private ConcurrentHashMap<Integer, Map<String, Method>> methodCache = new ConcurrentHashMap();

    public void put(Integer classLoaderId, String cachKey, Method method) {
        Map<String, Method> caches = this.getCacheWitchClassLoader(classLoaderId);
        method.setAccessible(true);
        caches.put(cachKey, method);
    }

    public void put(Integer classLoaderId, String cachKey, Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        Map<String, Method> caches = this.getCacheWitchClassLoader(classLoaderId);
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, methodName, parameterTypes);
        method.setAccessible(true);
        caches.put(cachKey, method);
    }

    public Object invoke(Integer classLoaderId, String cachKey, Object obj) {
        return this.invoke(classLoaderId, cachKey, obj, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public Object invokeStatic(Integer classLoaderId, String cachKey) {
        return this.invoke(classLoaderId, cachKey, null, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public Object invokeStatic(Integer classLoaderId, String cachKey, Object ... args) {
        return this.invoke(classLoaderId, cachKey, null, args);
    }

    public boolean containsKey(Integer classLoaderId, String cacheKey) {
        Map<String, Method> caches = this.getCacheWitchClassLoader(classLoaderId);
        return caches.containsKey(cacheKey);
    }

    public Map<String, Method> getCacheWitchClassLoader(Integer classLoaderId) {
        Map<String, Method> value = this.methodCache.get(classLoaderId);
        if (null == value) {
            value = new HashMap<String, Method>(LoggerMethodEnum.values().length);
            this.methodCache.put(classLoaderId, value);
        }
        return value;
    }

    public Object invoke(Integer classLoaderId, String cachKey, Object obj, Object ... args) {
        Map<String, Method> caches = this.getCacheWitchClassLoader(classLoaderId);
        Method method = caches.get(cachKey);
        if (null == method) {
            throw new RuntimeException("not find method cache maybe not init put cacheKey: " + cachKey);
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Throwable e) {
            throw new RuntimeException("invoke method Error ! cacheKey: " + cachKey, e);
        }
    }
}

