/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.sdk;

import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.assemble.JobStatus;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.remoting.protocol.RemotingSerializable;
import com.alibaba.dts.common.util.CheckUtil;
import com.alibaba.dts.common.util.DiamondHelper;
import com.alibaba.dts.common.util.GroupIdUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.sdk.DtsSecureSDKManager;
import com.alibaba.dts.sdk.SDKMode;
import com.alibaba.dts.sdk.client.DtsHttpClient;
import com.alibaba.dts.sdk.context.SDKContext;
import com.alibaba.dts.sdk.util.exception.SDKModeUnsupportException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

public class DtsSecureCommonSDKManager
implements DtsSecureSDKManager {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DtsSecureCommonSDKManager.class);
    private SDKMode mode = SDKMode.ALIYUN_MODE;
    public long clusterId;
    private DtsHttpClient client = new DtsHttpClient();

    public DtsSecureCommonSDKManager(SDKMode mode) {
        this.mode = mode;
        if (mode == SDKMode.DAILY_MODE) {
            this.client.setDomainUrl(SDKContext.DTS_DOMAIN_DAILY_URL);
        } else if (mode == SDKMode.ONLINE_MODE) {
            this.client.setDomainUrl(SDKContext.DTS_DOMAIN_ONLINE_URL);
        } else if (mode == SDKMode.ALIYUN_MODE) {
            this.client.setDomainUrl(SDKContext.DTS_DOMAIN_ALIYUN_URL);
        } else if (mode == SDKMode.USA_MODE) {
            this.client.setDomainUrl(SDKContext.DTS_DOMAIN_USA_URL);
        } else {
            throw new SDKModeUnsupportException("sdk mode not support!");
        }
    }

    public DtsSecureCommonSDKManager(String url) {
        if (StringUtil.isBlank(url)) {
            throw new RuntimeException("url\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.client.setDomainUrl(url);
    }

    public DtsSecureCommonSDKManager() {
        String domainName = null;
        try {
            domainName = DiamondHelper.getData("com.alibaba.dts.common.domainName", 10000L);
            this.client.setDomainUrl("http://" + domainName + "/dts-console");
            DiamondHelper.addListener("com.alibaba.dts.common.domainName", new DiamondHelper.DataListener(){

                @Override
                public void receiveConfigInfo(String dataId, String configInfo) {
                    DtsSecureCommonSDKManager.this.client.setDomainUrl("http://" + configInfo + "/dts-console");
                }
            });
        }
        catch (Throwable e) {
            throw new RuntimeException("[DtsCommonSDKManager]: get domainName from diamond error", e);
        }
        if (StringUtil.isBlank(domainName)) {
            throw new RuntimeException("[DtsCommonSDKManager]: domainName is blank error");
        }
    }

    @Override
    public Result<Long> createJob(String userGroupId, Job job) {
        Result<Long> result = new Result<Long>();
        if (StringUtil.isBlank(userGroupId) || !GroupIdUtil.checkClientGroupId(userGroupId)) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u7ec4\u540d\u4e0d\u6b63\u786e!");
            return result;
        }
        Result<Boolean> checkResult = CheckUtil.checkUserConfigJob(job);
        if (!checkResult.getData().booleanValue()) {
            result.setResultCode(checkResult.getResultCode());
            result.getResultCode().setInformation(checkResult.getResultCode().getInformation());
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_create_job");
        this.client.addParameter("userGroupId", userGroupId);
        this.client.addParameter("jobProcessor", job.getJobProcessor()).addParameter("jobType", String.valueOf(job.getType())).addParameter("cronExpression", job.getCronExpression()).addParameter("jobDesc", StringUtil.isEmpty(job.getDescription()) ? "" : job.getDescription()).addParameter("firePolicy", String.valueOf(job.getMaxInstanceAmount())).addParameter("jobArguments", StringUtil.isEmpty(job.getJobArguments()) ? "" : job.getJobArguments()).addParameter("jobStatus", String.valueOf(job.getStatus())).addParameter("clusterCode", String.valueOf(job.getClusterCode()));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: createJob json isBlank, userGroupId:" + userGroupId + ", job:" + job + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(jsonResult.getLong("jobId"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: createJob, userGroupId:" + userGroupId + ", job:" + job + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Integer> deleteJob(String userGroupId, long jobId) {
        Result<Integer> result = new Result<Integer>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_delete_job");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: deleteJob json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(jsonResult.getInteger("deleteCount"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: deleteJob error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Job> getJobConfig(String userGroupId, long jobId) {
        Result<Job> result = new Result<Job>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_config");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobConfig json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                Job job = RemotingSerializable.fromJson(jsonResult.get((Object)"jobConfig").toString(), Job.class);
                result.setData(job);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobConfig error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Integer> updateJob(String groupId, Job job) {
        Result<Integer> result = new Result<Integer>();
        Result<Boolean> checkResult = CheckUtil.checkUserConfigJob(job);
        if (!checkResult.getData().booleanValue()) {
            result.setResultCode(checkResult.getResultCode());
            result.getResultCode().setInformation(checkResult.getResultCode().getInformation());
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_update_job");
        this.client.addParameter("jobId", String.valueOf(job.getId())).addParameter("jobProcessor", job.getJobProcessor()).addParameter("jobType", String.valueOf(job.getType())).addParameter("cronExpression", job.getCronExpression()).addParameter("jobDesc", StringUtil.isEmpty(job.getDescription()) ? "" : job.getDescription()).addParameter("firePolicy", String.valueOf(job.getMaxInstanceAmount())).addParameter("jobArguments", StringUtil.isEmpty(job.getJobArguments()) ? "" : job.getJobArguments()).addParameter("groupId", groupId);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: updateJob json isBlank, groupId:" + groupId + ", job:" + job + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(jsonResult.getInteger("updateCount"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: updateJob error, groupId:" + groupId + ", job:" + job + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> instanceRunJob(String userGroupId, long jobId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_instance_start_job");
        this.client.addParameter("jobId", String.valueOf(jobId)).addParameter("groupId", userGroupId);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: instanceRunJob json isBlank, userGroupId:" + userGroupId + ", jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation(postJson);
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.getResultCode().setInformation(postJson);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: instanceRunJob error, userGroupId:" + userGroupId + ", jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<JobStatus> getJobRunningStatus(String userGroupId, long jobId) {
        Result<JobStatus> result = new Result<JobStatus>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_status");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobRunningStatus json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                JobStatus jobStatus = RemotingSerializable.fromJson(jsonResult.get((Object)"status").toString(), JobStatus.class);
                result.setData(jobStatus);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobRunningStatus error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> instanceStopJob(String userGroupId, long jobId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_instance_stop_job");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: instanceStopJob json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: instanceStopJob error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> disableJob(String userGroupId, long jobId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_disable_job");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: disableJob json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: disableJob error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> enableJob(String userGroupId, long jobId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_enable_job");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: enableJob json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: enableJob error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public SDKMode getMode() {
        return this.mode;
    }

    public void setMode(SDKMode mode) {
        this.mode = mode;
    }
}

