/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.ali.dpath;

import com.alibaba.dts.shade.com.ali.dpath.DPathConstants;
import com.alibaba.dts.shade.com.ali.dpath.DPathRuleListener;
import com.alibaba.dts.shade.com.ali.dpath.DistinctAppRuleManagerListener;
import com.alibaba.dts.shade.com.ali.dpath.DistinctGlobalManagerListener;
import com.alibaba.dts.shade.com.ali.dpath.RuleData;
import com.alibaba.dts.shade.com.ali.dpath.util.DPathLogger;
import com.alibaba.dts.shade.com.ali.dpath.util.HostUtil;
import com.alibaba.dts.shade.com.ali.dpath.util.StringUtil;
import com.alibaba.dts.shade.com.taobao.diamond.client.Diamond;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Logger;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DPath {
    private static String DPATH_GLOBAL_ENV_RULE_DATA_ID = "com.alibaba.dts.shade.com.ali.dpath.global";
    private static String DPATH_APP_ENV_RULE_DATA_ID = "com.alibaba.dts.shade.com.ali.dpath.app.";
    private static volatile String GROUP = "DEFAULT_GROUP";
    public static String APPNAME = "unknown";
    private static Logger logger = DPathLogger.logger();
    private static final List<DPathRuleListener> ruleListeners = new ArrayList<DPathRuleListener>();
    private static Map<String, DistinctGlobalManagerListener> globalManagerListenerHashMap = new HashMap<String, DistinctGlobalManagerListener>();
    private static Map<String, DistinctAppRuleManagerListener> appRuleManagerListenerMap = new ConcurrentHashMap<String, DistinctAppRuleManagerListener>();
    private static AtomicBoolean appConfigExistFlag = new AtomicBoolean(false);

    public static void resetConfigGroup(String group) {
        if (GROUP.equals(group)) {
            return;
        }
        String oldGroup = GROUP;
        GROUP = group;
        DistinctGlobalManagerListener globalManagerListener = globalManagerListenerHashMap.remove(oldGroup);
        if (globalManagerListener != null) {
            Diamond.removeListener(DPATH_GLOBAL_ENV_RULE_DATA_ID, oldGroup, globalManagerListener);
        }
        HashSet<String> appNameSet = new HashSet<String>(appRuleManagerListenerMap.keySet());
        for (Map.Entry<String, DistinctAppRuleManagerListener> entry : appRuleManagerListenerMap.entrySet()) {
            String app = entry.getKey();
            DistinctAppRuleManagerListener listener = entry.getValue();
            String appGroup = listener.getGroup();
            String appRuleDataId = DPATH_APP_ENV_RULE_DATA_ID + app;
            Diamond.removeListener(appRuleDataId, appGroup, listener);
        }
        appRuleManagerListenerMap.clear();
        RuleData.setRuleData(null);
        DPath.observeGlobalRuleConfig();
        for (String app : appNameSet) {
            DPath.observeAppRuleConfig(app);
        }
    }

    public static synchronized void subscribeAppRule(String appName) {
        if (appName == null || appName.isEmpty()) {
            throw new IllegalArgumentException("appName can't be null");
        }
        DPath.observeAppRuleConfig(appName);
    }

    public static synchronized void unSubscribeAppRule(String appName) {
        if (appName == null || appName.isEmpty()) {
            throw new IllegalArgumentException("appName can't be null");
        }
        DistinctAppRuleManagerListener listener = appRuleManagerListenerMap.remove(appName);
        if (listener != null) {
            String appRuleDataId = DPATH_APP_ENV_RULE_DATA_ID + appName;
            String appGroup = listener.getGroup();
            Diamond.removeListener(appRuleDataId, appGroup, listener);
            listener.receiveConfigInfo(null);
        }
    }

    private static void observeAppRuleConfig(String appName) {
        try {
            if (appRuleManagerListenerMap.get(appName) != null) {
                return;
            }
            DistinctAppRuleManagerListener distinctManagerListener = new DistinctAppRuleManagerListener(appName, GROUP);
            String appRuleDataId = DPATH_APP_ENV_RULE_DATA_ID + appName;
            try {
                String rawConfig = Diamond.getConfig(appRuleDataId, GROUP, 10000L);
                distinctManagerListener.receiveConfigInfo(rawConfig);
            }
            catch (Throwable throwable) {
                logger.error("DPath", "", "Subscribe dpath config failed.", throwable);
            }
            Diamond.addListener(appRuleDataId, GROUP, distinctManagerListener);
            appRuleManagerListenerMap.put(appName, distinctManagerListener);
        }
        catch (Throwable t) {
            logger.error("DPath", "", "Subscribe dpath AppRuleConfig failed.", t);
        }
    }

    private static void observeGlobalRuleConfig() {
        try {
            DistinctGlobalManagerListener distinctManagerListener = new DistinctGlobalManagerListener();
            try {
                String rawConfig = Diamond.getConfig(DPATH_GLOBAL_ENV_RULE_DATA_ID, GROUP, 10000L);
                distinctManagerListener.receiveConfigInfo(rawConfig);
            }
            catch (Throwable throwable) {
                logger.error("DPath", "", "Subscribe dpath config failed.", throwable);
            }
            Diamond.addListener(DPATH_GLOBAL_ENV_RULE_DATA_ID, GROUP, distinctManagerListener);
            globalManagerListenerHashMap.put(GROUP, distinctManagerListener);
        }
        catch (Throwable t) {
            logger.error("DPath", "", "Subscribe dpath config failed.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyRule() {
        List<DPathRuleListener> list = ruleListeners;
        synchronized (list) {
            for (DPathRuleListener listener : ruleListeners) {
                try {
                    listener.onChanged(JSON.toJSONString((Object)RuleData.getRuleData()));
                }
                catch (Throwable t) {
                    logger.error("DPath", "", "Notify dpath rule listener failed.", t);
                }
            }
        }
    }

    public static boolean isEnable() {
        return RuleData.getRuleData().isEnable() && !RuleData.getRuleData().isEmpty();
    }

    public static String getLocalEnv() {
        return DPath.envOf(HostUtil.getNodeGroup(), HostUtil.getIp());
    }

    public static String getTargetEnv(String envInContext) {
        if (envInContext != null) {
            return envInContext;
        }
        return DPath.getLocalEnv();
    }

    public static Boolean getMsgFilterEnable(String env) {
        if (env != null) {
            return RuleData.getRuleData().env2MsgFilterEnable.containsKey(env) && RuleData.getRuleData().env2MsgFilterEnable.get(env) != false;
        }
        return DPath.getMsgFilterEnable(DPath.getLocalEnv());
    }

    public static boolean envContainsApp(String env, String app) {
        List<String> apps = RuleData.getRuleData().env2Apps.get(env);
        return apps != null && apps.contains(app);
    }

    public static int getFailoverPolicy(String env) {
        Integer failoverPolicy = RuleData.getRuleData().env2FailoverPolicy.get(env);
        if (failoverPolicy != null && failoverPolicy == DPathConstants.FAILOVER_ERROR) {
            return DPathConstants.FAILOVER_ERROR;
        }
        return DPathConstants.FAILOVER_BASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerRouterRuleListener(DPathRuleListener listener) {
        List<DPathRuleListener> list = ruleListeners;
        synchronized (list) {
            ruleListeners.add(listener);
            DPath.notifyRule();
        }
    }

    public static String envOf(String machineGroup, String ip) {
        RuleData ruleData = RuleData.getRuleData();
        if (ruleData == null || ruleData.isEmpty()) {
            return "DPathBaseEnv";
        }
        String env = null;
        if (!StringUtil.isEmpty(ip).booleanValue()) {
            env = ruleData.ip2Env.get(ip);
        }
        if (env == null && !StringUtil.isEmpty(machineGroup).booleanValue()) {
            env = ruleData.machineGroup2Env.get(machineGroup);
        }
        if (env == null) {
            env = "DPathBaseEnv";
        }
        return env;
    }

    public static boolean isLocalAppConfigExist() {
        return appConfigExistFlag.get();
    }

    public static void setLocalAppConfigExistFlag(boolean flag) {
        appConfigExistFlag.compareAndSet(!flag, flag);
    }

    static {
        String tempGroup = (String)System.getProperties().get("dpath.group");
        if (tempGroup != null && !tempGroup.isEmpty()) {
            GROUP = tempGroup;
        }
        DPath.observeGlobalRuleConfig();
        APPNAME = HostUtil.getAppName();
        DPath.subscribeAppRule(APPNAME);
    }
}

