/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.ali.dpath.util;

import com.alibaba.dts.shade.com.ali.dpath.util.DPathLogger;
import com.alibaba.dts.shade.com.ali.dpath.util.StringUtil;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Logger;
import com.taobao.vipserver.client.core.Host;
import com.taobao.vipserver.client.ipms.IPManager;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;

public class HostUtil {
    private static final String PARAM_MARKING_PROJECT = "project.name";
    private static final String DPATH_IP = "dpath.ip";
    private static String ip;
    private static String nodeGroup;
    private static String appName;
    private static Logger logger;

    public static String getIp() {
        return ip;
    }

    public static String getNodeGroup() {
        return nodeGroup;
    }

    public static String getAppName() {
        if (appName == null && StringUtil.isEmpty(appName = System.getProperty(PARAM_MARKING_PROJECT)).booleanValue()) {
            appName = "unknown";
        }
        return appName;
    }

    private static String getLocalGroup() {
        String ip = HostUtil.getIp();
        String localGroup = null;
        try {
            String nodeGroup;
            Host host = IPManager.getHostByIpSynchronously((String)ip);
            if (host != null && (nodeGroup = host.getNodeGroup()) != null) {
                localGroup = nodeGroup.trim();
            }
        }
        catch (Throwable throwable) {
            logger.error("DPath", "get machine group failed", throwable);
            return null;
        }
        if (localGroup == null || localGroup.isEmpty()) {
            logger.warn("HSF", "machine group of current host [{}] is null", ip);
            return null;
        }
        return localGroup;
    }

    private static String getLocalIp() {
        try {
            String ip = (String)System.getProperties().get(DPATH_IP);
            if (ip != null && !ip.isEmpty()) {
                return ip;
            }
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (!HostUtil.isValidAddress(inetAddress)) {
                return HostUtil.getLocalhostByNetworkInterface();
            }
            return inetAddress.getHostAddress();
        }
        catch (Throwable throwable) {
            try {
                String candidatesHost = HostUtil.getLocalhostByNetworkInterface();
                if (candidatesHost != null) {
                    return candidatesHost;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("InetAddress java.net.InetAddress.getLocalHost() throws UnknownHostException", throwable);
        }
    }

    private static String getLocalhostByNetworkInterface() throws SocketException {
        ArrayList<String> candidatesHost = new ArrayList<String>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if ("docker0".equals(networkInterface.getName()) || !networkInterface.isUp()) continue;
            Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress address = addrs.nextElement();
                if (!HostUtil.isValidAddress(address)) continue;
                if (address instanceof Inet6Address) {
                    candidatesHost.add(address.getHostAddress());
                    continue;
                }
                return address.getHostAddress();
            }
        }
        if (!candidatesHost.isEmpty()) {
            return (String)candidatesHost.get(0);
        }
        return null;
    }

    public static boolean isValidAddress(InetAddress address) {
        return address != null && !address.isLoopbackAddress() && !address.isAnyLocalAddress() && !address.isLinkLocalAddress();
    }

    static {
        logger = DPathLogger.logger();
        try {
            ip = HostUtil.getLocalIp();
            nodeGroup = HostUtil.getLocalGroup();
            if (nodeGroup == null) {
                nodeGroup = HostUtil.getLocalGroup();
            }
            if (nodeGroup == null) {
                logger.error("DPath", "Failed to get machine group of current node.");
            }
        }
        catch (Throwable t) {
            logger.error("DPath", "Init ip&nodeGroup info failed.", t);
        }
    }
}

