/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.AbstractContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.LocalContext_inner;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class RpcContext_inner
extends AbstractContext {
    private static final ThreadLocal<RpcContext_inner> threadLocal = new ThreadLocal();
    public static final String EAGLEEYE_TRACE_SIGNATURE_KEY = "s";
    final RpcContext_inner parentRpc;
    private final AtomicInteger childRpcIdx;
    LocalContext_inner localContext;

    RpcContext_inner(String _traceId, String _rpcId) {
        this(_traceId, _rpcId, (RpcContext_inner)null);
    }

    RpcContext_inner(String _traceId, String _rpcId, RpcContext_inner _parentRpc) {
        this(_traceId, _rpcId, _parentRpc, new AtomicInteger(0), new AtomicInteger(0));
    }

    RpcContext_inner(String _traceId, String _rpcId, RpcContext_inner _parentRpc, AtomicInteger _localIdx) {
        this(_traceId, _rpcId, _parentRpc, new AtomicInteger(0), _localIdx);
    }

    RpcContext_inner(String _traceId, String _rpcId, RpcContext_inner _parentRpc, AtomicInteger _childRpcIdx, AtomicInteger _localIdx) {
        super(_traceId, _rpcId, _localIdx);
        this.parentRpc = _parentRpc;
        this.childRpcIdx = _childRpcIdx;
    }

    String nextChildRpcId() {
        return this.rpcId + "." + this.childRpcIdx.incrementAndGet();
    }

    public void startLocal(String serviceName, String methodName) {
        LocalContext_inner tmpContext = this.getCurrentLocalContext();
        if (tmpContext != null && tmpContext.localId.length() > 64) {
            EagleEye.selfLog("[WARN] LocalContext leak detected, traceId=" + this.getTraceId() + ", localId=" + this.getLocalId());
            tmpContext = new LocalContext_inner(this.getTraceId(), this.getRpcId(), "9");
        }
        LocalContext_inner localCtx = new LocalContext_inner(this.traceId, this.getRpcId());
        localCtx.startRpc(serviceName, methodName);
        localCtx.localId = this.nextLocalId(tmpContext);
        localCtx.traceGroup = this.traceGroup;
        localCtx.attributes = this.attributes;
        localCtx.localAttributes = this.localAttributes;
        localCtx.localParent = tmpContext;
        this.localContext = localCtx;
    }

    public void endLocal(String resultCode, String appendMsg) {
        LocalContext_inner tmpContext = this.localContext;
        if (null == tmpContext) {
            EagleEye.selfLog("[ERROR] endLocal, no localRpc to end");
            return;
        }
        if (tmpContext.isEnd) {
            EagleEye.selfLog("[ERROR] localId " + tmpContext.localId + " already end");
            return;
        }
        tmpContext.isEnd = true;
        this.localContext = tmpContext.localParent;
        tmpContext.endRpc(resultCode, 30, appendMsg);
        EagleEye.commitLocalContext(tmpContext);
    }

    protected RpcContext_inner cloneInstance() {
        RpcContext_inner clone = new RpcContext_inner(this.traceId, this.getRpcId(), this.parentRpc, this.childRpcIdx, this.localIdx);
        clone.attributes = this.attributes;
        clone.localAttributes = this.localAttributes;
        clone.localContext = this.localContext;
        clone.traceName = this.traceName;
        clone.serviceName = this.serviceName;
        clone.methodName = this.methodName;
        clone.remoteIp = this.remoteIp;
        clone.callBackMsg = this.callBackMsg;
        clone.logType = this.logType;
        clone.rpcType = this.rpcType;
        clone.span0 = this.span0;
        clone.span1 = this.span1;
        clone.isTopRpc = this.isTopRpc;
        clone.startTime = this.startTime;
        clone.logTime = this.logTime;
        clone.requestSize = this.requestSize;
        clone.responseSize = this.responseSize;
        clone.traceGroup = this.traceGroup;
        clone.localId = this.localId;
        return clone;
    }

    LocalContext_inner getCurrentLocalContext() {
        LocalContext_inner tmpContext = this.localContext;
        while (null != tmpContext && tmpContext.isEnd) {
            tmpContext = tmpContext.localParent;
        }
        this.localContext = tmpContext;
        return tmpContext;
    }

    String nextLocalId(LocalContext_inner tmpContext) {
        if (tmpContext == null) {
            return "0." + this.localIdx.incrementAndGet();
        }
        return tmpContext.localId + "." + tmpContext.localIdx.incrementAndGet();
    }

    String getInnerLocalId() {
        if (null == this.localContext) {
            return "";
        }
        LocalContext_inner tmpContext = this.getCurrentLocalContext();
        if (tmpContext == null) {
            return "";
        }
        return tmpContext.getLocalId();
    }

    public RpcContext_inner createChildRpc() {
        RpcContext_inner parent;
        if (this.rpcId.length() > 64 && this.parentRpc != null && this.parentRpc.parentRpc != null) {
            EagleEye.selfLog("[WARN] RpcContext leak detected, traceId=" + this.traceId + ", rpcId=" + this.rpcId);
            parent = new RpcContext_inner(this.traceId, "9", null);
        } else {
            parent = this;
        }
        RpcContext_inner ctx = new RpcContext_inner(this.traceId, this.nextChildRpcId(), parent, this.localIdx);
        ctx.isTopRpc = this.isTopRpc;
        ctx.attributes = this.attributes;
        ctx.traceGroup = this.traceGroup;
        ctx.localId = this.getInnerLocalId();
        ctx.localContext = this.localContext;
        return ctx;
    }

    public RpcContext_inner getParentRpcContext() {
        return this.parentRpc;
    }

    public void startTrace(String traceName) {
        this.logType = 1;
        this.startTime = System.currentTimeMillis();
        this.traceName = traceName;
    }

    public void endTrace(String result, int type) {
        if (this.logType != 1) {
            EagleEye.selfLog("[WARN] context mismatch at endTrace(), logType=" + this.logType);
            this.logType = -255;
            return;
        }
        this.logTime = System.currentTimeMillis();
        this.serviceName = result;
        this.rpcType = type;
    }

    public void rpcClientSend() {
        if (this.logType != 2) {
            return;
        }
        this.span0 = (int)(System.currentTimeMillis() - this.startTime);
    }

    public void rpcServerRecv(String serviceName, String methodName) {
        this.logType = 3;
        this.startTime = System.currentTimeMillis();
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.putUserData(EAGLEEYE_TRACE_SIGNATURE_KEY, RpcContext_inner.updateSignature(this.getUserData(EAGLEEYE_TRACE_SIGNATURE_KEY), serviceName, methodName));
    }

    public void rpcServerSend(int type) {
        this.rpcServerSend(type, null, null);
    }

    public void rpcServerSend(int type, String result, String appendMsg) {
        if (this.logType != 3) {
            EagleEye.selfLog("[WARN] context mismatch at rpcServerSend(), logType=" + this.logType);
            this.logType = -255;
            return;
        }
        this.logTime = System.currentTimeMillis();
        this.traceName = result;
        if (appendMsg != null) {
            this.callBackMsg = appendMsg;
        }
        this.rpcType = type;
    }

    public void rpcLog(int type, String msg, boolean appendRpcId) {
        this.logType = 4;
        this.logTime = System.currentTimeMillis();
        this.rpcType = type;
        this.callBackMsg = msg;
    }

    public void index(int type, String index, String msg) {
        this.logType = 5;
        this.logTime = System.currentTimeMillis();
        this.rpcType = type;
        this.traceName = index;
        this.callBackMsg = msg;
    }

    static String updateSignature(String oldSig, String serviceName, String methodName) {
        int sig = 0;
        if (oldSig != null) {
            try {
                sig = (int)Long.parseLong(oldSig, 16);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int a = serviceName != null ? serviceName.hashCode() : "null".hashCode();
        int b = methodName != null ? methodName.hashCode() : "null".hashCode();
        return Integer.toHexString((sig * 31 + a) * 31 + b);
    }

    static void set(RpcContext_inner ctx) {
        threadLocal.set(ctx);
    }

    static RpcContext_inner get() {
        return threadLocal.get();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("traceId", this.traceId);
        map.put("rpcId", this.rpcId);
        map.put("eagleEyeUserData", this.exportUserData());
        return map;
    }

    static RpcContext_inner fromMap(Map<String, String> map) {
        String traceId = map.get("traceId");
        String rpcId = map.get("rpcId");
        String userData = map.get("eagleEyeUserData");
        if (null == traceId || null == rpcId) {
            return null;
        }
        RpcContext_inner ctx = new RpcContext_inner(traceId, rpcId);
        ctx.importUserData(userData);
        return ctx;
    }
}

