/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.dml;

import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.dts.shade.org.h2.result.LocalResult;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.RowList;
import com.alibaba.dts.shade.org.h2.table.PlanItem;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.util.ThreadBuffer;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueNull;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;
    private Expression limitExpr;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Value v;
        this.tableFilter.startQuery(this.session);
        this.tableFilter.reset();
        Table table = this.tableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        ResultInterface[] affectRows = (ResultInterface[])ThreadBuffer.remove("affectRows");
        LocalResult oldRows = null;
        if (affectRows != null && affectRows.length > 0) {
            int columnCount = table.getColumns().length;
            Expression[] expressions = new Expression[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                expressions[i] = new ExpressionColumn(table.getDatabase(), table.getColumns()[i]);
            }
            oldRows = new LocalResult(this.session, expressions, columnCount);
            affectRows[0] = oldRows;
        }
        table.fire(this.session, 4, true);
        table.lock(this.session, true, false);
        RowList rows = new RowList(this.session);
        int limitRows = -1;
        if (this.limitExpr != null && (v = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            limitRows = v.getInt();
        }
        try {
            this.setCurrentRowNumber(0);
            int count = 0;
            while (limitRows != 0 && this.tableFilter.next()) {
                this.setCurrentRowNumber(rows.size() + 1);
                if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
                Row row = this.tableFilter.get();
                boolean done = false;
                if (table.fireRow()) {
                    done = table.fireBeforeRow(this.session, row, null);
                }
                if (!done) {
                    rows.add(row);
                    if (oldRows != null) {
                        oldRows.addRow(row.getValueList());
                    }
                }
                if (limitRows < 0 || ++count < limitRows) continue;
                break;
            }
            int rowScanCount = 0;
            rows.reset();
            while (rows.hasNext()) {
                if ((++rowScanCount & 0x7F) == 0) {
                    this.checkCanceled();
                }
                Row row = rows.next();
                table.removeRow(this.session, row);
                this.session.log(table, (short)1, row);
            }
            if (table.fireRow()) {
                rows.reset();
                while (rows.hasNext()) {
                    Row row = rows.next();
                    table.fireAfterRow(this.session, row, null, false);
                }
            }
            table.fire(this.session, 4, false);
            if (affectRows != null && affectRows.length > 0) {
                ThreadBuffer.put("affectRows", affectRows);
            }
            int n = count;
            return n;
        }
        finally {
            rows.close();
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder buff = new StringBuilder();
        buff.append("DELETE ");
        buff.append("FROM ").append(this.tableFilter.getPlanSQL(false));
        if (this.condition != null) {
            buff.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.limitExpr != null) {
            buff.append("\nLIMIT (").append(StringUtils.unEnclose(this.limitExpr.getSQL())).append(')');
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.tableFilter);
        }
        PlanItem item = this.tableFilter.getBestPlanItem(this.session, 1);
        this.tableFilter.setPlanItem(item);
        this.tableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 58;
    }

    public void setLimit(Expression limit) {
        this.limitExpr = limit;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

