/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.dml;

import com.alibaba.dts.shade.org.h2.command.Command;
import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.command.dml.Query;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Comparison;
import com.alibaba.dts.shade.org.h2.expression.Condition;
import com.alibaba.dts.shade.org.h2.expression.ConditionAndOr;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.dts.shade.org.h2.expression.Parameter;
import com.alibaba.dts.shade.org.h2.index.Index;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.LocalResult;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import com.alibaba.dts.shade.org.h2.result.ResultTarget;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.util.ThreadBuffer;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.HashMap;

public class Insert
extends Prepared
implements ResultTarget {
    private Table table;
    private Column[] columns;
    private final ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private boolean sortedInsertMode;
    private int rowNumber;
    private boolean insertFromSelect;
    private boolean ignore;
    private HashMap<Column, Expression> duplicateKeyAssignmentMap;

    public Insert(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addAssignmentForDuplicate(Column column, Expression expression) {
        if (this.duplicateKeyAssignmentMap == null) {
            this.duplicateKeyAssignmentMap = New.hashMap();
        }
        if (this.duplicateKeyAssignmentMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.duplicateKeyAssignmentMap.put(column, expression);
    }

    public void setIgnore() {
        this.ignore = true;
    }

    public void addRow(Expression[] expr) {
        this.list.add(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Index index = null;
        if (this.sortedInsertMode) {
            index = this.table.getScanIndex(this.session);
            index.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (index != null) {
                index.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() {
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0;
        int listSize = this.list.size();
        if (listSize > 0) {
            int columnLen = this.columns.length;
            int columnCount = this.table.getColumns().length;
            ResultInterface[] affectRows = (ResultInterface[])ThreadBuffer.remove("affectRows");
            LocalResult newRows = null;
            if (affectRows != null && affectRows.length > 0) {
                Expression[] expressions = new Expression[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    expressions[i] = new ExpressionColumn(this.table.getDatabase(), this.table.getColumns()[i]);
                }
                newRows = new LocalResult(this.session, expressions, columnCount);
                affectRows[0] = newRows;
            }
            for (int x = 0; x < listSize; ++x) {
                this.session.startStatementWithinTransaction();
                Row newRow = this.table.getTemplateRow();
                Expression[] expr = this.list.get(x);
                this.setCurrentRowNumber(x + 1);
                for (int i = 0; i < columnLen; ++i) {
                    Column c = this.columns[i];
                    int index = c.getColumnId();
                    Expression e = expr[i];
                    if (e == null) continue;
                    e = e.optimize(this.session);
                    try {
                        Value v = c.convert(e.getValue(this.session));
                        newRow.setValue(index, v);
                        continue;
                    }
                    catch (DbException ex) {
                        throw this.setRow(ex, x, Insert.getSQL(expr));
                    }
                }
                ++this.rowNumber;
                this.table.validateConvertUpdateSequence(this.session, newRow);
                boolean done = this.table.fireBeforeRow(this.session, null, newRow);
                if (done) continue;
                this.table.lock(this.session, true, false);
                try {
                    this.table.addRow(this.session, newRow);
                    if (newRows != null) {
                        newRows.addRow(newRow.getValueList());
                    }
                }
                catch (DbException de) {
                    --this.rowNumber;
                    this.handleOnDuplicate(de);
                }
                this.session.log(this.table, (short)0, newRow);
                this.table.fireAfterRow(this.session, null, newRow, false);
            }
            if (affectRows != null && affectRows.length > 0) {
                ThreadBuffer.put("affectRows", affectRows);
            }
        } else {
            this.table.lock(this.session, true, false);
            if (this.insertFromSelect) {
                this.query.query(0, this);
            } else {
                LocalResult rows = this.query.query(0);
                while (rows.next()) {
                    Value[] r = rows.currentRow();
                    this.addRow(r);
                }
                rows.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value[] values) {
        ResultInterface[] affectRows = (ResultInterface[])ThreadBuffer.remove("affectRows");
        Row newRow = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        int len = this.columns.length;
        for (int j = 0; j < len; ++j) {
            Column c = this.columns[j];
            int index = c.getColumnId();
            try {
                Value v = c.convert(values[j]);
                newRow.setValue(index, v);
                continue;
            }
            catch (DbException ex) {
                throw this.setRow(ex, this.rowNumber, Insert.getSQL(values));
            }
        }
        this.table.validateConvertUpdateSequence(this.session, newRow);
        boolean done = this.table.fireBeforeRow(this.session, null, newRow);
        if (!done) {
            this.table.addRow(this.session, newRow);
            if (affectRows != null && affectRows.length > 0) {
                LocalResult newRows = (LocalResult)affectRows[0];
                if (newRows == null) {
                    int columnCount = this.table.getColumns().length;
                    Expression[] expressions = new Expression[columnCount];
                    for (int i = 0; i < columnCount; ++i) {
                        expressions[i] = new ExpressionColumn(this.table.getDatabase(), this.table.getColumns()[i]);
                    }
                    newRows = new LocalResult(this.session, expressions, columnCount);
                    affectRows[0] = newRows;
                }
                newRows.addRow(newRow.getValueList());
            }
            this.session.log(this.table, (short)0, newRow);
            this.table.fireAfterRow(this.session, null, newRow, false);
        }
        if (affectRows != null && affectRows.length > 0) {
            ThreadBuffer.put("affectRows", affectRows);
        }
    }

    @Override
    public int getRowCount() {
        return this.rowNumber;
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder buff = new StatementBuilder("INSERT INTO ");
        buff.append(this.table.getSQL()).append('(');
        for (Column c : this.columns) {
            buff.appendExceptFirst(", ");
            buff.append(c.getSQL());
        }
        buff.append(")\n");
        if (this.insertFromSelect) {
            buff.append("DIRECT ");
        }
        if (this.sortedInsertMode) {
            buff.append("SORTED ");
        }
        if (this.list.size() > 0) {
            buff.append("VALUES ");
            int row = 0;
            if (this.list.size() > 1) {
                buff.append('\n');
            }
            for (Expression[] expr : this.list) {
                if (row++ > 0) {
                    buff.append(",\n");
                }
                buff.append('(');
                buff.resetCount();
                for (Expression e : expr) {
                    buff.appendExceptFirst(", ");
                    if (e == null) {
                        buff.append("DEFAULT");
                        continue;
                    }
                    buff.append(e.getSQL());
                }
                buff.append(')');
            }
        } else {
            buff.append(this.query.getPlanSQL());
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (Expression[] expr : this.list) {
                if (expr.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int len = expr.length;
                for (int i = 0; i < len; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    if ((e = e.optimize(this.session)) instanceof Parameter) {
                        Parameter p = (Parameter)e;
                        p.setColumn(this.columns[i]);
                    }
                    expr[i] = e;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean sortedInsertMode) {
        this.sortedInsertMode = sortedInsertMode;
    }

    @Override
    public int getType() {
        return 61;
    }

    public void setInsertFromSelect(boolean value) {
        this.insertFromSelect = value;
    }

    @Override
    public boolean isCacheable() {
        return this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty();
    }

    private void handleOnDuplicate(DbException de) {
        if (de.getErrorCode() != 23505) {
            throw de;
        }
        if (this.ignore) {
            return;
        }
        if (this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty()) {
            throw de;
        }
        ArrayList<String> variableNames = new ArrayList<String>(this.duplicateKeyAssignmentMap.size());
        for (int i = 0; i < this.columns.length; ++i) {
            String key = this.table.getSchema().getName() + "." + this.table.getName() + "." + this.columns[i].getName();
            variableNames.add(key);
            this.session.setVariable(key, this.list.get(this.getCurrentRowNumber() - 1)[i].getValue(this.session));
        }
        StatementBuilder buff = new StatementBuilder("UPDATE ");
        buff.append(this.table.getSQL()).append(" SET ");
        for (Column column : this.duplicateKeyAssignmentMap.keySet()) {
            buff.appendExceptFirst(", ");
            Expression ex = this.duplicateKeyAssignmentMap.get(column);
            buff.append(column.getSQL()).append("=").append(ex.getSQL());
        }
        buff.append(" WHERE ");
        Index foundIndex = this.searchForUpdateIndex();
        if (foundIndex == null) {
            throw DbException.getUnsupportedException("Unable to apply ON DUPLICATE KEY UPDATE, no index found!");
        }
        buff.append(this.prepareUpdateCondition(foundIndex).getSQL());
        String sql = buff.toString();
        Prepared command = this.session.prepare(sql);
        for (Parameter param : command.getParameters()) {
            Parameter insertParam = (Parameter)this.parameters.get(param.getIndex());
            param.setValue(insertParam.getValue(this.session));
        }
        command.update();
        for (String variableName : variableNames) {
            this.session.setVariable(variableName, ValueNull.INSTANCE);
        }
    }

    private Index searchForUpdateIndex() {
        Index foundIndex = null;
        for (Index index : this.table.getIndexes()) {
            if (!index.getIndexType().isPrimaryKey() && !index.getIndexType().isUnique()) continue;
            for (Column indexColumn : index.getColumns()) {
                for (Column insertColumn : this.columns) {
                    if (indexColumn.getName().equals(insertColumn.getName())) {
                        foundIndex = index;
                        break;
                    }
                    foundIndex = null;
                }
                if (foundIndex == null) break;
            }
            if (foundIndex == null) continue;
            break;
        }
        return foundIndex;
    }

    private Expression prepareUpdateCondition(Index foundIndex) {
        Condition condition = null;
        for (Column column : foundIndex.getColumns()) {
            ExpressionColumn expr = new ExpressionColumn(this.session.getDatabase(), this.table.getSchema().getName(), this.table.getName(), column.getName());
            for (int i = 0; i < this.columns.length; ++i) {
                if (!expr.getColumnName().equals(this.columns[i].getName())) continue;
                condition = condition == null ? new Comparison(this.session, 0, expr, this.list.get(this.getCurrentRowNumber() - 1)[i++]) : new ConditionAndOr(0, condition, new Comparison(this.session, 0, expr, this.list.get(0)[i++]));
            }
        }
        return condition;
    }
}

