/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore.db;

import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.BaseIndex;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVIndex;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVPrimaryIndex;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTable;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.value.ValueLong;
import java.util.List;

public class MVDelegateIndex
extends BaseIndex
implements MVIndex {
    private final MVPrimaryIndex mainIndex;

    public MVDelegateIndex(MVTable table, int id, String name, MVPrimaryIndex mainIndex, IndexType indexType) {
        IndexColumn[] cols = IndexColumn.wrap(new Column[]{table.getColumn(mainIndex.getMainIndexColumn())});
        this.initBaseIndex(table, id, name, cols, indexType);
        this.mainIndex = mainIndex;
        if (id < 0) {
            throw DbException.throwInternalError("" + name);
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        throw DbException.throwInternalError();
    }

    @Override
    public void addBufferedRows(List<String> bufferNames) {
        throw DbException.throwInternalError();
    }

    @Override
    public void add(Session session, Row row) {
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        ValueLong min = this.mainIndex.getKey(first, MVPrimaryIndex.MIN, MVPrimaryIndex.MIN);
        ValueLong max = this.mainIndex.getKey(last, MVPrimaryIndex.MAX, MVPrimaryIndex.MIN);
        return this.mainIndex.find(session, min, max);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        return this.mainIndex.findFirstOrLast(session, first);
    }

    @Override
    public int getColumnIndex(Column col) {
        if (col.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return 10L * this.getCostRangeIndex(masks, this.mainIndex.getRowCountApproximation(), filter, sortOrder);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) {
    }

    @Override
    public void remove(Session session) {
        this.mainIndex.setMainIndexColumn(-1);
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.mainIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

