/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore.db;

import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.BaseIndex;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.index.SpatialIndex;
import com.alibaba.dts.shade.org.h2.index.SpatialTreeIndex;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVIndex;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTable;
import com.alibaba.dts.shade.org.h2.mvstore.db.TransactionStore;
import com.alibaba.dts.shade.org.h2.mvstore.db.ValueDataType;
import com.alibaba.dts.shade.org.h2.mvstore.rtree.MVRTreeMap;
import com.alibaba.dts.shade.org.h2.mvstore.rtree.SpatialKey;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueGeometry;
import com.alibaba.dts.shade.org.h2.value.ValueLong;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import java.util.List;

public class MVSpatialIndex
extends BaseIndex
implements SpatialIndex,
MVIndex {
    final MVTable mvTable;
    private final String mapName;
    private TransactionStore.TransactionMap<SpatialKey, Value> dataMap;
    private MVRTreeMap<TransactionStore.VersionedValue> spatialMap;

    public MVSpatialIndex(Database db, MVTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        if (columns.length != 1) {
            throw DbException.getUnsupportedException("Can only index one column");
        }
        IndexColumn col = columns[0];
        if ((col.sortType & 1) != 0) {
            throw DbException.getUnsupportedException("Cannot index in descending order");
        }
        if ((col.sortType & 2) != 0) {
            throw DbException.getUnsupportedException("Nulls first is not supported");
        }
        if ((col.sortType & 4) != 0) {
            throw DbException.getUnsupportedException("Nulls last is not supported");
        }
        if (col.column.getType() != 22) {
            throw DbException.getUnsupportedException("Spatial index on non-geometry column, " + col.column.getCreateSQL());
        }
        this.mvTable = table;
        this.initBaseIndex(table, id, indexName, columns, indexType);
        if (!this.database.isStarting()) {
            MVSpatialIndex.checkIndexColumnTypes(columns);
        }
        this.mapName = "index." + this.getId();
        ValueDataType vt = new ValueDataType(null, null, null);
        TransactionStore.VersionedValueType valueType = new TransactionStore.VersionedValueType(vt);
        MVRTreeMap.Builder mapBuilder = new MVRTreeMap.Builder().valueType(valueType);
        this.spatialMap = (MVRTreeMap)db.getMvStore().getStore().openMap(this.mapName, mapBuilder);
        TransactionStore.Transaction t = this.mvTable.getTransaction(null);
        this.dataMap = t.openMap(this.spatialMap);
        t.commit();
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        throw DbException.throwInternalError();
    }

    @Override
    public void addBufferedRows(List<String> bufferNames) {
        throw DbException.throwInternalError();
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        SpatialKey k;
        Iterator<SpatialKey> it;
        MVRTreeMap.RTreeCursor cursor;
        TransactionStore.TransactionMap<SpatialKey, Value> map = this.getMap(session);
        SpatialKey key = this.getKey(row);
        if (this.indexType.isUnique()) {
            cursor = this.spatialMap.findContainedKeys(key);
            it = map.wrapIterator(cursor, false);
            while (it.hasNext()) {
                k = it.next();
                if (!k.equalsIgnoringId(key)) continue;
                throw this.getDuplicateKeyException(key.toString());
            }
        }
        try {
            map.put(key, ValueLong.get(0L));
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
        if (this.indexType.isUnique()) {
            cursor = this.spatialMap.findContainedKeys(key);
            it = map.wrapIterator(cursor, true);
            while (it.hasNext()) {
                k = it.next();
                if (!k.equalsIgnoringId(key) || map.isSameTransaction(k)) continue;
                map.remove(key);
                if (map.get(k) != null) {
                    throw this.getDuplicateKeyException(k.toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    @Override
    public void remove(Session session, Row row) {
        SpatialKey key = this.getKey(row);
        TransactionStore.TransactionMap<SpatialKey, Value> map = this.getMap(session);
        try {
            Value old = map.remove(key);
            if (old == null) {
                old = map.remove(key);
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(filter.getSession());
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session);
    }

    private Cursor find(Session session) {
        Iterator<Object> cursor = this.spatialMap.keyIterator(null);
        TransactionStore.TransactionMap<SpatialKey, Value> map = this.getMap(session);
        Iterator<Object> it = map.wrapIterator(cursor, false);
        return new MVStoreCursor(session, it);
    }

    @Override
    public Cursor findByGeometry(TableFilter filter, SearchRow intersection) {
        Session session = filter.getSession();
        if (intersection == null) {
            return this.find(session);
        }
        MVRTreeMap.RTreeCursor cursor = this.spatialMap.findIntersectingKeys(this.getKey(intersection));
        TransactionStore.TransactionMap<SpatialKey, Value> map = this.getMap(session);
        Iterator<SpatialKey> it = map.wrapIterator(cursor, false);
        return new MVStoreCursor(session, it);
    }

    private SpatialKey getKey(SearchRow row) {
        Value v = row.getValue(this.columnIds[0]);
        if (v == ValueNull.INSTANCE) {
            return new SpatialKey(row.getKey(), new float[0]);
        }
        Geometry g = ((ValueGeometry)v.convertTo(22)).getGeometryNoCopy();
        Envelope env = g.getEnvelopeInternal();
        return new SpatialKey(row.getKey(), (float)env.getMinX(), (float)env.getMaxX(), (float)env.getMinY(), (float)env.getMaxY());
    }

    SearchRow getRow(SpatialKey key) {
        Row searchRow = this.mvTable.getTemplateRow();
        searchRow.setKey(key.getId());
        return searchRow;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return this.getCostRangeIndex(masks, this.table.getRowCountApproximation(), filter, sortOrder);
    }

    @Override
    protected long getCostRangeIndex(int[] masks, long rowCount, TableFilter filter, SortOrder sortOrder) {
        return SpatialTreeIndex.getCostRangeIndex(masks, rowCount, this.columns);
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<SpatialKey, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            TransactionStore.Transaction t = this.mvTable.getTransaction(session);
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<SpatialKey, Value> map = this.getMap(session);
        map.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        if (!first) {
            throw DbException.throwInternalError("Spatial Index can only be fetch in ascending order");
        }
        return this.find(session);
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<SpatialKey, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
    }

    TransactionStore.TransactionMap<SpatialKey, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction t = this.mvTable.getTransaction(session);
        return this.dataMap.getInstance(t, Long.MAX_VALUE);
    }

    class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<SpatialKey> it;
        private SpatialKey current;
        private SearchRow searchRow;
        private Row row;

        public MVStoreCursor(Session session, Iterator<SpatialKey> it) {
            this.session = session;
            this.it = it;
        }

        @Override
        public Row get() {
            SearchRow r;
            if (this.row == null && (r = this.getSearchRow()) != null) {
                this.row = MVSpatialIndex.this.mvTable.getRow(this.session, r.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = MVSpatialIndex.this.getRow(this.current);
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.next();
            this.searchRow = null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

