/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store;

import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.message.Trace;
import com.alibaba.dts.shade.org.h2.store.PageStore;
import com.alibaba.dts.shade.org.h2.store.PageStreamData;
import com.alibaba.dts.shade.org.h2.store.PageStreamTrunk;
import com.alibaba.dts.shade.org.h2.util.BitField;
import com.alibaba.dts.shade.org.h2.util.IntArray;

public class PageOutputStream {
    private PageStore store;
    private final Trace trace;
    private final BitField exclude;
    private final boolean atEnd;
    private final int minPageId;
    private int trunkPageId;
    private int trunkNext;
    private IntArray reservedPages = new IntArray();
    private PageStreamTrunk trunk;
    private int trunkIndex;
    private PageStreamData data;
    private int reserved;
    private boolean needFlush;
    private boolean writing;
    private int pageCount;
    private int logKey;

    public PageOutputStream(PageStore store, int trunkPage, BitField exclude, int logKey, boolean atEnd) {
        this.trace = store.getTrace();
        this.store = store;
        this.trunkPageId = trunkPage;
        this.exclude = exclude;
        this.logKey = logKey - 1;
        this.atEnd = atEnd;
        this.minPageId = atEnd ? trunkPage : 0;
    }

    void reserve(int minBuffer) {
        if (this.reserved < minBuffer) {
            int pageSize = this.store.getPageSize();
            int capacityPerPage = PageStreamData.getCapacity(pageSize);
            int pages = PageStreamTrunk.getPagesAddressed(pageSize);
            int pagesToAllocate = 0;
            int totalCapacity = 0;
            do {
                pagesToAllocate += pages + 1;
            } while ((totalCapacity += pages * capacityPerPage) < minBuffer);
            int firstPageToUse = this.atEnd ? this.trunkPageId : 0;
            this.store.allocatePages(this.reservedPages, pagesToAllocate, this.exclude, firstPageToUse);
            this.reserved += totalCapacity;
            if (this.data == null) {
                this.initNextData();
            }
        }
    }

    private void initNextData() {
        int nextData;
        int n = nextData = this.trunk == null ? -1 : this.trunk.getPageData(this.trunkIndex++);
        if (nextData == -1) {
            int parent = this.trunkPageId;
            if (this.trunkNext != 0) {
                this.trunkPageId = this.trunkNext;
            }
            int len = PageStreamTrunk.getPagesAddressed(this.store.getPageSize());
            int[] pageIds = new int[len];
            for (int i = 0; i < len; ++i) {
                pageIds[i] = this.reservedPages.get(i);
            }
            this.trunkNext = this.reservedPages.get(len);
            ++this.logKey;
            this.trunk = PageStreamTrunk.create(this.store, parent, this.trunkPageId, this.trunkNext, this.logKey, pageIds);
            this.trunkIndex = 0;
            ++this.pageCount;
            this.trunk.write();
            this.reservedPages.removeRange(0, len + 1);
            nextData = this.trunk.getPageData(this.trunkIndex++);
        }
        this.data = PageStreamData.create(this.store, nextData, this.trunk.getPos(), this.logKey);
        ++this.pageCount;
        this.data.initWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) {
        if (len <= 0) {
            return;
        }
        if (this.writing) {
            DbException.throwInternalError("writing while still writing");
        }
        try {
            this.reserve(len);
            this.writing = true;
            while (len > 0) {
                int l = this.data.write(b, off, len);
                if (l < len) {
                    this.storePage();
                    this.initNextData();
                }
                this.reserved -= l;
                off += l;
                len -= l;
            }
            this.needFlush = true;
        }
        finally {
            this.writing = false;
        }
    }

    private void storePage() {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageOut.storePage " + this.data);
        }
        this.data.write();
    }

    public void flush() {
        if (this.needFlush) {
            this.storePage();
            this.needFlush = false;
        }
    }

    public void close() {
        this.store = null;
    }

    int getCurrentDataPageId() {
        return this.data.getPos();
    }

    void fillPage() {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageOut.storePage fill " + this.data.getPos());
        }
        this.reserve(this.data.getRemaining() + 1);
        this.reserved -= this.data.getRemaining();
        this.data.write();
        this.initNextData();
    }

    long getSize() {
        return this.pageCount * this.store.getPageSize();
    }

    void free(PageStreamTrunk t) {
        this.pageCount -= t.free(0);
    }

    void freeReserved() {
        if (this.reservedPages.size() > 0) {
            int[] array = new int[this.reservedPages.size()];
            this.reservedPages.toArray(array);
            this.reservedPages = new IntArray();
            this.reserved = 0;
            for (int p : array) {
                this.store.free(p, false);
            }
        }
    }

    int getMinPageId() {
        return this.minPageId;
    }
}

