/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store.fs;

import com.alibaba.dts.shade.org.h2.store.fs.FileBase;
import com.alibaba.dts.shade.org.h2.store.fs.FileUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class FileRetryOnInterrupt
extends FileBase {
    private final String fileName;
    private final String mode;
    private FileChannel channel;
    private FileLockRetry lock;

    FileRetryOnInterrupt(String fileName, String mode) throws IOException {
        this.fileName = fileName;
        this.mode = mode;
        this.open();
    }

    private void open() throws IOException {
        this.channel = FileUtils.open(this.fileName, this.mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reopen(int i, IOException e) throws IOException {
        if (i > 20) {
            throw e;
        }
        if (!(e instanceof ClosedByInterruptException) && !(e instanceof ClosedChannelException)) {
            throw e;
        }
        Thread.interrupted();
        FileChannel before = this.channel;
        FileRetryOnInterrupt fileRetryOnInterrupt = this;
        synchronized (fileRetryOnInterrupt) {
            if (before == this.channel) {
                this.open();
                this.reLock();
            }
        }
    }

    private void reLock() throws IOException {
        if (this.lock == null) {
            return;
        }
        try {
            this.lock.base.release();
        }
        catch (IOException e) {
            // empty catch block
        }
        FileLock l2 = this.channel.tryLock(this.lock.position(), this.lock.size(), this.lock.isShared());
        if (l2 == null) {
            throw new IOException("Re-locking failed");
        }
        this.lock.base = l2;
    }

    @Override
    public void implCloseChannel() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public long position() throws IOException {
        int i = 0;
        while (true) {
            try {
                return this.channel.position();
            }
            catch (IOException e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public long size() throws IOException {
        int i = 0;
        while (true) {
            try {
                return this.channel.size();
            }
            catch (IOException e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        long pos = this.position();
        int i = 0;
        while (true) {
            try {
                return this.channel.read(dst);
            }
            catch (IOException e) {
                this.reopen(i, e);
                this.position(pos);
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        int i = 0;
        while (true) {
            try {
                return this.channel.read(dst, position);
            }
            catch (IOException e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public FileChannel position(long pos) throws IOException {
        int i = 0;
        while (true) {
            try {
                this.channel.position(pos);
                return this;
            }
            catch (IOException e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public FileChannel truncate(long newLength) throws IOException {
        int i = 0;
        while (true) {
            try {
                this.channel.truncate(newLength);
                return this;
            }
            catch (IOException e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public void force(boolean metaData) throws IOException {
        int i = 0;
        while (true) {
            try {
                this.channel.force(metaData);
            }
            catch (IOException e) {
                this.reopen(i, e);
            }
            ++i;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        long pos = this.position();
        int i = 0;
        while (true) {
            try {
                return this.channel.write(src);
            }
            catch (IOException e) {
                this.reopen(i, e);
                this.position(pos);
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        int i = 0;
        while (true) {
            try {
                return this.channel.write(src, position);
            }
            catch (IOException e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        FileLock l = this.channel.tryLock(position, size, shared);
        if (l == null) {
            return null;
        }
        this.lock = new FileLockRetry(l, this);
        return this.lock;
    }

    public String toString() {
        return "retry:" + this.fileName;
    }

    static class FileLockRetry
    extends FileLock {
        FileLock base;

        protected FileLockRetry(FileLock base, FileChannel channel) {
            super(channel, base.position(), base.size(), base.isShared());
            this.base = base;
        }

        @Override
        public boolean isValid() {
            return this.base.isValid();
        }

        @Override
        public void release() throws IOException {
            this.base.release();
        }
    }
}

