/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.table;

import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.Index;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.index.LinkedIndex;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.RowList;
import com.alibaba.dts.shade.org.h2.schema.Schema;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.table.TableLinkConnection;
import com.alibaba.dts.shade.org.h2.util.JdbcUtils;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.value.DataType;
import com.alibaba.dts.shade.org.h2.value.Value;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableLink
extends Table {
    private static final int MAX_RETRY = 2;
    private static final long ROW_COUNT_APPROXIMATION = 100000L;
    private final String originalSchema;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private String qualifiedTableName;
    private TableLinkConnection conn;
    private HashMap<String, PreparedStatement> preparedMap = New.hashMap();
    private final ArrayList<Index> indexes = New.arrayList();
    private final boolean emitUpdates;
    private LinkedIndex linkedIndex;
    private DbException connectException;
    private boolean storesLowerCase;
    private boolean storesMixedCase;
    private boolean storesMixedCaseQuoted;
    private boolean supportsMixedCaseIdentifiers;
    private boolean globalTemporary;
    private boolean readOnly;

    public TableLink(Schema schema, int id, String name, String driver, String url, String user, String password, String originalSchema, String originalTable, boolean emitUpdates, boolean force) {
        super(schema, id, name, false, true);
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.originalSchema = originalSchema;
        this.originalTable = originalTable;
        this.emitUpdates = emitUpdates;
        try {
            this.connect();
        }
        catch (DbException e) {
            if (!force) {
                throw e;
            }
            Column[] cols = new Column[]{};
            this.setColumns(cols);
            this.linkedIndex = new LinkedIndex(this, id, IndexColumn.wrap(cols), IndexType.createNonUnique(false));
            this.indexes.add(this.linkedIndex);
        }
    }

    private void connect() {
        this.connectException = null;
        int retry = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn = this.database.getLinkConnection(this.driver, this.url, this.user, this.password);
                synchronized (tableLinkConnection) {
                    try {
                        this.readMetaData();
                        return;
                    }
                    catch (Exception e) {
                        this.conn.close(true);
                        this.conn = null;
                        throw DbException.convert(e);
                    }
                }
            }
            catch (DbException e) {
                if (retry >= 2) {
                    this.connectException = e;
                    throw e;
                }
                ++retry;
                continue;
            }
            break;
        }
    }

    private void readMetaData() throws SQLException {
        ArrayList<Column> list;
        int sqlType;
        String n;
        DatabaseMetaData meta = this.conn.getConnection().getMetaData();
        this.storesLowerCase = meta.storesLowerCaseIdentifiers();
        this.storesMixedCase = meta.storesMixedCaseIdentifiers();
        this.storesMixedCaseQuoted = meta.storesMixedCaseQuotedIdentifiers();
        this.supportsMixedCaseIdentifiers = meta.supportsMixedCaseIdentifiers();
        ResultSet rs = meta.getTables(null, this.originalSchema, this.originalTable, null);
        if (rs.next() && rs.next()) {
            throw DbException.get(90080, this.originalTable);
        }
        rs.close();
        rs = meta.getColumns(null, this.originalSchema, this.originalTable, null);
        int i = 0;
        ArrayList<Column> columnList = New.arrayList();
        HashMap<String, Column> columnMap = New.hashMap();
        String catalog = null;
        String schema = null;
        while (rs.next()) {
            String thisCatalog = rs.getString("TABLE_CAT");
            if (catalog == null) {
                catalog = thisCatalog;
            }
            String thisSchema = rs.getString("TABLE_SCHEM");
            if (schema == null) {
                schema = thisSchema;
            }
            if (!StringUtils.equals(catalog, thisCatalog) || !StringUtils.equals(schema, thisSchema)) {
                columnMap.clear();
                columnList.clear();
                break;
            }
            n = rs.getString("COLUMN_NAME");
            n = this.convertColumnName(n);
            sqlType = rs.getInt("DATA_TYPE");
            String sqlTypeName = rs.getString("TYPE_NAME");
            long precision = rs.getInt("COLUMN_SIZE");
            precision = TableLink.convertPrecision(sqlType, precision);
            int scale = rs.getInt("DECIMAL_DIGITS");
            scale = TableLink.convertScale(sqlType, scale);
            int displaySize = MathUtils.convertLongToInt(precision);
            int type = DataType.convertSQLTypeToValueType(sqlType, sqlTypeName);
            Column col = new Column(n, type, precision, scale, displaySize);
            col.setTable(this, i++);
            columnList.add(col);
            columnMap.put(n, col);
        }
        rs.close();
        this.qualifiedTableName = this.originalTable.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(schema) ? schema + "." + this.originalTable : this.originalTable;
        Statement stat = null;
        try {
            stat = this.conn.getConnection().createStatement();
            rs = stat.executeQuery("SELECT * FROM " + this.qualifiedTableName + " T WHERE 1=0");
            if (columnList.size() == 0) {
                ResultSetMetaData rsMeta = rs.getMetaData();
                i = 0;
                while (i < rsMeta.getColumnCount()) {
                    n = rsMeta.getColumnName(i + 1);
                    n = this.convertColumnName(n);
                    sqlType = rsMeta.getColumnType(i + 1);
                    long precision = rsMeta.getPrecision(i + 1);
                    precision = TableLink.convertPrecision(sqlType, precision);
                    int scale = rsMeta.getScale(i + 1);
                    scale = TableLink.convertScale(sqlType, scale);
                    int displaySize = rsMeta.getColumnDisplaySize(i + 1);
                    int type = DataType.getValueTypeFromResultSet(rsMeta, i + 1);
                    Column col = new Column(n, type, precision, scale, displaySize);
                    col.setTable(this, i++);
                    columnList.add(col);
                    columnMap.put(n, col);
                }
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                throw DbException.get(42102, e, this.originalTable + "(" + e.toString() + ")");
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(stat);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(stat);
        Column[] cols = new Column[columnList.size()];
        columnList.toArray(cols);
        this.setColumns(cols);
        int id = this.getId();
        this.linkedIndex = new LinkedIndex(this, id, IndexColumn.wrap(cols), IndexType.createNonUnique(false));
        this.indexes.add(this.linkedIndex);
        try {
            rs = meta.getPrimaryKeys(null, this.originalSchema, this.originalTable);
        }
        catch (Exception e) {
            rs = null;
        }
        String pkName = "";
        if (rs != null && rs.next()) {
            list = New.arrayList();
            do {
                int idx = rs.getInt("KEY_SEQ");
                if (pkName == null) {
                    pkName = rs.getString("PK_NAME");
                }
                while (list.size() < idx) {
                    list.add(null);
                }
                String col = rs.getString("COLUMN_NAME");
                col = this.convertColumnName(col);
                Column column = (Column)columnMap.get(col);
                if (idx == 0) {
                    list.add(column);
                    continue;
                }
                list.set(idx - 1, column);
            } while (rs.next());
            this.addIndex(list, IndexType.createPrimaryKey(false, false));
            rs.close();
        }
        try {
            rs = meta.getIndexInfo(null, this.originalSchema, this.originalTable, false, true);
        }
        catch (Exception e) {
            rs = null;
        }
        String indexName = null;
        list = New.arrayList();
        IndexType indexType = null;
        if (rs != null) {
            while (rs.next()) {
                String newIndex;
                if (rs.getShort("TYPE") == 0 || pkName.equals(newIndex = rs.getString("INDEX_NAME"))) continue;
                if (indexName != null && !indexName.equals(newIndex)) {
                    this.addIndex(list, indexType);
                    indexName = null;
                }
                if (indexName == null) {
                    indexName = newIndex;
                    list.clear();
                }
                boolean unique = !rs.getBoolean("NON_UNIQUE");
                indexType = unique ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
                String col = rs.getString("COLUMN_NAME");
                col = this.convertColumnName(col);
                Column column = (Column)columnMap.get(col);
                list.add(column);
            }
            rs.close();
        }
        if (indexName != null) {
            this.addIndex(list, indexType);
        }
    }

    private static long convertPrecision(int sqlType, long precision) {
        switch (sqlType) {
            case 2: 
            case 3: {
                if (precision != 0L) break;
                precision = 65535L;
                break;
            }
            case 91: {
                precision = Math.max(8L, precision);
                break;
            }
            case 93: {
                precision = Math.max(23L, precision);
                break;
            }
            case 92: {
                precision = Math.max(6L, precision);
            }
        }
        return precision;
    }

    private static int convertScale(int sqlType, int scale) {
        switch (sqlType) {
            case 2: 
            case 3: {
                if (scale >= 0) break;
                scale = Short.MAX_VALUE;
            }
        }
        return scale;
    }

    private String convertColumnName(String columnName) {
        if ((this.storesMixedCase || this.storesLowerCase) && columnName.equals(StringUtils.toLowerEnglish(columnName))) {
            columnName = StringUtils.toUpperEnglish(columnName);
        } else if (this.storesMixedCase && !this.supportsMixedCaseIdentifiers) {
            columnName = StringUtils.toUpperEnglish(columnName);
        } else if (this.storesMixedCase && this.storesMixedCaseQuoted) {
            columnName = StringUtils.toUpperEnglish(columnName);
        }
        return columnName;
    }

    private void addIndex(List<Column> list, IndexType indexType) {
        int firstNull = list.indexOf(null);
        if (firstNull == 0) {
            this.trace.info("Omitting linked index - no recognized columns.");
            return;
        }
        if (firstNull > 0) {
            this.trace.info("Unrecognized columns in linked index. Registering the index against the leading {0} recognized columns of {1} total columns.", firstNull, list.size());
            list = list.subList(0, firstNull);
        }
        Column[] cols = new Column[list.size()];
        list.toArray(cols);
        LinkedIndex index = new LinkedIndex(this, 0, IndexColumn.wrap(cols), indexType);
        this.indexes.add(index);
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder buff = new StringBuilder("CREATE FORCE ");
        if (this.isTemporary()) {
            if (this.globalTemporary) {
                buff.append("GLOBAL ");
            } else {
                buff.append("LOCAL ");
            }
            buff.append("TEMPORARY ");
        }
        buff.append("LINKED TABLE ").append(this.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append('(').append(StringUtils.quoteStringSQL(this.driver)).append(", ").append(StringUtils.quoteStringSQL(this.url)).append(", ").append(StringUtils.quoteStringSQL(this.user)).append(", ").append(StringUtils.quoteStringSQL(this.password)).append(", ").append(StringUtils.quoteStringSQL(this.originalTable)).append(')');
        if (this.emitUpdates) {
            buff.append(" EMIT UPDATES");
        }
        if (this.readOnly) {
            buff.append(" READONLY");
        }
        buff.append(" /*--hide--*/");
        return buff.toString();
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.linkedIndex;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.checkReadOnly();
        this.getScanIndex(session).remove(session, row);
    }

    @Override
    public void addRow(Session session, Row row) {
        this.checkReadOnly();
        this.getScanIndex(session).add(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Session session) {
        if (this.conn != null) {
            try {
                this.conn.close(false);
            }
            finally {
                this.conn = null;
            }
        }
    }

    @Override
    public synchronized long getRowCount(Session session) {
        String sql = "SELECT COUNT(*) FROM " + this.qualifiedTableName;
        try {
            PreparedStatement prep = this.execute(sql, null, false);
            ResultSet rs = prep.getResultSet();
            rs.next();
            long count = rs.getLong(1);
            rs.close();
            this.reusePreparedStatement(prep, sql);
            return count;
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    public static DbException wrapException(String sql, Exception ex) {
        SQLException e = DbException.toSQLException(ex);
        return DbException.get(90111, e, sql, e.toString());
    }

    public String getQualifiedTable() {
        return this.qualifiedTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement execute(String sql, ArrayList<Value> params, boolean reusePrepared) {
        if (this.conn == null) {
            throw this.connectException;
        }
        int retry = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn;
                synchronized (tableLinkConnection) {
                    PreparedStatement prep = this.preparedMap.remove(sql);
                    if (prep == null) {
                        prep = this.conn.getConnection().prepareStatement(sql);
                    }
                    if (this.trace.isDebugEnabled()) {
                        StatementBuilder buff = new StatementBuilder();
                        buff.append(this.getName()).append(":\n").append(sql);
                        if (params != null && params.size() > 0) {
                            buff.append(" {");
                            int i = 1;
                            for (Value v : params) {
                                buff.appendExceptFirst(", ");
                                buff.append(i++).append(": ").append(v.getSQL());
                            }
                            buff.append('}');
                        }
                        buff.append(';');
                        this.trace.debug(buff.toString());
                    }
                    if (params != null) {
                        int size = params.size();
                        for (int i = 0; i < size; ++i) {
                            Value v = params.get(i);
                            v.set(prep, i + 1);
                        }
                    }
                    prep.execute();
                    if (reusePrepared) {
                        this.reusePreparedStatement(prep, sql);
                        return null;
                    }
                    return prep;
                }
            }
            catch (SQLException e) {
                if (retry >= 2) {
                    throw DbException.convert(e);
                }
                this.conn.close(true);
                this.connect();
                ++retry;
                continue;
            }
            break;
        }
    }

    @Override
    public void unlock(Session s) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public String getTableType() {
        return "TABLE LINK";
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.database.removeMeta(session, this.getId());
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.preparedMap = null;
        this.invalidate();
    }

    public boolean isOracle() {
        return this.url.startsWith("jdbc:oracle:");
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        for (Index idx : this.indexes) {
            if (!idx.getIndexType().isUnique()) continue;
            return idx;
        }
        return null;
    }

    @Override
    public void updateRows(Prepared prepared, Session session, RowList rows) {
        boolean deleteInsert;
        this.checkReadOnly();
        if (this.emitUpdates) {
            rows.reset();
            while (rows.hasNext()) {
                prepared.checkCanceled();
                Row oldRow = rows.next();
                Row newRow = rows.next();
                this.linkedIndex.update(oldRow, newRow);
                session.log(this, (short)1, oldRow);
                session.log(this, (short)0, newRow);
            }
            deleteInsert = false;
        } else {
            deleteInsert = true;
        }
        if (deleteInsert) {
            super.updateRows(prepared, session, rows);
        }
    }

    public void setGlobalTemporary(boolean globalTemporary) {
        this.globalTemporary = globalTemporary;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public long getRowCountApproximation() {
        return 100000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reusePreparedStatement(PreparedStatement prep, String sql) {
        TableLinkConnection tableLinkConnection = this.conn;
        synchronized (tableLinkConnection) {
            this.preparedMap.put(sql, prep);
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i = 0; i < this.columns.length; ++i) {
            Column column;
            Value v2;
            Value value = row.getValue(i);
            if (value == null || (v2 = (column = this.columns[i]).validateConvertUpdateSequence(session, value)) == value) continue;
            row.setValue(i, v2);
        }
    }

    @Override
    public Value getDefaultValue(Session session, Column column) {
        return null;
    }
}

