/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.util;

import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueDate;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import com.alibaba.dts.shade.org.h2.value.ValueTime;
import com.alibaba.dts.shade.org.h2.value.ValueTimestamp;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeUtils {
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private static final int SHIFT_YEAR = 9;
    private static final int SHIFT_MONTH = 5;
    private static final int[] NORMAL_DAYS_PER_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_OFFSET = new int[]{0, 31, 61, 92, 122, 153, 184, 214, 245, 275, 306, 337, 366};
    public static final int CALENDAR_QUARTER = -1;
    public static final int CALENDAR_MINUTE_SECOND = -2;
    public static final int CALENDAR_HOUR_SECOND = -3;
    public static final int CALENDAR_HOUR_MINUTE = -4;
    public static final int CALENDAR_DAY_SECOND = -5;
    public static final int CALENDAR_DAY_MINUTE = -6;
    public static final int CALENDAR_DAY_HOUR = -7;
    public static final int CALENDAR_YEAR_MONTH = -8;
    private static final ThreadLocal<Calendar> CACHED_CALENDAR = new ThreadLocal();
    private static final ThreadLocal<Calendar> CACHED_CALENDAR_NON_DEFAULT_TIMEZONE = new ThreadLocal();

    private DateTimeUtils() {
    }

    public static void resetCalendar() {
        CACHED_CALENDAR.remove();
    }

    private static Calendar getCalendar() {
        Calendar c = CACHED_CALENDAR.get();
        if (c == null) {
            c = Calendar.getInstance();
            CACHED_CALENDAR.set(c);
        }
        return c;
    }

    private static Calendar getCalendar(TimeZone tz) {
        Calendar c = CACHED_CALENDAR_NON_DEFAULT_TIMEZONE.get();
        if (c == null || !c.getTimeZone().equals(tz)) {
            c = Calendar.getInstance(tz);
            CACHED_CALENDAR_NON_DEFAULT_TIMEZONE.set(c);
        }
        return c;
    }

    public static java.sql.Date convertDate(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueDate d = (ValueDate)value.convertTo(10);
        Calendar cal = (Calendar)calendar.clone();
        cal.clear();
        cal.setLenient(true);
        long dateValue = d.getDateValue();
        DateTimeUtils.setCalendarFields(cal, DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), 0, 0, 0, 0);
        long ms = cal.getTimeInMillis();
        return new java.sql.Date(ms);
    }

    public static Time convertTime(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueTime t = (ValueTime)value.convertTo(9);
        Calendar cal = (Calendar)calendar.clone();
        cal.clear();
        cal.setLenient(true);
        long nanos = t.getNanos();
        long millis = nanos / 1000000L;
        nanos -= millis * 1000000L;
        long s = millis / 1000L;
        millis -= s * 1000L;
        long m = s / 60L;
        s -= m * 60L;
        long h = m / 60L;
        DateTimeUtils.setCalendarFields(cal, 1970, 1, 1, (int)h, (int)(m -= h * 60L), (int)s, (int)millis);
        long ms = cal.getTimeInMillis();
        return new Time(ms);
    }

    public static Timestamp convertTimestamp(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueTimestamp ts = (ValueTimestamp)value.convertTo(11);
        Calendar cal = (Calendar)calendar.clone();
        cal.clear();
        cal.setLenient(true);
        long dateValue = ts.getDateValue();
        long nanos = ts.getTimeNanos();
        long millis = nanos / 1000000L;
        nanos -= millis * 1000000L;
        long s = millis / 1000L;
        millis -= s * 1000L;
        long m = s / 60L;
        s -= m * 60L;
        long h = m / 60L;
        DateTimeUtils.setCalendarFields(cal, DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), (int)h, (int)(m -= h * 60L), (int)s, (int)millis);
        long ms = cal.getTimeInMillis();
        Timestamp x = new Timestamp(ms);
        x.setNanos((int)(nanos + millis * 1000000L));
        return x;
    }

    public static ValueDate convertDate(java.sql.Date x, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar cal = (Calendar)calendar.clone();
        cal.setTimeInMillis(x.getTime());
        long dateValue = DateTimeUtils.dateValueFromCalendar(cal);
        return ValueDate.fromDateValue(dateValue);
    }

    public static ValueTime convertTime(Time x, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar cal = (Calendar)calendar.clone();
        cal.setTimeInMillis(x.getTime());
        long nanos = DateTimeUtils.nanosFromCalendar(cal);
        return ValueTime.fromNanos(nanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToLocal(Date x, Calendar target) {
        Calendar local;
        if (target == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        target = (Calendar)target.clone();
        Calendar calendar = local = Calendar.getInstance();
        synchronized (calendar) {
            local.setTime(x);
            DateTimeUtils.convertTime(local, target);
        }
        return target.getTimeInMillis();
    }

    private static void convertTime(Calendar from, Calendar to) {
        to.set(0, from.get(0));
        to.set(1, from.get(1));
        to.set(2, from.get(2));
        to.set(5, from.get(5));
        to.set(11, from.get(11));
        to.set(12, from.get(12));
        to.set(13, from.get(13));
        to.set(14, from.get(14));
    }

    public static ValueTimestamp convertTimestamp(Timestamp x, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar cal = (Calendar)calendar.clone();
        cal.setTimeInMillis(x.getTime());
        long dateValue = DateTimeUtils.dateValueFromCalendar(cal);
        long nanos = DateTimeUtils.nanosFromCalendar(cal);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos += (long)(x.getNanos() % 1000000));
    }

    public static long parseDateValue(String s, int start, int end) {
        int day;
        int month;
        if (s.charAt(start) == '+') {
            ++start;
        }
        int s1 = s.indexOf(45, start + 1);
        int s2 = s.indexOf(45, s1 + 1);
        if (s1 <= 0 || s2 <= s1) {
            throw new IllegalArgumentException(s);
        }
        int year = Integer.parseInt(s.substring(start, s1));
        if (!DateTimeUtils.isValidDate(year, month = Integer.parseInt(s.substring(s1 + 1, s2)), day = Integer.parseInt(s.substring(s2 + 1, end)))) {
            throw new IllegalArgumentException(year + "-" + month + "-" + day);
        }
        return DateTimeUtils.dateValue(year, month, day);
    }

    public static long parseTimeNanos(String s, int start, int end, boolean timeOfDay) {
        boolean negative;
        int hour = 0;
        int minute = 0;
        int second = 0;
        long nanos = 0L;
        int s1 = s.indexOf(58, start);
        int s2 = s.indexOf(58, s1 + 1);
        int s3 = s.indexOf(46, s2 + 1);
        if (s1 <= 0 || s2 <= s1) {
            throw new IllegalArgumentException(s);
        }
        hour = Integer.parseInt(s.substring(start, s1));
        if (hour < 0) {
            if (timeOfDay) {
                throw new IllegalArgumentException(s);
            }
            negative = true;
            hour = -hour;
        } else {
            negative = false;
        }
        minute = Integer.parseInt(s.substring(s1 + 1, s2));
        if (s3 < 0) {
            second = Integer.parseInt(s.substring(s2 + 1, end));
        } else {
            second = Integer.parseInt(s.substring(s2 + 1, s3));
            String n = (s.substring(s3 + 1, end) + "000000000").substring(0, 9);
            nanos = Integer.parseInt(n);
        }
        if (hour >= 2000000 || minute < 0 || minute >= 60 || second < 0 || second >= 60) {
            throw new IllegalArgumentException(s);
        }
        if (timeOfDay && hour >= 24) {
            throw new IllegalArgumentException(s);
        }
        return negative ? -nanos : (nanos += (((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000000000L);
    }

    public static long getMillis(TimeZone tz, int year, int month, int day, int hour, int minute, int second, int millis) {
        try {
            return DateTimeUtils.getTimeTry(false, tz, year, month, day, hour, minute, second, millis);
        }
        catch (IllegalArgumentException e) {
            String message = e.toString();
            if (message.indexOf("HOUR_OF_DAY") > 0) {
                if (hour < 0 || hour > 23) {
                    throw e;
                }
                return DateTimeUtils.getTimeTry(true, tz, year, month, day, hour, minute, second, millis);
            }
            if (message.indexOf("DAY_OF_MONTH") > 0) {
                int maxDay = month == 2 ? (new GregorianCalendar().isLeapYear(year) ? 29 : 28) : 30 + (month + (month > 7 ? 1 : 0) & 1);
                if (day < 1 || day > maxDay) {
                    throw e;
                }
                return DateTimeUtils.getTimeTry(true, tz, year, month, day, hour += 6, minute, second, millis);
            }
            return DateTimeUtils.getTimeTry(true, tz, year, month, day, hour, minute, second, millis);
        }
    }

    private static long getTimeTry(boolean lenient, TimeZone tz, int year, int month, int day, int hour, int minute, int second, int millis) {
        Calendar c = tz == null ? DateTimeUtils.getCalendar() : DateTimeUtils.getCalendar(tz);
        c.clear();
        c.setLenient(lenient);
        DateTimeUtils.setCalendarFields(c, year, month, day, hour, minute, second, millis);
        return c.getTimeInMillis();
    }

    private static void setCalendarFields(Calendar cal, int year, int month, int day, int hour, int minute, int second, int millis) {
        if (year <= 0) {
            cal.set(0, 0);
            cal.set(1, 1 - year);
        } else {
            cal.set(0, 1);
            cal.set(1, year);
        }
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, millis);
    }

    public static long getMillis(Date date) {
        return date.getTime() - DateTimeUtils.getMillis(null, 1970, 1, 1, 0, 0, 0, 0);
    }

    public static int getDatePart(Date d, int field) {
        Calendar c = DateTimeUtils.getCalendar();
        c.setTime(d);
        if (field < 0) {
            int value = 0;
            switch (field) {
                case -1: {
                    value = c.get(2) / 3 + 1;
                    break;
                }
                case -2: {
                    value = c.get(12) * 100 + c.get(13);
                    break;
                }
                case -3: {
                    value = c.get(11) * 10000 + c.get(12) * 100 + c.get(13);
                    break;
                }
                case -4: {
                    value = c.get(11) * 100 + c.get(12);
                    break;
                }
                case -5: {
                    value = c.get(5) * 1000000 + c.get(11) * 10000 + c.get(12) * 100 + c.get(13);
                    break;
                }
                case -6: {
                    value = c.get(5) * 10000 + c.get(11) * 100 + c.get(12);
                    break;
                }
                case -7: {
                    value = c.get(5) * 100 + c.get(11);
                    break;
                }
                case -8: {
                    value = c.get(1) * 100 + c.get(2) + 1;
                    break;
                }
            }
            return value;
        }
        if (field == 1) {
            return DateTimeUtils.getYear(c);
        }
        int value = c.get(field);
        if (field == 2) {
            return value + 1;
        }
        return value;
    }

    private static int getYear(Calendar calendar) {
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year = 1 - year;
        }
        return year;
    }

    public static long getTimeLocalWithoutDst(Date d) {
        return d.getTime() + (long)DateTimeUtils.getCalendar().get(15);
    }

    public static long getTimeUTCWithoutDst(long millis) {
        return millis - (long)DateTimeUtils.getCalendar().get(15);
    }

    public static int getIsoDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        int val = cal.get(7) - 1;
        return val == 0 ? 7 : val;
    }

    public static int getIsoWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(4);
        return c.get(3);
    }

    public static int getIsoYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        int year = DateTimeUtils.getYear(cal);
        int month = cal.get(2);
        int week = cal.get(3);
        if (month == 0 && week > 51) {
            --year;
        } else if (month == 11 && week == 1) {
            ++year;
        }
        return year;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String format, String locale, String timeZone) {
        SimpleDateFormat dateFormat;
        SimpleDateFormat simpleDateFormat = dateFormat = DateTimeUtils.getDateFormat(format, locale, timeZone);
        synchronized (simpleDateFormat) {
            return dateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String date, String format, String locale, String timeZone) {
        SimpleDateFormat dateFormat = DateTimeUtils.getDateFormat(format, locale, timeZone);
        try {
            SimpleDateFormat simpleDateFormat = dateFormat;
            synchronized (simpleDateFormat) {
                return dateFormat.parse(date);
            }
        }
        catch (Exception e) {
            throw DbException.get(90014, e, date);
        }
    }

    private static SimpleDateFormat getDateFormat(String format, String locale, String timeZone) {
        try {
            SimpleDateFormat df;
            if (locale == null) {
                df = new SimpleDateFormat(format);
            } else {
                Locale l = new Locale(locale);
                df = new SimpleDateFormat(format, l);
            }
            if (timeZone != null) {
                df.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            return df;
        }
        catch (Exception e) {
            throw DbException.get(90014, e, format + "/" + locale + "/" + timeZone);
        }
    }

    public static boolean isValidDate(int year, int month, int day) {
        if (year == 0 && month == 0 && day == 0) {
            return true;
        }
        if (month < 1 || month > 12 || day < 1) {
            return false;
        }
        if (year > 1582) {
            if (month != 2) {
                return day <= NORMAL_DAYS_PER_MONTH[month];
            }
            if ((year & 3) != 0) {
                return day <= 28;
            }
            return day <= (year % 100 != 0 || year % 400 == 0 ? 29 : 28);
        }
        if (year == 1582 && month == 10) {
            return day <= 31 && (day < 5 || day > 14);
        }
        if (month != 2 && day <= NORMAL_DAYS_PER_MONTH[month]) {
            return true;
        }
        return day <= ((year & 3) != 0 ? 28 : 29);
    }

    public static java.sql.Date convertDateValueToDate(long dateValue) {
        long millis = DateTimeUtils.getMillis(null, DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), 0, 0, 0, 0);
        return new java.sql.Date(millis);
    }

    public static Timestamp convertDateValueToTimestamp(long dateValue, long timeNanos) {
        long millis = timeNanos / 1000000L;
        timeNanos -= millis * 1000000L;
        long s = millis / 1000L;
        millis -= s * 1000L;
        long m = s / 60L;
        s -= m * 60L;
        long h = m / 60L;
        long ms = DateTimeUtils.getMillis(null, DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), (int)h, (int)(m -= h * 60L), (int)s, 0);
        Timestamp ts = new Timestamp(ms);
        ts.setNanos((int)(timeNanos + millis * 1000000L));
        return ts;
    }

    public static Time convertNanoToTime(long nanos) {
        long millis = nanos / 1000000L;
        long s = millis / 1000L;
        millis -= s * 1000L;
        long m = s / 60L;
        s -= m * 60L;
        long h = m / 60L;
        m -= h * 60L;
        int year = 1970;
        int month = 1;
        int day = 1;
        if (h >= 24L) {
            Calendar cal = Calendar.getInstance();
            cal.set(year, month - 1, day + (int)(h / 24L));
            year = cal.get(1);
            month = cal.get(2) + 1;
            day = cal.get(5);
        }
        long ms = DateTimeUtils.getMillis(null, year, month, day, (int)(h % 24L), (int)m, (int)s, (int)millis);
        return new Time(ms);
    }

    public static int yearFromDateValue(long x) {
        return (int)(x >>> 9);
    }

    public static int monthFromDateValue(long x) {
        return (int)(x >>> 5) & 0xF;
    }

    public static int dayFromDateValue(long x) {
        return (int)(x & 0x1FL);
    }

    public static long dateValue(long year, int month, int day) {
        return year << 9 | (long)(month << 5) | (long)day;
    }

    public static long dateValueFromDate(long ms) {
        Calendar cal = DateTimeUtils.getCalendar();
        cal.clear();
        cal.setTimeInMillis(ms);
        return DateTimeUtils.dateValueFromCalendar(cal);
    }

    private static long dateValueFromCalendar(Calendar cal) {
        int year = DateTimeUtils.getYear(cal);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return (long)year << 9 | (long)(month << 5) | (long)day;
    }

    public static long nanosFromDate(long ms) {
        Calendar cal = DateTimeUtils.getCalendar();
        cal.clear();
        cal.setTimeInMillis(ms);
        return DateTimeUtils.nanosFromCalendar(cal);
    }

    private static long nanosFromCalendar(Calendar cal) {
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        int millis = cal.get(14);
        return ((((long)h * 60L + (long)m) * 60L + (long)s) * 1000L + (long)millis) * 1000000L;
    }

    public static ValueTimestamp normalizeTimestamp(long absoluteDay, long nanos) {
        if (nanos > 86400000000000L || nanos < 0L) {
            long d = nanos > 86400000000000L ? nanos / 86400000000000L : (nanos - 86400000000000L + 1L) / 86400000000000L;
            nanos -= d * 86400000000000L;
            absoluteDay += d;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), nanos);
    }

    public static long absoluteDayFromDateValue(long dateValue) {
        long y = DateTimeUtils.yearFromDateValue(dateValue);
        int m = DateTimeUtils.monthFromDateValue(dateValue);
        int d = DateTimeUtils.dayFromDateValue(dateValue);
        if (m <= 2) {
            --y;
            m += 12;
        }
        long a = (y * 2922L >> 3) + (long)DAYS_OFFSET[m - 3] + (long)d - 719484L;
        if (y <= 1582L && (y < 1582L || m * 100 + d < 1005)) {
            a += 13L;
        } else if (y < 1901L || y > 2099L) {
            a += y / 400L - y / 100L + 15L;
        }
        return a;
    }

    public static long dateValueFromAbsoluteDay(long absoluteDay) {
        long offset;
        long d = absoluteDay + 719468L;
        long y100 = 0L;
        if (d > 578040L) {
            long y400 = d / 146097L;
            y100 = (d -= y400 * 146097L) / 36524L;
            d -= y100 * 36524L;
            offset = y400 * 400L + y100 * 100L;
        } else {
            d += 292200000002L;
            offset = -800000000L;
        }
        long y4 = d / 1461L;
        long y = (d -= y4 * 1461L) / 365L;
        if ((d -= y * 365L) == 0L && (y == 4L || y100 == 4L)) {
            --y;
            d += 365L;
        }
        y += offset + y4 * 4L;
        int m = ((int)d * 2 + 1) * 5 / 306;
        d -= (long)(DAYS_OFFSET[m] - 1);
        if (m >= 10) {
            ++y;
            m -= 12;
        }
        return DateTimeUtils.dateValue(y, m + 3, (int)d);
    }
}

