/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.value;

import com.alibaba.dts.shade.org.h2.engine.Constants;
import com.alibaba.dts.shade.org.h2.engine.SessionInterface;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.security.SHA256;
import com.alibaba.dts.shade.org.h2.store.Data;
import com.alibaba.dts.shade.org.h2.store.DataReader;
import com.alibaba.dts.shade.org.h2.tools.SimpleResultSet;
import com.alibaba.dts.shade.org.h2.util.DateTimeUtils;
import com.alibaba.dts.shade.org.h2.util.IOUtils;
import com.alibaba.dts.shade.org.h2.util.JdbcUtils;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.util.NetUtils;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.util.Utils;
import com.alibaba.dts.shade.org.h2.value.DataType;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueArray;
import com.alibaba.dts.shade.org.h2.value.ValueBoolean;
import com.alibaba.dts.shade.org.h2.value.ValueByte;
import com.alibaba.dts.shade.org.h2.value.ValueBytes;
import com.alibaba.dts.shade.org.h2.value.ValueDate;
import com.alibaba.dts.shade.org.h2.value.ValueDecimal;
import com.alibaba.dts.shade.org.h2.value.ValueDouble;
import com.alibaba.dts.shade.org.h2.value.ValueFloat;
import com.alibaba.dts.shade.org.h2.value.ValueGeometry;
import com.alibaba.dts.shade.org.h2.value.ValueInt;
import com.alibaba.dts.shade.org.h2.value.ValueJavaObject;
import com.alibaba.dts.shade.org.h2.value.ValueLobDb;
import com.alibaba.dts.shade.org.h2.value.ValueLong;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import com.alibaba.dts.shade.org.h2.value.ValueResultSet;
import com.alibaba.dts.shade.org.h2.value.ValueShort;
import com.alibaba.dts.shade.org.h2.value.ValueString;
import com.alibaba.dts.shade.org.h2.value.ValueStringFixed;
import com.alibaba.dts.shade.org.h2.value.ValueStringIgnoreCase;
import com.alibaba.dts.shade.org.h2.value.ValueTime;
import com.alibaba.dts.shade.org.h2.value.ValueTimestamp;
import com.alibaba.dts.shade.org.h2.value.ValueUuid;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;

public class Transfer {
    private static final int BUFFER_SIZE = 65536;
    private static final int LOB_MAGIC = 4660;
    private static final int LOB_MAC_SALT_LENGTH = 16;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private SessionInterface session;
    private boolean ssl;
    private int version;
    private byte[] lobMacSalt;

    public Transfer(SessionInterface session) {
        this.session = session;
    }

    public void setSocket(Socket s) {
        this.socket = s;
    }

    public synchronized void init() throws IOException {
        if (this.socket != null) {
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 65536));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 65536));
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Transfer writeBoolean(boolean x) throws IOException {
        this.out.writeByte((byte)(x ? 1 : 0));
        return this;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() == 1;
    }

    private Transfer writeByte(byte x) throws IOException {
        this.out.writeByte(x);
        return this;
    }

    private byte readByte() throws IOException {
        return this.in.readByte();
    }

    public Transfer writeInt(int x) throws IOException {
        this.out.writeInt(x);
        return this;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public Transfer writeLong(long x) throws IOException {
        this.out.writeLong(x);
        return this;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    private Transfer writeDouble(double i) throws IOException {
        this.out.writeDouble(i);
        return this;
    }

    private Transfer writeFloat(float i) throws IOException {
        this.out.writeFloat(i);
        return this;
    }

    private double readDouble() throws IOException {
        return this.in.readDouble();
    }

    private float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public Transfer writeString(String s) throws IOException {
        if (s == null) {
            this.out.writeInt(-1);
        } else {
            int len = s.length();
            this.out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                this.out.writeChar(s.charAt(i));
            }
        }
        return this;
    }

    public String readString() throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        StringBuilder buff = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            buff.append(this.in.readChar());
        }
        String s = buff.toString();
        s = StringUtils.cache(s);
        return s;
    }

    public Transfer writeBytes(byte[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            this.out.write(data);
        }
        return this;
    }

    public Transfer writeBytes(byte[] buff, int off, int len) throws IOException {
        this.out.write(buff, off, len);
        return this;
    }

    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        byte[] b = DataUtils.newBytes(len);
        this.in.readFully(b);
        return b;
    }

    public void readBytes(byte[] buff, int off, int len) throws IOException {
        this.in.readFully(buff, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.socket != null) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                DbException.traceThrowable(e);
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void writeValue(Value v) throws IOException {
        int type = v.getType();
        this.writeInt(type);
        switch (type) {
            case 0: {
                break;
            }
            case 12: 
            case 19: {
                this.writeBytes(v.getBytesNoCopy());
                break;
            }
            case 20: {
                ValueUuid uuid = (ValueUuid)v;
                this.writeLong(uuid.getHigh());
                this.writeLong(uuid.getLow());
                break;
            }
            case 1: {
                this.writeBoolean(v.getBoolean());
                break;
            }
            case 2: {
                this.writeByte(v.getByte());
                break;
            }
            case 9: {
                if (this.version >= 9) {
                    this.writeLong(((ValueTime)v).getNanos());
                    break;
                }
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(v.getTime()));
                    break;
                }
                this.writeLong(v.getTime().getTime());
                break;
            }
            case 10: {
                if (this.version >= 9) {
                    this.writeLong(((ValueDate)v).getDateValue());
                    break;
                }
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(v.getDate()));
                    break;
                }
                this.writeLong(v.getDate().getTime());
                break;
            }
            case 11: {
                if (this.version >= 9) {
                    ValueTimestamp ts = (ValueTimestamp)v;
                    this.writeLong(ts.getDateValue());
                    this.writeLong(ts.getTimeNanos());
                    break;
                }
                if (this.version >= 7) {
                    Timestamp ts = v.getTimestamp();
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(ts));
                    this.writeInt(ts.getNanos() % 1000000);
                    break;
                }
                Timestamp ts = v.getTimestamp();
                this.writeLong(ts.getTime());
                this.writeInt(ts.getNanos() % 1000000);
                break;
            }
            case 6: {
                this.writeString(v.getString());
                break;
            }
            case 7: {
                this.writeDouble(v.getDouble());
                break;
            }
            case 8: {
                this.writeFloat(v.getFloat());
                break;
            }
            case 4: {
                this.writeInt(v.getInt());
                break;
            }
            case 5: {
                this.writeLong(v.getLong());
                break;
            }
            case 3: {
                this.writeInt(v.getShort());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                this.writeString(v.getString());
                break;
            }
            case 15: {
                ValueLobDb lob;
                if (this.version >= 11 && v instanceof ValueLobDb && (lob = (ValueLobDb)v).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(lob.getTableId());
                    this.writeLong(lob.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(lob.getLobId()));
                    }
                    this.writeLong(lob.getPrecision());
                    break;
                }
                long length = v.getPrecision();
                if (length < 0L) {
                    throw DbException.get(90067, "length=" + length);
                }
                this.writeLong(length);
                long written = IOUtils.copyAndCloseInput(v.getInputStream(), this.out);
                if (written != length) {
                    throw DbException.get(90067, "length:" + length + " written:" + written);
                }
                this.writeInt(4660);
                break;
            }
            case 16: {
                ValueLobDb lob;
                if (this.version >= 11 && v instanceof ValueLobDb && (lob = (ValueLobDb)v).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(lob.getTableId());
                    this.writeLong(lob.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(lob.getLobId()));
                    }
                    this.writeLong(lob.getPrecision());
                    break;
                }
                long length = v.getPrecision();
                if (length < 0L) {
                    throw DbException.get(90067, "length=" + length);
                }
                if (length > Integer.MAX_VALUE) {
                    throw DbException.get(90067, "length=" + length);
                }
                this.writeLong(length);
                Reader reader = v.getReader();
                Data.copyString(reader, this.out);
                this.writeInt(4660);
                break;
            }
            case 17: {
                ValueArray va = (ValueArray)v;
                Value[] list = va.getList();
                int len = list.length;
                Class<?> componentType = va.getComponentType();
                if (componentType == Object.class) {
                    this.writeInt(len);
                } else {
                    this.writeInt(-(len + 1));
                    this.writeString(componentType.getName());
                }
                for (Value value : list) {
                    this.writeValue(value);
                }
                break;
            }
            case 18: {
                try {
                    int i;
                    ResultSet rs = ((ValueResultSet)v).getResultSet();
                    rs.beforeFirst();
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnCount = meta.getColumnCount();
                    this.writeInt(columnCount);
                    for (i = 0; i < columnCount; ++i) {
                        this.writeString(meta.getColumnName(i + 1));
                        this.writeInt(meta.getColumnType(i + 1));
                        this.writeInt(meta.getPrecision(i + 1));
                        this.writeInt(meta.getScale(i + 1));
                    }
                    while (rs.next()) {
                        this.writeBoolean(true);
                        for (i = 0; i < columnCount; ++i) {
                            int t = DataType.getValueTypeFromResultSet(meta, i + 1);
                            Value val = DataType.readValue(this.session, rs, i + 1, t);
                            this.writeValue(val);
                        }
                    }
                    this.writeBoolean(false);
                    rs.beforeFirst();
                    break;
                }
                catch (SQLException e) {
                    throw DbException.convertToIOException(e);
                }
            }
            case 22: {
                if (this.version >= 14) {
                    this.writeBytes(v.getBytesNoCopy());
                    break;
                }
                this.writeString(v.getString());
                break;
            }
            default: {
                throw DbException.get(90067, "type=" + type);
            }
        }
    }

    public Value readValue() throws IOException {
        int type = this.readInt();
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueBytes.getNoCopy(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.getNoCopy(null, this.readBytes(), this.session.getDataHandler());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 10: {
                if (this.version >= 9) {
                    return ValueDate.fromDateValue(this.readLong());
                }
                if (this.version >= 7) {
                    return ValueDate.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readLong()));
                }
                return ValueDate.fromMillis(this.readLong());
            }
            case 9: {
                if (this.version >= 9) {
                    return ValueTime.fromNanos(this.readLong());
                }
                if (this.version >= 7) {
                    return ValueTime.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readLong()));
                }
                return ValueTime.fromMillis(this.readLong());
            }
            case 11: {
                if (this.version >= 9) {
                    return ValueTimestamp.fromDateValueAndNanos(this.readLong(), this.readLong());
                }
                if (this.version >= 7) {
                    return ValueTimestamp.fromMillisNanos(DateTimeUtils.getTimeUTCWithoutDst(this.readLong()), this.readInt() % 1000000);
                }
                return ValueTimestamp.fromMillisNanos(this.readLong(), this.readInt() % 1000000);
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.readDouble());
            }
            case 8: {
                return ValueFloat.get(this.readFloat());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 15: {
                long length = this.readLong();
                if (this.version >= 11 && length == -1L) {
                    int tableId = this.readInt();
                    long id = this.readLong();
                    byte[] hmac = this.version >= 12 ? this.readBytes() : null;
                    long precision = this.readLong();
                    return ValueLobDb.create(15, this.session.getDataHandler(), tableId, id, hmac, precision);
                }
                Value v = this.session.getDataHandler().getLobStorage().createBlob(this.in, length);
                int magic = this.readInt();
                if (magic != 4660) {
                    throw DbException.get(90067, "magic=" + magic);
                }
                return v;
            }
            case 16: {
                long length = this.readLong();
                if (this.version >= 11) {
                    if (length == -1L) {
                        int tableId = this.readInt();
                        long id = this.readLong();
                        byte[] hmac = this.version >= 12 ? this.readBytes() : null;
                        long precision = this.readLong();
                        return ValueLobDb.create(16, this.session.getDataHandler(), tableId, id, hmac, precision);
                    }
                    if (length < 0L || length > Integer.MAX_VALUE) {
                        throw DbException.get(90067, "length=" + length);
                    }
                    DataReader reader = new DataReader(this.in);
                    int len = (int)length;
                    char[] buff = new char[len];
                    IOUtils.readFully(reader, buff, len);
                    int magic = this.readInt();
                    if (magic != 4660) {
                        throw DbException.get(90067, "magic=" + magic);
                    }
                    byte[] small = new String(buff).getBytes(Constants.UTF8);
                    return ValueLobDb.createSmallLob(16, small, length);
                }
                Value v = this.session.getDataHandler().getLobStorage().createClob(new DataReader(this.in), length);
                int magic = this.readInt();
                if (magic != 4660) {
                    throw DbException.get(90067, "magic=" + magic);
                }
                return v;
            }
            case 17: {
                int len = this.readInt();
                Class componentType = Object.class;
                if (len < 0) {
                    len = -(len + 1);
                    componentType = JdbcUtils.loadUserClass(this.readString());
                }
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = this.readValue();
                }
                return ValueArray.get(componentType, list);
            }
            case 18: {
                SimpleResultSet rs = new SimpleResultSet();
                rs.setAutoClose(false);
                int columns = this.readInt();
                for (int i = 0; i < columns; ++i) {
                    rs.addColumn(this.readString(), this.readInt(), this.readInt(), this.readInt());
                }
                while (this.readBoolean()) {
                    Object[] o = new Object[columns];
                    for (int i = 0; i < columns; ++i) {
                        o[i] = this.readValue().getObject();
                    }
                    rs.addRow(o);
                }
                return ValueResultSet.get(rs);
            }
            case 22: {
                if (this.version >= 14) {
                    return ValueGeometry.get(this.readBytes());
                }
                return ValueGeometry.get(this.readString());
            }
        }
        throw DbException.get(90067, "type=" + type);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSession(SessionInterface session) {
        this.session = session;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public Transfer openNewConnection() throws IOException {
        InetAddress address = this.socket.getInetAddress();
        int port = this.socket.getPort();
        Socket s2 = NetUtils.createSocket(address, port, this.ssl);
        Transfer trans = new Transfer(null);
        trans.setSocket(s2);
        trans.setSSL(this.ssl);
        return trans;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public synchronized boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public void verifyLobMac(byte[] hmac, long lobId) {
        byte[] result = this.calculateLobMac(lobId);
        if (!Utils.compareSecure(hmac, result)) {
            throw DbException.get(90067, "Invalid lob hmac; possibly the connection was re-opened internally");
        }
    }

    private byte[] calculateLobMac(long lobId) {
        if (this.lobMacSalt == null) {
            this.lobMacSalt = MathUtils.secureRandomBytes(16);
        }
        byte[] data = new byte[8];
        Utils.writeLong(data, 0, lobId);
        byte[] hmacData = SHA256.getHashWithSalt(data, this.lobMacSalt);
        return hmacData;
    }
}

