/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.value;

import com.alibaba.dts.shade.org.h2.engine.SysProperties;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.value.CompareMode;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ValueString
extends Value {
    private static final ValueString EMPTY = new ValueString("");
    protected final String value;

    protected ValueString(String value) {
        this.value = value;
    }

    @Override
    public String getSQL() {
        return StringUtils.quoteStringSQL(this.value);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueString && this.value.equals(((ValueString)other).value);
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueString v = (ValueString)o;
        return mode.compareString(this.value, v.value, false);
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public long getPrecision() {
        return this.value.length();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setString(parameterIndex, this.value);
    }

    @Override
    public int getDisplaySize() {
        return this.value.length();
    }

    @Override
    public int getMemory() {
        return this.value.length() * 2 + 48;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (precision == 0L || (long)this.value.length() <= precision) {
            return this;
        }
        int p = MathUtils.convertLongToInt(precision);
        return this.getNew(this.value.substring(0, p));
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int getType() {
        return 13;
    }

    public static Value get(String s) {
        return ValueString.get(s, false);
    }

    public static Value get(String s, boolean treatEmptyStringsAsNull) {
        if (s.isEmpty()) {
            return treatEmptyStringsAsNull ? ValueNull.INSTANCE : EMPTY;
        }
        ValueString obj = new ValueString(StringUtils.cache(s));
        if (s.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return Value.cache(obj);
    }

    protected Value getNew(String s) {
        return ValueString.get(s);
    }
}

