/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client;

import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.system.consumer.Consumer;
import com.alibaba.tmq.client.system.consumer.config.ConsumerConfig;
import com.alibaba.tmq.client.system.consumer.executer.ConsumerExecuter;
import com.alibaba.tmq.client.system.producer.NormalProducer;
import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.client.system.producer.executer.NormalProducerExecuter;
import com.alibaba.tmq.client.system.producer.executer.TransactionProducerExecuter;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.domain.ConsumerKey;
import com.alibaba.tmq.common.util.RandomUtil;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TMQFactory
extends ClientContext {
    private static final Log logger = LogFactory.getLog(TMQFactory.class);
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, NormalProducerExecuter>> normalProducerTable = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionProducerExecuter>> transactionProducerTable = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, ConsumerExecuter>> consumerTable = new ConcurrentHashMap();

    public static synchronized NormalProducer createNormalProducer(Properties properties) {
        NormalProducerExecuter producerExecuter;
        ConcurrentHashMap<String, NormalProducerExecuter> producerMap;
        String instanceName;
        String produceTimeout;
        String backupClusterId;
        if (null == properties) {
            throw new RuntimeException("[TMQFactory]: createNormalProducer error, properties is null");
        }
        ProducerConfig producerConfig = new ProducerConfig();
        producerConfig.setProducerId(properties.getProperty("producerId"));
        if (StringUtil.isBlank(producerConfig.getProducerId())) {
            throw new RuntimeException("[TMQFactory]: createNormalProducer error, ProducerId is empty");
        }
        String clusterId = properties.getProperty("clusterId");
        if (StringUtil.isNotBlank(clusterId)) {
            producerConfig.setClusterId(Integer.parseInt(clusterId));
            clientConfig.setClusterId(producerConfig.getClusterId());
        }
        if (StringUtil.isNotBlank(backupClusterId = properties.getProperty("backupClusterId"))) {
            clientConfig.setBackupClusterId(Integer.parseInt(backupClusterId));
        }
        if (StringUtil.isNotBlank(produceTimeout = properties.getProperty("produceTimeout"))) {
            clientConfig.setProduceTimeout(Long.valueOf(produceTimeout));
        }
        if (StringUtil.isNotBlank(instanceName = properties.getProperty("instanceName"))) {
            producerConfig.setInstanceName(instanceName);
        }
        if (null == (producerMap = normalProducerTable.get(producerConfig.getProducerId()))) {
            producerMap = new ConcurrentHashMap();
            normalProducerTable.put(producerConfig.getProducerId(), producerMap);
        }
        if (null != (producerExecuter = producerMap.get(producerConfig.getInstanceName()))) {
            throw new RuntimeException("[TMQFactory]: createNormalProducer error, producerId and instanceName is already exists, producerId:" + producerConfig.getProducerId() + ", instanceName:" + producerConfig.getInstanceName());
        }
        producerExecuter = new NormalProducerExecuter(producerConfig);
        producerMap.put(producerConfig.getInstanceName(), producerExecuter);
        return producerExecuter.getProducer();
    }

    public static synchronized Consumer createConsumer(Properties properties) {
        ConsumerExecuter consumerExecuter;
        ConcurrentHashMap<String, ConsumerExecuter> consumerMap;
        String instanceName;
        String backupClusterId;
        if (null == properties) {
            throw new RuntimeException("[TMQFactory]: createConsumer error, properties is null");
        }
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setConsumerId(properties.getProperty("consumerId"));
        if (StringUtil.isBlank(consumerConfig.getConsumerId())) {
            throw new RuntimeException("[TMQFactory]: createConsumer error, ConsumerId is empty");
        }
        String clusterId = properties.getProperty("clusterId");
        if (StringUtil.isNotBlank(clusterId)) {
            consumerConfig.setClusterId(Integer.parseInt(clusterId));
            clientConfig.setClusterId(consumerConfig.getClusterId());
        }
        if (StringUtil.isNotBlank(backupClusterId = properties.getProperty("backupClusterId"))) {
            clientConfig.setBackupClusterId(Integer.parseInt(backupClusterId));
        }
        if (StringUtil.isNotBlank(instanceName = properties.getProperty("instanceName"))) {
            consumerConfig.setInstanceName(instanceName);
        }
        if (null == (consumerMap = consumerTable.get(consumerConfig.getConsumerId()))) {
            consumerMap = new ConcurrentHashMap();
            consumerTable.put(consumerConfig.getConsumerId(), consumerMap);
        }
        if (null != (consumerExecuter = consumerMap.get(consumerConfig.getInstanceName()))) {
            throw new RuntimeException("[TMQFactory]: createConsumer error, consumerId and instanceName is already exists, consumerId:" + consumerConfig.getConsumerId() + ", instanceName:" + consumerConfig.getInstanceName());
        }
        consumerExecuter = new ConsumerExecuter(consumerConfig, consumerConfig.getInstanceName());
        consumerMap.put(consumerConfig.getInstanceName(), consumerExecuter);
        return consumerExecuter.getConsumer();
    }

    public static void removeNormalProducer(String producerId, String instanceName) {
        ConcurrentHashMap<String, NormalProducerExecuter> producerMap = normalProducerTable.get(producerId);
        if (null == producerMap) {
            return;
        }
        if (StringUtil.isBlank(instanceName)) {
            try {
                normalProducerTable.remove(producerId);
            }
            catch (Throwable e) {
                logger.error((Object)("[TMQFactory]: removeNormalProducer error, producerId:" + producerId), e);
            }
        } else {
            try {
                producerMap.remove(instanceName);
            }
            catch (Throwable e) {
                logger.error((Object)("[TMQFactory]: removeNormalProducer error, producerId:" + producerId + ", instanceName:" + instanceName), e);
            }
        }
    }

    public static void removeTransactionProducer(String producerId, String instanceName) {
        ConcurrentHashMap<String, TransactionProducerExecuter> producerMap = transactionProducerTable.get(producerId);
        if (null == producerMap) {
            return;
        }
        if (StringUtil.isBlank(instanceName)) {
            try {
                transactionProducerTable.remove(producerId);
            }
            catch (Throwable e) {
                logger.error((Object)("[TMQFactory]: removeTransactionProducer error, producerId:" + producerId), e);
            }
        } else {
            try {
                producerMap.remove(instanceName);
            }
            catch (Throwable e) {
                logger.error((Object)("[TMQFactory]: removeTransactionProducer error, producerId:" + producerId + ", instanceName:" + instanceName), e);
            }
        }
    }

    public static TransactionProducerExecuter aquireTransactionProducerExecuter(String producerId, String instanceName) {
        ConcurrentHashMap<String, TransactionProducerExecuter> producerMap = transactionProducerTable.get(producerId);
        if (null == producerMap || producerMap.size() <= 0) {
            return null;
        }
        if (StringUtil.isBlank(instanceName)) {
            return RandomUtil.getRandomObject4Map(producerMap);
        }
        return producerMap.get(instanceName);
    }

    public static ConsumerExecuter aquireConsumerExecuter(ConsumerKey consumerKey, String instanceName) {
        ConcurrentHashMap<String, ConsumerExecuter> consumerMap = consumerTable.get(consumerKey.getConsumerId());
        if (null == consumerMap || consumerMap.size() <= 0) {
            return null;
        }
        if (StringUtil.isBlank(instanceName)) {
            return RandomUtil.getRandomObject4Map(consumerMap);
        }
        return consumerMap.get(instanceName);
    }

    public static void removeConsumer(String consumerId, String instanceName) {
        ConcurrentHashMap<String, ConsumerExecuter> consumerMap = consumerTable.get(consumerId);
        if (null == consumerMap) {
            return;
        }
        String beforeConsumerMap = consumerMap.toString();
        if (StringUtil.isBlank(instanceName)) {
            try {
                consumerTable.remove(consumerId);
            }
            catch (Throwable e) {
                logger.error((Object)("[TMQFactory]: removeConsumer error, consumerId:" + consumerId), e);
            }
        } else {
            try {
                consumerMap.remove(instanceName);
            }
            catch (Throwable e) {
                logger.error((Object)("[TMQFactory]: removeConsumer error, consumerId:" + consumerId + ", instanceName:" + instanceName), e);
            }
        }
        logger.warn((Object)("[TMQFactory]: removeConsumer, consumerId:" + consumerId + ", instanceName:" + instanceName + ", beforeConsumerMap:" + beforeConsumerMap + ", afterConsumerMap" + consumerMap));
    }

    public static ConcurrentHashMap<String, ConcurrentHashMap<String, NormalProducerExecuter>> getNormalproducertable() {
        return normalProducerTable;
    }

    public static ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionProducerExecuter>> getTransactionproducertable() {
        return transactionProducerTable;
    }

    public static ConcurrentHashMap<String, ConcurrentHashMap<String, ConsumerExecuter>> getConsumertable() {
        return consumerTable;
    }
}

