/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.remoting.timer;

import com.alibaba.tmq.client.TMQFactory;
import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.system.consumer.executer.ConsumerExecuter;
import com.alibaba.tmq.client.system.consumer.listener.MessageListener;
import com.alibaba.tmq.client.system.producer.executer.NormalProducerExecuter;
import com.alibaba.tmq.client.system.producer.executer.TransactionProducerExecuter;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.ConsumerKey;
import com.alibaba.tmq.common.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientHeartBeatTimer
extends TimerTask
implements Constants {
    private static final Log logger = LogFactory.getLog(ClientHeartBeatTimer.class);

    @Override
    public void run() {
        try {
            List<String> serverListForProducer = ClientContext.zookeeper.getServerListForProducer();
            if (ListUtil.isEmpty(serverListForProducer)) {
                logger.warn((Object)("[ClientHeartBeatTimer]: serverListForProducer is empty, clientConfig:" + ClientContext.clientConfig));
            } else {
                if (serverListForProducer.size() == 1 && serverListForProducer.get(0).equals("1.2.3.4")) {
                    logger.warn((Object)"[ClientHeartBeatTimer]: receive fake server, isolated!!!");
                    serverListForProducer.clear();
                }
                ClientContext.clientRemoting.setCachedServerListForProducer(serverListForProducer);
                this.checkHeartBeatForProducer(serverListForProducer);
            }
            List<String> serverListForConsumer = ClientContext.zookeeper.getServerListForConsumer();
            if (ListUtil.isEmpty(serverListForConsumer)) {
                logger.warn((Object)("[ClientHeartBeatTimer]: serverListForConsumer is empty, clientConfig:" + ClientContext.clientConfig));
            } else {
                if (serverListForConsumer.size() == 1 && serverListForConsumer.get(0).equals("1.2.3.4")) {
                    logger.warn((Object)"[ClientHeartBeatTimer]: receive fake server, isolated!!!");
                    serverListForConsumer.clear();
                }
                ClientContext.clientRemoting.setCachedServerListForConsumer(serverListForConsumer);
                this.checkHeartBeatForConsumer(serverListForConsumer);
            }
            if (StringUtil.isNotBlank(ClientContext.clientConfig.getBackupDomainName())) {
                List<String> backupServerListForProducer = ClientContext.zookeeper.getbackupServerListForProducer();
                if (ListUtil.isEmpty(backupServerListForProducer)) {
                    logger.warn((Object)("[ClientHeartBeatTimer]: backupServerListForProducer is empty, clientConfig:" + ClientContext.clientConfig));
                } else {
                    if (backupServerListForProducer.size() == 1 && backupServerListForProducer.get(0).equals("1.2.3.4")) {
                        logger.warn((Object)"[ClientHeartBeatTimer]: receive fake server, isolated!!!");
                        backupServerListForProducer.clear();
                    }
                    ClientContext.clientRemoting.setCachedBackupServerListForProducer(backupServerListForProducer);
                    this.checkHeartBeatForProducer(backupServerListForProducer);
                }
                List<String> backupServerListForConsumer = ClientContext.zookeeper.getbackupServerListForConsumer();
                if (ListUtil.isEmpty(backupServerListForConsumer)) {
                    logger.warn((Object)("[ClientHeartBeatTimer]: backupServerListForConsumer is empty, clientConfig:" + ClientContext.clientConfig));
                } else {
                    if (backupServerListForConsumer.size() == 1 && backupServerListForConsumer.get(0).equals("1.2.3.4")) {
                        logger.warn((Object)"[ClientHeartBeatTimer]: receive fake server, isolated!!!");
                        backupServerListForConsumer.clear();
                    }
                    ClientContext.clientRemoting.setCachedBackupServerListForConsumer(backupServerListForConsumer);
                    this.checkHeartBeatForConsumer(backupServerListForConsumer);
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)("[ClientHeartBeatTimer]: run error, clientConfig:" + ClientContext.clientConfig), e);
        }
    }

    private void checkHeartBeat(List<String> serverList) {
        for (String server : serverList) {
            try {
                this.checkProducerHeartBeat(server);
                this.checkConsumerHeartBeat(server);
            }
            catch (Throwable e) {
                logger.error((Object)("[ClientHeartBeatTimer]: checkHeartBeat error, clientConfig:" + ClientContext.clientConfig + ", server:" + server), e);
            }
        }
    }

    private void checkHeartBeatForProducer(List<String> serverList) {
        for (String server : serverList) {
            try {
                this.checkProducerHeartBeat(server);
            }
            catch (Throwable e) {
                logger.error((Object)("[ClientHeartBeatTimer]: checkHeartBeat error, clientConfig:" + ClientContext.clientConfig + ", server:" + server), e);
            }
        }
    }

    private void checkHeartBeatForConsumer(List<String> serverList) {
        for (String server : serverList) {
            try {
                this.checkConsumerHeartBeat(server);
            }
            catch (Throwable e) {
                logger.error((Object)("[ClientHeartBeatTimer]: checkHeartBeat error, clientConfig:" + ClientContext.clientConfig + ", server:" + server), e);
            }
        }
    }

    private void checkProducerHeartBeat(String server) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, NormalProducerExecuter>> normalProducerTable = TMQFactory.getNormalproducertable();
        this.checkNormalProducerHeartBeat(server, normalProducerTable, "normalProducerTable");
        ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionProducerExecuter>> transactionProducerTable = TMQFactory.getTransactionproducertable();
        this.checkTransactionProducerHeartBeat(server, transactionProducerTable, "transactionProducerTable");
    }

    private void checkNormalProducerHeartBeat(String server, ConcurrentHashMap<String, ConcurrentHashMap<String, NormalProducerExecuter>> producerTable, String source) {
        for (Map.Entry<String, ConcurrentHashMap<String, NormalProducerExecuter>> entry : producerTable.entrySet()) {
            String producerId = entry.getKey();
            ConcurrentHashMap<String, NormalProducerExecuter> producerMap = entry.getValue();
            for (Map.Entry<String, NormalProducerExecuter> producerEntry : producerMap.entrySet()) {
                String instanceName = producerEntry.getKey();
                try {
                    ClientContext.clientRemoting.connectServer(instanceName, server, 0, producerId, "NULL", "NULL");
                }
                catch (Throwable e) {
                    logger.error((Object)("[ClientHeartBeatTimer]: checkNormalProducerHeartBeat connectServer error, server:" + server + ", clientConfig:" + ClientContext.clientConfig + ", producerId:" + producerId + ", instanceName:" + instanceName), e);
                }
            }
        }
    }

    private void checkTransactionProducerHeartBeat(String server, ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionProducerExecuter>> producerTable, String source) {
        for (Map.Entry<String, ConcurrentHashMap<String, TransactionProducerExecuter>> entry : producerTable.entrySet()) {
            String producerId = entry.getKey();
            ConcurrentHashMap<String, TransactionProducerExecuter> producerMap = entry.getValue();
            for (Map.Entry<String, TransactionProducerExecuter> producerEntry : producerMap.entrySet()) {
                String instanceName = producerEntry.getKey();
                try {
                    ClientContext.clientRemoting.connectServer(instanceName, server, 0, producerId, "NULL", "NULL");
                }
                catch (Throwable e) {
                    logger.error((Object)("[ClientHeartBeatTimer]: checkTransactionProducerHeartBeat connectServer error, server:" + server + ", clientConfig:" + ClientContext.clientConfig + ", producerId:" + producerId + ", instanceName:" + instanceName), e);
                }
            }
        }
    }

    private void checkConsumerHeartBeat(String server) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConsumerExecuter>> consumerTable = TMQFactory.getConsumertable();
        for (Map.Entry<String, ConcurrentHashMap<String, ConsumerExecuter>> entry : consumerTable.entrySet()) {
            String consumerId = entry.getKey();
            ConcurrentHashMap<String, ConsumerExecuter> consumerMap = entry.getValue();
            for (Map.Entry<String, ConsumerExecuter> consumerEntry : consumerMap.entrySet()) {
                String instanceName = consumerEntry.getKey();
                ConsumerExecuter consumerExecuter = consumerEntry.getValue();
                ConcurrentHashMap<ConsumerKey, MessageListener> listenerTable = consumerExecuter.getListenerTable();
                for (Map.Entry<ConsumerKey, MessageListener> listenerEntry : listenerTable.entrySet()) {
                    ConsumerKey consumerKey = listenerEntry.getKey();
                    try {
                        ClientContext.clientRemoting.connectServer(instanceName, server, 1, consumerId, consumerKey.getTopic(), consumerKey.getTag());
                    }
                    catch (Throwable e) {
                        logger.error((Object)("[ClientHeartBeatTimer]: connectServer error, server:" + server + ", clientConfig:" + ClientContext.clientConfig + ", consumerId:" + consumerId + ", instanceName:" + instanceName + ", consumerKey:" + consumerKey), e);
                    }
                }
            }
        }
    }
}

