/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.system.consumer.executer;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.tmq.client.system.consumer.Consumer;
import com.alibaba.tmq.client.system.consumer.config.ConsumerConfig;
import com.alibaba.tmq.client.system.consumer.executer.ConsumeContext;
import com.alibaba.tmq.client.system.consumer.implement.DefaultConsumer;
import com.alibaba.tmq.client.system.consumer.listener.MessageListener;
import com.alibaba.tmq.common.domain.Action;
import com.alibaba.tmq.common.domain.ConsumerKey;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsumerExecuter {
    private static final Log logger = LogFactory.getLog(ConsumerExecuter.class);
    private final Consumer consumer;
    private final ConcurrentHashMap<ConsumerKey, MessageListener> listenerTable = new ConcurrentHashMap();
    private final ConsumerConfig consumerConfig;
    private volatile boolean start = false;

    public ConsumerExecuter(ConsumerConfig consumerConfig, String instanceName) {
        this.consumerConfig = consumerConfig;
        this.consumer = new DefaultConsumer(this, consumerConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Action> consume(ConsumerKey consumerKey, Message message, ConnectionChannel connectionChannel) {
        Result<Action> result = new Result<Action>();
        MessageListener messageListener = this.listenerTable.get(consumerKey);
        if (null == messageListener) {
            throw new RuntimeException("[ConsumerExecuter]: consume message fatal error, messageListener is null, message:" + message + ", consumerKey:" + consumerKey);
        }
        ConsumeContext context = new ConsumeContext();
        context.setRemoteAddress(connectionChannel.getRemoteAddress());
        context.setServerPushTime(connectionChannel.getServerPushTime());
        if (message.getTb_eagleeyex_t() != null && message.getTb_eagleeyex_t().equals("1")) {
            EagleEye.putUserData("t", "1");
            logger.warn((Object)("[ConsumerExecuter]: set Tb_eagleeyex_t , message:" + message + ", consumerKey:" + consumerKey));
        }
        Action action = Action.RETRY;
        try {
            action = messageListener.consume(message, context);
        }
        catch (Throwable e) {
            logger.error((Object)("[ConsumerExecuter]: consume message error, message:" + message + ", consumerKey:" + consumerKey), e);
            result.setData(Action.RETRY);
            result.setResultCode(ResultCode.CONSUME_EXCEPTION);
            Result<Action> result2 = result;
            return result2;
        }
        finally {
            try {
                EagleEye.removeUserData("t");
            }
            catch (Throwable e) {
                logger.error((Object)("[ConsumerExecuter]: consume removeUserData error, message:" + message + ", consumerKey:" + consumerKey), e);
            }
        }
        if (null == action) {
            logger.error((Object)("[ConsumerExecuter]: consume result action is null error, waiting retry, message:" + message + ", consumerKey:" + consumerKey));
            result.setData(Action.RETRY);
            result.setResultCode(ResultCode.CONSUME_RETURN_NULL_ERROR);
            return result;
        }
        if (Action.FAILURE.equals((Object)action)) {
            action = Action.RETRY;
        }
        result.setData(action);
        result.setResultCode(ResultCode.SUCCESS);
        return result;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public ConcurrentHashMap<ConsumerKey, MessageListener> getListenerTable() {
        return this.listenerTable;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

