/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPathException;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.util.IOUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONPath
implements JSONAware {
    private static int CACHE_SIZE = 1024;
    private static ConcurrentMap<String, JSONPath> pathCache = new ConcurrentHashMap<String, JSONPath>(128, 0.75f, 1);
    private final String path;
    private Segement[] segments;
    private SerializeConfig serializeConfig;
    private ParserConfig parserConfig;

    public JSONPath(String path) {
        this(path, SerializeConfig.getGlobalInstance(), ParserConfig.getGlobalInstance());
    }

    public JSONPath(String path, SerializeConfig serializeConfig, ParserConfig parserConfig) {
        if (path == null || path.isEmpty()) {
            throw new JSONPathException("json-path can not be null or empty");
        }
        this.path = path;
        this.serializeConfig = serializeConfig;
        this.parserConfig = parserConfig;
    }

    protected void init() {
        if (this.segments != null) {
            return;
        }
        if ("*".equals(this.path)) {
            this.segments = new Segement[]{WildCardSegement.instance};
        } else {
            JSONPathParser parser = new JSONPathParser(this.path);
            this.segments = parser.explain();
        }
    }

    public Object eval(Object rootObject) {
        if (rootObject == null) {
            return null;
        }
        this.init();
        Object currentObject = rootObject;
        for (int i = 0; i < this.segments.length; ++i) {
            currentObject = this.segments[i].eval(this, rootObject, currentObject);
        }
        return currentObject;
    }

    public boolean contains(Object rootObject) {
        if (rootObject == null) {
            return false;
        }
        this.init();
        Object currentObject = rootObject;
        for (int i = 0; i < this.segments.length; ++i) {
            if ((currentObject = this.segments[i].eval(this, rootObject, currentObject)) != null) continue;
            return false;
        }
        return true;
    }

    public boolean containsValue(Object rootObject, Object value) {
        Object currentObject = this.eval(rootObject);
        if (currentObject == value) {
            return true;
        }
        if (currentObject == null) {
            return false;
        }
        if (currentObject instanceof Iterable) {
            for (Object item : (Iterable)currentObject) {
                if (!JSONPath.eq(item, value)) continue;
                return true;
            }
            return false;
        }
        return JSONPath.eq(currentObject, value);
    }

    public int size(Object rootObject) {
        if (rootObject == null) {
            return -1;
        }
        this.init();
        Object currentObject = rootObject;
        for (int i = 0; i < this.segments.length; ++i) {
            currentObject = this.segments[i].eval(this, rootObject, currentObject);
        }
        return this.evalSize(currentObject);
    }

    public void arrayAdd(Object rootObject, Object ... values) {
        Object descArray;
        if (values == null || values.length == 0) {
            return;
        }
        if (rootObject == null) {
            return;
        }
        this.init();
        Object currentObject = rootObject;
        Object parentObject = null;
        for (int i = 0; i < this.segments.length; ++i) {
            if (i == this.segments.length - 1) {
                parentObject = currentObject;
            }
            currentObject = this.segments[i].eval(this, rootObject, currentObject);
        }
        Object result = currentObject;
        if (result == null) {
            throw new JSONPathException("value not found in path " + this.path);
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            for (Object value : values) {
                collection.add(value);
            }
            return;
        }
        Class<?> resultClass = result.getClass();
        if (resultClass.isArray()) {
            int length = Array.getLength(result);
            descArray = Array.newInstance(resultClass.getComponentType(), length + values.length);
            System.arraycopy(result, 0, descArray, 0, length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(descArray, length + i, values[i]);
            }
        } else {
            throw new JSONException("unsupported array put operation. " + resultClass);
        }
        Object newResult = descArray;
        Segement lastSegement = this.segments[this.segments.length - 1];
        if (lastSegement instanceof PropertySegement) {
            PropertySegement propertySegement = (PropertySegement)lastSegement;
            propertySegement.setValue(this, parentObject, newResult);
            return;
        }
        if (lastSegement instanceof ArrayAccessSegement) {
            ((ArrayAccessSegement)lastSegement).setValue(this, parentObject, newResult);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object rootObject) {
        if (rootObject == null) {
            return false;
        }
        this.init();
        Object currentObject = rootObject;
        Object parentObject = null;
        for (int i = 0; i < this.segments.length; ++i) {
            if (i == this.segments.length - 1) {
                parentObject = currentObject;
                break;
            }
            if ((currentObject = this.segments[i].eval(this, rootObject, currentObject)) == null) break;
        }
        if (parentObject == null) {
            return false;
        }
        Segement lastSegement = this.segments[this.segments.length - 1];
        if (lastSegement instanceof PropertySegement) {
            PropertySegement propertySegement = (PropertySegement)lastSegement;
            return propertySegement.remove(this, parentObject);
        }
        if (lastSegement instanceof ArrayAccessSegement) {
            return ((ArrayAccessSegement)lastSegement).remove(this, parentObject);
        }
        throw new UnsupportedOperationException();
    }

    public boolean set(Object rootObject, Object value) {
        if (rootObject == null) {
            return false;
        }
        this.init();
        Object currentObject = rootObject;
        Object parentObject = null;
        for (int i = 0; i < this.segments.length; ++i) {
            parentObject = currentObject;
            Segement segment = this.segments[i];
            if ((currentObject = segment.eval(this, rootObject, currentObject)) != null) continue;
            Segement nextSegement = null;
            if (i < this.segments.length - 1) {
                nextSegement = this.segments[i + 1];
            }
            JSON newObj = null;
            if (nextSegement instanceof PropertySegement) {
                newObj = new JSONObject();
            } else if (nextSegement instanceof ArrayAccessSegement) {
                newObj = new JSONArray();
            }
            if (newObj == null) break;
            if (segment instanceof PropertySegement) {
                PropertySegement propSegement = (PropertySegement)segment;
                propSegement.setValue(this, parentObject, newObj);
                currentObject = newObj;
                continue;
            }
            if (!(segment instanceof ArrayAccessSegement)) break;
            ArrayAccessSegement arrayAccessSegement = (ArrayAccessSegement)segment;
            arrayAccessSegement.setValue(this, parentObject, newObj);
            currentObject = newObj;
        }
        if (parentObject == null) {
            return false;
        }
        Segement lastSegement = this.segments[this.segments.length - 1];
        if (lastSegement instanceof PropertySegement) {
            PropertySegement propertySegement = (PropertySegement)lastSegement;
            propertySegement.setValue(this, parentObject, value);
            return true;
        }
        if (lastSegement instanceof ArrayAccessSegement) {
            return ((ArrayAccessSegement)lastSegement).setValue(this, parentObject, value);
        }
        throw new UnsupportedOperationException();
    }

    public static Object eval(Object rootObject, String path) {
        JSONPath jsonpath = JSONPath.compile(path);
        return jsonpath.eval(rootObject);
    }

    public static int size(Object rootObject, String path) {
        JSONPath jsonpath = JSONPath.compile(path);
        Object result = jsonpath.eval(rootObject);
        return jsonpath.evalSize(result);
    }

    public static boolean contains(Object rootObject, String path) {
        if (rootObject == null) {
            return false;
        }
        JSONPath jsonpath = JSONPath.compile(path);
        return jsonpath.contains(rootObject);
    }

    public static boolean containsValue(Object rootObject, String path, Object value) {
        JSONPath jsonpath = JSONPath.compile(path);
        return jsonpath.containsValue(rootObject, value);
    }

    public static void arrayAdd(Object rootObject, String path, Object ... values) {
        JSONPath jsonpath = JSONPath.compile(path);
        jsonpath.arrayAdd(rootObject, values);
    }

    public static boolean set(Object rootObject, String path, Object value) {
        JSONPath jsonpath = JSONPath.compile(path);
        return jsonpath.set(rootObject, value);
    }

    public static boolean remove(Object root, String path) {
        JSONPath jsonpath = JSONPath.compile(path);
        return jsonpath.remove(root);
    }

    public static JSONPath compile(String path) {
        if (path == null) {
            throw new JSONPathException("jsonpath can not be null");
        }
        JSONPath jsonpath = (JSONPath)pathCache.get(path);
        if (jsonpath == null) {
            jsonpath = new JSONPath(path);
            if (pathCache.size() < CACHE_SIZE) {
                pathCache.putIfAbsent(path, jsonpath);
                jsonpath = (JSONPath)pathCache.get(path);
            }
        }
        return jsonpath;
    }

    public static Object read(String json, String path) {
        Object object = JSON.parse(json);
        JSONPath jsonpath = JSONPath.compile(path);
        return jsonpath.eval(object);
    }

    public static Map<String, Object> paths(Object javaObject) {
        return JSONPath.paths(javaObject, SerializeConfig.globalInstance);
    }

    public static Map<String, Object> paths(Object javaObject, SerializeConfig config) {
        IdentityHashMap<Object, String> values = new IdentityHashMap<Object, String>();
        JSONPath.paths(values, "/", javaObject, config);
        HashMap<String, Object> paths = new HashMap<String, Object>();
        for (Map.Entry entry : values.entrySet()) {
            paths.put((String)entry.getValue(), entry.getKey());
        }
        return paths;
    }

    private static void paths(Map<Object, String> paths, String parent, Object javaObject, SerializeConfig config) {
        if (javaObject == null) {
            return;
        }
        if (paths.containsKey(javaObject)) {
            return;
        }
        paths.put(javaObject, parent);
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            for (Map.Entry entryObj : map.entrySet()) {
                Map.Entry entry = entryObj;
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                String path = parent.equals("/") ? "/" + key : parent + "/" + key;
                JSONPath.paths(paths, path, entry.getValue(), config);
            }
            return;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            int i = 0;
            for (Object item : collection) {
                String path = parent.equals("/") ? "/" + i : parent + "/" + i;
                JSONPath.paths(paths, path, item, config);
                ++i;
            }
            return;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                String path = parent.equals("/") ? "/" + i : parent + "/" + i;
                JSONPath.paths(paths, path, item, config);
                ++i;
            }
            return;
        }
        if (ParserConfig.isPrimitive(clazz) || clazz.isEnum()) {
            return;
        }
        ObjectSerializer serializer = config.getObjectWriter(clazz);
        if (serializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)serializer;
            try {
                Map<String, Object> fieldValues = javaBeanSerializer.getFieldValuesMap(javaObject);
                for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
                    String key = entry.getKey();
                    if (!(key instanceof String)) continue;
                    String path = parent.equals("/") ? "/" + key : parent + "/" + key;
                    JSONPath.paths(paths, path, entry.getValue(), config);
                }
            }
            catch (Exception e) {
                throw new JSONException("toJSON error", e);
            }
            return;
        }
    }

    public String getPath() {
        return this.path;
    }

    protected Object getArrayItem(Object currentObject, int index) {
        if (currentObject == null) {
            return null;
        }
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            if (index >= 0) {
                if (index < list.size()) {
                    return list.get(index);
                }
                return null;
            }
            if (Math.abs(index) <= list.size()) {
                return list.get(list.size() + index);
            }
            return null;
        }
        if (currentObject.getClass().isArray()) {
            int arrayLenth = Array.getLength(currentObject);
            if (index >= 0) {
                if (index < arrayLenth) {
                    return Array.get(currentObject, index);
                }
                return null;
            }
            if (Math.abs(index) <= arrayLenth) {
                return Array.get(currentObject, arrayLenth + index);
            }
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public boolean setArrayItem(JSONPath path, Object currentObject, int index, Object value) {
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            if (index >= 0) {
                list.set(index, value);
            } else {
                list.set(list.size() + index, value);
            }
            return true;
        }
        Class<?> clazz = currentObject.getClass();
        if (clazz.isArray()) {
            int arrayLenth = Array.getLength(currentObject);
            if (index >= 0) {
                if (index < arrayLenth) {
                    Array.set(currentObject, index, value);
                }
            } else if (Math.abs(index) <= arrayLenth) {
                Array.set(currentObject, arrayLenth + index, value);
            }
            return true;
        }
        throw new JSONPathException("unsupported set operation." + clazz);
    }

    public boolean removeArrayItem(JSONPath path, Object currentObject, int index) {
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            if (index >= 0) {
                if (index >= list.size()) {
                    return false;
                }
                list.remove(index);
            } else {
                int newIndex = list.size() + index;
                if (newIndex < 0) {
                    return false;
                }
                list.remove(newIndex);
            }
            return true;
        }
        Class<?> clazz = currentObject.getClass();
        throw new JSONPathException("unsupported set operation." + clazz);
    }

    protected Collection<Object> getPropertyValues(Object currentObject) {
        Class<?> currentClass = currentObject.getClass();
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentClass);
        if (beanSerializer != null) {
            try {
                return beanSerializer.getFieldValues(currentObject);
            }
            catch (Exception e) {
                throw new JSONPathException("jsonpath error, path " + this.path, e);
            }
        }
        if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            return map.values();
        }
        throw new UnsupportedOperationException();
    }

    static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() == b.getClass()) {
            return a.equals(b);
        }
        if (a instanceof Number) {
            if (b instanceof Number) {
                return JSONPath.eqNotNull((Number)a, (Number)b);
            }
            return false;
        }
        return a.equals(b);
    }

    static boolean eqNotNull(Number a, Number b) {
        Class<?> clazzA = a.getClass();
        boolean isIntA = JSONPath.isInt(clazzA);
        Class<?> clazzB = b.getClass();
        boolean isIntB = JSONPath.isInt(clazzB);
        if (a instanceof BigDecimal) {
            BigDecimal decimalA = (BigDecimal)a;
            if (isIntB) {
                return decimalA.equals(BigDecimal.valueOf(b.longValue()));
            }
        }
        if (isIntA) {
            if (isIntB) {
                return a.longValue() == b.longValue();
            }
            if (b instanceof BigInteger) {
                BigInteger bigIntB = (BigInteger)a;
                BigInteger bigIntA = BigInteger.valueOf(a.longValue());
                return bigIntA.equals(bigIntB);
            }
        }
        if (isIntB && a instanceof BigInteger) {
            BigInteger bigIntA = (BigInteger)a;
            BigInteger bigIntB = BigInteger.valueOf(b.longValue());
            return bigIntA.equals(bigIntB);
        }
        boolean isDoubleA = JSONPath.isDouble(clazzA);
        boolean isDoubleB = JSONPath.isDouble(clazzB);
        if (isDoubleA && isDoubleB || isDoubleA && isIntB || isDoubleB && isIntA) {
            return a.doubleValue() == b.doubleValue();
        }
        return false;
    }

    protected static boolean isDouble(Class<?> clazzA) {
        return clazzA == Float.class || clazzA == Double.class;
    }

    protected static boolean isInt(Class<?> clazzA) {
        return clazzA == Byte.class || clazzA == Short.class || clazzA == Integer.class || clazzA == Long.class;
    }

    protected Object getPropertyValue(Object currentObject, String propertyName, boolean strictMode) {
        Object e;
        if (currentObject == null) {
            return null;
        }
        if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            Object val = map.get(propertyName);
            if (val == null && "size".equals(propertyName)) {
                val = map.size();
            }
            return val;
        }
        Class<?> currentClass = currentObject.getClass();
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentClass);
        if (beanSerializer != null) {
            try {
                return beanSerializer.getFieldValue(currentObject, propertyName);
            }
            catch (Exception e2) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + propertyName, e2);
            }
        }
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            if ("size".equals(propertyName)) {
                return list.size();
            }
            JSONArray fieldValues = new JSONArray(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                Object itemValue = this.getPropertyValue(obj, propertyName, strictMode);
                fieldValues.add(itemValue);
            }
            return fieldValues;
        }
        if (currentObject instanceof Enum) {
            e = (Enum)currentObject;
            if ("name".equals(propertyName)) {
                return ((Enum)e).name();
            }
            if ("ordinal".equals(propertyName)) {
                return ((Enum)e).ordinal();
            }
        }
        if (currentObject instanceof Calendar) {
            e = (Calendar)currentObject;
            if ("year".equals(propertyName)) {
                return ((Calendar)e).get(1);
            }
            if ("month".equals(propertyName)) {
                return ((Calendar)e).get(2);
            }
            if ("day".equals(propertyName)) {
                return ((Calendar)e).get(5);
            }
            if ("hour".equals(propertyName)) {
                return ((Calendar)e).get(11);
            }
            if ("minute".equals(propertyName)) {
                return ((Calendar)e).get(12);
            }
            if ("second".equals(propertyName)) {
                return ((Calendar)e).get(13);
            }
        }
        throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + propertyName);
    }

    protected void deepScan(Object currentObject, String propertyName, List<Object> results) {
        if (currentObject == null) {
            return;
        }
        if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            if (map.containsKey(propertyName)) {
                Object val = map.get(propertyName);
                results.add(val);
                return;
            }
            for (Object val : map.values()) {
                this.deepScan(val, propertyName, results);
            }
            return;
        }
        Class<?> currentClass = currentObject.getClass();
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentClass);
        if (beanSerializer != null) {
            try {
                FieldSerializer fieldDeser = beanSerializer.getFieldSerializer(propertyName);
                if (fieldDeser != null) {
                    try {
                        Object val = fieldDeser.getPropertyValue(currentObject);
                        results.add(val);
                    }
                    catch (InvocationTargetException ex) {
                        throw new JSONException("getFieldValue error." + propertyName, ex);
                    }
                    catch (IllegalAccessException ex) {
                        throw new JSONException("getFieldValue error." + propertyName, ex);
                    }
                    return;
                }
                List<Object> fieldValues = beanSerializer.getFieldValues(currentObject);
                for (Object val : fieldValues) {
                    this.deepScan(val, propertyName, results);
                }
                return;
            }
            catch (Exception e) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + propertyName, e);
            }
        }
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            for (int i = 0; i < list.size(); ++i) {
                Object val = list.get(i);
                this.deepScan(val, propertyName, results);
            }
            return;
        }
    }

    protected boolean setPropertyValue(Object parent, String name, Object value) {
        if (parent instanceof Map) {
            ((Map)parent).put(name, value);
            return true;
        }
        if (parent instanceof List) {
            for (Object element : (List)parent) {
                if (element == null) continue;
                this.setPropertyValue(element, name, value);
            }
            return true;
        }
        ObjectDeserializer derializer = this.parserConfig.getDeserializer(parent.getClass());
        JavaBeanDeserializer beanDerializer = null;
        if (derializer instanceof JavaBeanDeserializer) {
            beanDerializer = (JavaBeanDeserializer)derializer;
        }
        if (beanDerializer != null) {
            FieldDeserializer fieldDeserializer = beanDerializer.getFieldDeserializer(name);
            if (fieldDeserializer == null) {
                return false;
            }
            fieldDeserializer.setValue(parent, value);
            return true;
        }
        throw new UnsupportedOperationException();
    }

    protected boolean removePropertyValue(Object parent, String name) {
        if (parent instanceof Map) {
            Object origin = ((Map)parent).remove(name);
            return origin != null;
        }
        ObjectDeserializer derializer = this.parserConfig.getDeserializer(parent.getClass());
        JavaBeanDeserializer beanDerializer = null;
        if (derializer instanceof JavaBeanDeserializer) {
            beanDerializer = (JavaBeanDeserializer)derializer;
        }
        if (beanDerializer != null) {
            FieldDeserializer fieldDeserializer = beanDerializer.getFieldDeserializer(name);
            if (fieldDeserializer == null) {
                return false;
            }
            fieldDeserializer.setValue(parent, null);
            return true;
        }
        throw new UnsupportedOperationException();
    }

    protected JavaBeanSerializer getJavaBeanSerializer(Class<?> currentClass) {
        JavaBeanSerializer beanSerializer = null;
        ObjectSerializer serializer = this.serializeConfig.getObjectWriter(currentClass);
        if (serializer instanceof JavaBeanSerializer) {
            beanSerializer = (JavaBeanSerializer)serializer;
        }
        return beanSerializer;
    }

    int evalSize(Object currentObject) {
        if (currentObject == null) {
            return -1;
        }
        if (currentObject instanceof Collection) {
            return ((Collection)currentObject).size();
        }
        if (currentObject instanceof Object[]) {
            return ((Object[])currentObject).length;
        }
        if (currentObject.getClass().isArray()) {
            return Array.getLength(currentObject);
        }
        if (currentObject instanceof Map) {
            int count = 0;
            for (Object value : ((Map)currentObject).values()) {
                if (value == null) continue;
                ++count;
            }
            return count;
        }
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentObject.getClass());
        if (beanSerializer == null) {
            return -1;
        }
        try {
            return beanSerializer.getSize(currentObject);
        }
        catch (Exception e) {
            throw new JSONPathException("evalSize error : " + this.path, e);
        }
    }

    @Override
    public String toJSONString() {
        return JSON.toJSONString(this.path);
    }

    static interface Filter {
        public boolean apply(JSONPath var1, Object var2, Object var3, Object var4);
    }

    public static class FilterSegement
    implements Segement {
        private final Filter filter;

        public FilterSegement(Filter filter) {
            this.filter = filter;
        }

        public Object eval(JSONPath path, Object rootObject, Object currentObject) {
            if (currentObject == null) {
                return null;
            }
            JSONArray items = new JSONArray();
            if (currentObject instanceof Iterable) {
                for (Object item : (Iterable)currentObject) {
                    if (!this.filter.apply(path, rootObject, currentObject, item)) continue;
                    items.add(item);
                }
                return items;
            }
            if (this.filter.apply(path, rootObject, currentObject, currentObject)) {
                return currentObject;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Operator {
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE,
        LIKE,
        NOT_LIKE,
        RLIKE,
        NOT_RLIKE,
        IN,
        NOT_IN,
        BETWEEN,
        NOT_BETWEEN;

    }

    static class StringOpSegement
    implements Filter {
        private final String propertyName;
        private final String value;
        private final Operator op;

        public StringOpSegement(String propertyName, String value, Operator op) {
            this.propertyName = propertyName;
            this.value = value;
            this.op = op;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            if (this.op == Operator.EQ) {
                return this.value.equals(propertyValue);
            }
            if (this.op == Operator.NE) {
                return !this.value.equals(propertyValue);
            }
            if (propertyValue == null) {
                return false;
            }
            int compareResult = this.value.compareTo(propertyValue.toString());
            if (this.op == Operator.GE) {
                return compareResult <= 0;
            }
            if (this.op == Operator.GT) {
                return compareResult < 0;
            }
            if (this.op == Operator.LE) {
                return compareResult >= 0;
            }
            if (this.op == Operator.LT) {
                return compareResult > 0;
            }
            return false;
        }
    }

    static class RlikeSegement
    implements Filter {
        private final String propertyName;
        private final Pattern pattern;
        private final boolean not;

        public RlikeSegement(String propertyName, String pattern, boolean not) {
            this.propertyName = propertyName;
            this.pattern = Pattern.compile(pattern);
            this.not = not;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            if (propertyValue == null) {
                return false;
            }
            String strPropertyValue = propertyValue.toString();
            Matcher m = this.pattern.matcher(strPropertyValue);
            boolean match = m.matches();
            if (this.not) {
                match = !match;
            }
            return match;
        }
    }

    static class MatchSegement
    implements Filter {
        private final String propertyName;
        private final String startsWithValue;
        private final String endsWithValue;
        private final String[] containsValues;
        private final int minLength;
        private final boolean not;

        public MatchSegement(String propertyName, String startsWithValue, String endsWithValue, String[] containsValues, boolean not) {
            this.propertyName = propertyName;
            this.startsWithValue = startsWithValue;
            this.endsWithValue = endsWithValue;
            this.containsValues = containsValues;
            this.not = not;
            int len = 0;
            if (startsWithValue != null) {
                len += startsWithValue.length();
            }
            if (endsWithValue != null) {
                len += endsWithValue.length();
            }
            if (containsValues != null) {
                for (String item : containsValues) {
                    len += item.length();
                }
            }
            this.minLength = len;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            if (propertyValue == null) {
                return false;
            }
            String strPropertyValue = propertyValue.toString();
            if (strPropertyValue.length() < this.minLength) {
                return this.not;
            }
            int start = 0;
            if (this.startsWithValue != null) {
                if (!strPropertyValue.startsWith(this.startsWithValue)) {
                    return this.not;
                }
                start += this.startsWithValue.length();
            }
            if (this.containsValues != null) {
                for (String containsValue : this.containsValues) {
                    int index = strPropertyValue.indexOf(containsValue, start);
                    if (index == -1) {
                        return this.not;
                    }
                    start = index + containsValue.length();
                }
            }
            if (this.endsWithValue != null && !strPropertyValue.endsWith(this.endsWithValue)) {
                return this.not;
            }
            return !this.not;
        }
    }

    static class DoubleOpSegement
    implements Filter {
        private final String propertyName;
        private final double value;
        private final Operator op;

        public DoubleOpSegement(String propertyName, double value, Operator op) {
            this.propertyName = propertyName;
            this.value = value;
            this.op = op;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            if (propertyValue == null) {
                return false;
            }
            if (!(propertyValue instanceof Number)) {
                return false;
            }
            double doubleValue = ((Number)propertyValue).doubleValue();
            if (this.op == Operator.EQ) {
                return doubleValue == this.value;
            }
            if (this.op == Operator.NE) {
                return doubleValue != this.value;
            }
            if (this.op == Operator.GE) {
                return doubleValue >= this.value;
            }
            if (this.op == Operator.GT) {
                return doubleValue > this.value;
            }
            if (this.op == Operator.LE) {
                return doubleValue <= this.value;
            }
            if (this.op == Operator.LT) {
                return doubleValue < this.value;
            }
            return false;
        }
    }

    static class IntOpSegement
    implements Filter {
        private final String propertyName;
        private final long value;
        private final Operator op;

        public IntOpSegement(String propertyName, long value, Operator op) {
            this.propertyName = propertyName;
            this.value = value;
            this.op = op;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            if (propertyValue == null) {
                return false;
            }
            if (!(propertyValue instanceof Number)) {
                return false;
            }
            long longValue = ((Number)propertyValue).longValue();
            if (this.op == Operator.EQ) {
                return longValue == this.value;
            }
            if (this.op == Operator.NE) {
                return longValue != this.value;
            }
            if (this.op == Operator.GE) {
                return longValue >= this.value;
            }
            if (this.op == Operator.GT) {
                return longValue > this.value;
            }
            if (this.op == Operator.LE) {
                return longValue <= this.value;
            }
            if (this.op == Operator.LT) {
                return longValue < this.value;
            }
            return false;
        }
    }

    static class StringInSegement
    implements Filter {
        private final String propertyName;
        private final String[] values;
        private final boolean not;

        public StringInSegement(String propertyName, String[] values, boolean not) {
            this.propertyName = propertyName;
            this.values = values;
            this.not = not;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            for (String value : this.values) {
                if (value == propertyValue) {
                    return !this.not;
                }
                if (value == null || !value.equals(propertyValue)) continue;
                return !this.not;
            }
            return this.not;
        }
    }

    static class IntObjInSegement
    implements Filter {
        private final String propertyName;
        private final Long[] values;
        private final boolean not;

        public IntObjInSegement(String propertyName, Long[] values, boolean not) {
            this.propertyName = propertyName;
            this.values = values;
            this.not = not;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            if (propertyValue == null) {
                for (Long value : this.values) {
                    if (value != null) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (propertyValue instanceof Number) {
                long longPropertyValue = ((Number)propertyValue).longValue();
                for (Long value : this.values) {
                    if (value == null || value != longPropertyValue) continue;
                    return !this.not;
                }
            }
            return this.not;
        }
    }

    static class IntBetweenSegement
    implements Filter {
        private final String propertyName;
        private final long startValue;
        private final long endValue;
        private final boolean not;

        public IntBetweenSegement(String propertyName, long startValue, long endValue, boolean not) {
            this.propertyName = propertyName;
            this.startValue = startValue;
            this.endValue = endValue;
            this.not = not;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            long longPropertyValue;
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            if (propertyValue == null) {
                return false;
            }
            if (propertyValue instanceof Number && (longPropertyValue = ((Number)propertyValue).longValue()) >= this.startValue && longPropertyValue <= this.endValue) {
                return !this.not;
            }
            return this.not;
        }
    }

    static class IntInSegement
    implements Filter {
        private final String propertyName;
        private final long[] values;
        private final boolean not;

        public IntInSegement(String propertyName, long[] values, boolean not) {
            this.propertyName = propertyName;
            this.values = values;
            this.not = not;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            if (propertyValue == null) {
                return false;
            }
            if (propertyValue instanceof Number) {
                long longPropertyValue = ((Number)propertyValue).longValue();
                for (long value : this.values) {
                    if (value != longPropertyValue) continue;
                    return !this.not;
                }
            }
            return this.not;
        }
    }

    static class ValueSegment
    implements Filter {
        private final String propertyName;
        private final Object value;
        private boolean eq = true;

        public ValueSegment(String propertyName, Object value, boolean eq) {
            if (value == null) {
                throw new IllegalArgumentException("value is null");
            }
            this.propertyName = propertyName;
            this.value = value;
            this.eq = eq;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            boolean result = this.value.equals(propertyValue);
            if (!this.eq) {
                result = !result;
            }
            return result;
        }
    }

    static class NullSegement
    implements Filter {
        private final String propertyName;

        public NullSegement(String propertyName) {
            this.propertyName = propertyName;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            return propertyValue == null;
        }
    }

    static class NotNullSegement
    implements Filter {
        private final String propertyName;

        public NotNullSegement(String propertyName) {
            this.propertyName = propertyName;
        }

        public boolean apply(JSONPath path, Object rootObject, Object currentObject, Object item) {
            Object propertyValue = path.getPropertyValue(item, this.propertyName, false);
            return propertyValue != null;
        }
    }

    static class RangeSegement
    implements Segement {
        private final int start;
        private final int end;
        private final int step;

        public RangeSegement(int start, int end, int step) {
            this.start = start;
            this.end = end;
            this.step = step;
        }

        public Object eval(JSONPath path, Object rootObject, Object currentObject) {
            int size = SizeSegement.instance.eval(path, rootObject, currentObject);
            int start = this.start >= 0 ? this.start : this.start + size;
            int end = this.end >= 0 ? this.end : this.end + size;
            ArrayList<Object> items = new ArrayList<Object>((end - start) / this.step + 1);
            for (int i = start; i <= end && i < size; i += this.step) {
                Object item = path.getArrayItem(currentObject, i);
                items.add(item);
            }
            return items;
        }
    }

    static class MultiIndexSegement
    implements Segement {
        private final int[] indexes;

        public MultiIndexSegement(int[] indexes) {
            this.indexes = indexes;
        }

        public Object eval(JSONPath path, Object rootObject, Object currentObject) {
            ArrayList<Object> items = new ArrayList<Object>(this.indexes.length);
            for (int i = 0; i < this.indexes.length; ++i) {
                Object item = path.getArrayItem(currentObject, this.indexes[i]);
                items.add(item);
            }
            return items;
        }
    }

    static class ArrayAccessSegement
    implements Segement {
        private final int index;

        public ArrayAccessSegement(int index) {
            this.index = index;
        }

        public Object eval(JSONPath path, Object rootObject, Object currentObject) {
            return path.getArrayItem(currentObject, this.index);
        }

        public boolean setValue(JSONPath path, Object currentObject, Object value) {
            return path.setArrayItem(path, currentObject, this.index, value);
        }

        public boolean remove(JSONPath path, Object currentObject) {
            return path.removeArrayItem(path, currentObject, this.index);
        }
    }

    static class WildCardSegement
    implements Segement {
        public static WildCardSegement instance = new WildCardSegement();

        WildCardSegement() {
        }

        public Object eval(JSONPath path, Object rootObject, Object currentObject) {
            return path.getPropertyValues(currentObject);
        }
    }

    static class MultiPropertySegement
    implements Segement {
        private final String[] propertyNames;

        public MultiPropertySegement(String[] propertyNames) {
            this.propertyNames = propertyNames;
        }

        public Object eval(JSONPath path, Object rootObject, Object currentObject) {
            ArrayList<Object> fieldValues = new ArrayList<Object>(this.propertyNames.length);
            for (String propertyName : this.propertyNames) {
                Object fieldValue = path.getPropertyValue(currentObject, propertyName, true);
                fieldValues.add(fieldValue);
            }
            return fieldValues;
        }
    }

    static class PropertySegement
    implements Segement {
        private final String propertyName;
        private final boolean deep;

        public PropertySegement(String propertyName, boolean deep) {
            this.propertyName = propertyName;
            this.deep = deep;
        }

        public Object eval(JSONPath path, Object rootObject, Object currentObject) {
            if (this.deep) {
                ArrayList<Object> results = new ArrayList<Object>();
                path.deepScan(currentObject, this.propertyName, results);
                return results;
            }
            return path.getPropertyValue(currentObject, this.propertyName, true);
        }

        public void setValue(JSONPath path, Object parent, Object value) {
            path.setPropertyValue(parent, this.propertyName, value);
        }

        public boolean remove(JSONPath path, Object parent) {
            return path.removePropertyValue(parent, this.propertyName);
        }
    }

    static class SizeSegement
    implements Segement {
        public static final SizeSegement instance = new SizeSegement();

        SizeSegement() {
        }

        public Integer eval(JSONPath path, Object rootObject, Object currentObject) {
            return path.evalSize(currentObject);
        }
    }

    static interface Segement {
        public Object eval(JSONPath var1, Object var2, Object var3);
    }

    static class JSONPathParser {
        private final String path;
        private int pos;
        private char ch;
        private int level;

        public JSONPathParser(String path) {
            this.path = path;
            this.next();
        }

        void next() {
            this.ch = this.path.charAt(this.pos++);
        }

        boolean isEOF() {
            return this.pos >= this.path.length();
        }

        Segement readSegement() {
            if (this.level == 0 && this.path.length() == 1) {
                if (JSONPathParser.isDigitFirst(this.ch)) {
                    int index = this.ch - 48;
                    return new ArrayAccessSegement(index);
                }
                if (this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z') {
                    return new PropertySegement(Character.toString(this.ch), false);
                }
            }
            while (!this.isEOF()) {
                this.skipWhitespace();
                if (this.ch == '$') {
                    this.next();
                    continue;
                }
                if (this.ch == '.' || this.ch == '/') {
                    char c0 = this.ch;
                    boolean deep = false;
                    this.next();
                    if (c0 == '.' && this.ch == '.') {
                        this.next();
                        deep = true;
                    }
                    if (this.ch == '*') {
                        if (!this.isEOF()) {
                            this.next();
                        }
                        return WildCardSegement.instance;
                    }
                    if (JSONPathParser.isDigitFirst(this.ch)) {
                        return this.parseArrayAccess(false);
                    }
                    String propertyName = this.readName();
                    if (this.ch == '(') {
                        this.next();
                        if (this.ch == ')') {
                            if (!this.isEOF()) {
                                this.next();
                            }
                            if ("size".equals(propertyName)) {
                                return SizeSegement.instance;
                            }
                            throw new UnsupportedOperationException();
                        }
                        throw new UnsupportedOperationException();
                    }
                    return new PropertySegement(propertyName, deep);
                }
                if (this.ch == '[') {
                    return this.parseArrayAccess(true);
                }
                if (this.level == 0) {
                    String propertyName = this.readName();
                    return new PropertySegement(propertyName, false);
                }
                throw new UnsupportedOperationException();
            }
            return null;
        }

        public final void skipWhitespace() {
            while (this.ch <= ' ' && (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b')) {
                this.next();
            }
        }

        Segement parseArrayAccess(boolean acceptBracket) {
            if (acceptBracket) {
                this.accept('[');
            }
            boolean predicateFlag = false;
            if (this.ch == '?') {
                this.next();
                this.accept('(');
                if (this.ch == '@') {
                    this.next();
                    this.accept('.');
                }
                predicateFlag = true;
            }
            if (predicateFlag || IOUtils.firstIdentifier(this.ch)) {
                String name;
                String propertyName = this.readName();
                this.skipWhitespace();
                if (predicateFlag && this.ch == ')') {
                    this.next();
                    if (acceptBracket) {
                        this.accept(']');
                    }
                    return new FilterSegement(new NotNullSegement(propertyName));
                }
                if (acceptBracket && this.ch == ']') {
                    this.next();
                    return new FilterSegement(new NotNullSegement(propertyName));
                }
                Operator op = this.readOp();
                this.skipWhitespace();
                if (op == Operator.BETWEEN || op == Operator.NOT_BETWEEN) {
                    boolean not = op == Operator.NOT_BETWEEN;
                    Object startValue = this.readValue();
                    String name2 = this.readName();
                    if (!"and".equalsIgnoreCase(name2)) {
                        throw new JSONPathException(this.path);
                    }
                    Object endValue = this.readValue();
                    if (startValue == null || endValue == null) {
                        throw new JSONPathException(this.path);
                    }
                    if (JSONPath.isInt(startValue.getClass()) && JSONPath.isInt(endValue.getClass())) {
                        IntBetweenSegement filter = new IntBetweenSegement(propertyName, ((Number)startValue).longValue(), ((Number)endValue).longValue(), not);
                        return new FilterSegement(filter);
                    }
                    throw new JSONPathException(this.path);
                }
                if (op == Operator.IN || op == Operator.NOT_IN) {
                    Object[] values;
                    boolean not = op == Operator.NOT_IN;
                    this.accept('(');
                    JSONArray valueList = new JSONArray();
                    Object value = this.readValue();
                    valueList.add(value);
                    while (true) {
                        this.skipWhitespace();
                        if (this.ch != ',') break;
                        this.next();
                        value = this.readValue();
                        valueList.add(value);
                    }
                    this.accept(')');
                    if (predicateFlag) {
                        this.accept(')');
                    }
                    if (acceptBracket) {
                        this.accept(']');
                    }
                    boolean isInt = true;
                    boolean isIntObj = true;
                    boolean isString = true;
                    for (Object item : valueList) {
                        if (item == null) {
                            if (!isInt) continue;
                            isInt = false;
                            continue;
                        }
                        Class<?> clazz = item.getClass();
                        if (isInt && clazz != Byte.class && clazz != Short.class && clazz != Integer.class && clazz != Long.class) {
                            isInt = false;
                            isIntObj = false;
                        }
                        if (!isString || clazz == String.class) continue;
                        isString = false;
                    }
                    if (valueList.size() == 1 && valueList.get(0) == null) {
                        if (not) {
                            return new FilterSegement(new NotNullSegement(propertyName));
                        }
                        return new FilterSegement(new NullSegement(propertyName));
                    }
                    if (isInt) {
                        if (valueList.size() == 1) {
                            long value2 = ((Number)valueList.get(0)).longValue();
                            Operator intOp = not ? Operator.NE : Operator.EQ;
                            return new FilterSegement(new IntOpSegement(propertyName, value2, intOp));
                        }
                        values = new long[valueList.size()];
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = ((Number)valueList.get(i)).longValue();
                        }
                        return new FilterSegement(new IntInSegement(propertyName, (long[])values, not));
                    }
                    if (isString) {
                        if (valueList.size() == 1) {
                            String value3 = (String)valueList.get(0);
                            Operator intOp = not ? Operator.NE : Operator.EQ;
                            return new FilterSegement(new StringOpSegement(propertyName, value3, intOp));
                        }
                        values = new String[valueList.size()];
                        valueList.toArray(values);
                        return new FilterSegement(new StringInSegement(propertyName, (String[])values, not));
                    }
                    if (isIntObj) {
                        values = new Long[valueList.size()];
                        for (int i = 0; i < values.length; ++i) {
                            Number item = (Number)valueList.get(i);
                            if (item == null) continue;
                            values[i] = item.longValue();
                        }
                        return new FilterSegement(new IntObjInSegement(propertyName, (Long[])values, not));
                    }
                    throw new UnsupportedOperationException();
                }
                if (this.ch == '\'' || this.ch == '\"') {
                    String strValue = this.readString();
                    if (predicateFlag) {
                        this.accept(')');
                    }
                    if (acceptBracket) {
                        this.accept(']');
                    }
                    if (op == Operator.RLIKE) {
                        return new FilterSegement(new RlikeSegement(propertyName, strValue, false));
                    }
                    if (op == Operator.NOT_RLIKE) {
                        return new FilterSegement(new RlikeSegement(propertyName, strValue, true));
                    }
                    if (op == Operator.LIKE || op == Operator.NOT_LIKE) {
                        while (strValue.indexOf("%%") != -1) {
                            strValue = strValue.replaceAll("%%", "%");
                        }
                        boolean not = op == Operator.NOT_LIKE;
                        int p0 = strValue.indexOf(37);
                        if (p0 == -1) {
                            op = op == Operator.LIKE ? Operator.EQ : Operator.NE;
                        } else {
                            String[] items = strValue.split("%");
                            String startsWithValue = null;
                            String endsWithValue = null;
                            String[] containsValues = null;
                            if (p0 == 0) {
                                if (strValue.charAt(strValue.length() - 1) == '%') {
                                    containsValues = new String[items.length - 1];
                                    System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                                } else {
                                    endsWithValue = items[items.length - 1];
                                    if (items.length > 2) {
                                        containsValues = new String[items.length - 2];
                                        System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                                    }
                                }
                            } else if (strValue.charAt(strValue.length() - 1) == '%') {
                                containsValues = items;
                            } else if (items.length == 1) {
                                startsWithValue = items[0];
                            } else if (items.length == 2) {
                                startsWithValue = items[0];
                                endsWithValue = items[1];
                            } else {
                                startsWithValue = items[0];
                                endsWithValue = items[items.length - 1];
                                containsValues = new String[items.length - 2];
                                System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                            }
                            return new FilterSegement(new MatchSegement(propertyName, startsWithValue, endsWithValue, containsValues, not));
                        }
                    }
                    return new FilterSegement(new StringOpSegement(propertyName, strValue, op));
                }
                if (JSONPathParser.isDigitFirst(this.ch)) {
                    long value = this.readLongValue();
                    double doubleValue = 0.0;
                    if (this.ch == '.') {
                        doubleValue = this.readDoubleValue(value);
                    }
                    if (predicateFlag) {
                        this.accept(')');
                    }
                    if (acceptBracket) {
                        this.accept(']');
                    }
                    if (doubleValue == 0.0) {
                        return new FilterSegement(new IntOpSegement(propertyName, value, op));
                    }
                    return new FilterSegement(new DoubleOpSegement(propertyName, doubleValue, op));
                }
                if (this.ch == 'n') {
                    String name3 = this.readName();
                    if ("null".equals(name3)) {
                        if (predicateFlag) {
                            this.accept(')');
                        }
                        this.accept(']');
                        if (op == Operator.EQ) {
                            return new FilterSegement(new NullSegement(propertyName));
                        }
                        if (op == Operator.NE) {
                            return new FilterSegement(new NotNullSegement(propertyName));
                        }
                        throw new UnsupportedOperationException();
                    }
                } else if (this.ch == 't') {
                    String name4 = this.readName();
                    if ("true".equals(name4)) {
                        if (predicateFlag) {
                            this.accept(')');
                        }
                        this.accept(']');
                        if (op == Operator.EQ) {
                            return new FilterSegement(new ValueSegment(propertyName, Boolean.TRUE, true));
                        }
                        if (op == Operator.NE) {
                            return new FilterSegement(new ValueSegment(propertyName, Boolean.TRUE, false));
                        }
                        throw new UnsupportedOperationException();
                    }
                } else if (this.ch == 'f' && "false".equals(name = this.readName())) {
                    if (predicateFlag) {
                        this.accept(')');
                    }
                    this.accept(']');
                    if (op == Operator.EQ) {
                        return new FilterSegement(new ValueSegment(propertyName, Boolean.FALSE, true));
                    }
                    if (op == Operator.NE) {
                        return new FilterSegement(new ValueSegment(propertyName, Boolean.FALSE, false));
                    }
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
            int start = this.pos - 1;
            while (this.ch != ']' && this.ch != '/' && !this.isEOF() && (this.ch != '.' || predicateFlag || predicateFlag)) {
                if (this.ch == '\\') {
                    this.next();
                }
                this.next();
            }
            int end = acceptBracket ? this.pos - 1 : (this.ch == '/' || this.ch == '.' ? this.pos - 1 : this.pos);
            String text = this.path.substring(start, end);
            if (text.indexOf("\\.") != -1) {
                String propName = text.replaceAll("\\\\\\.", "\\.");
                return new PropertySegement(propName, false);
            }
            Segement segment = this.buildArraySegement(text);
            if (acceptBracket && !this.isEOF()) {
                this.accept(']');
            }
            return segment;
        }

        protected long readLongValue() {
            int beginIndex = this.pos - 1;
            if (this.ch == '+' || this.ch == '-') {
                this.next();
            }
            while (this.ch >= '0' && this.ch <= '9') {
                this.next();
            }
            int endIndex = this.pos - 1;
            String text = this.path.substring(beginIndex, endIndex);
            long value = Long.parseLong(text);
            return value;
        }

        protected double readDoubleValue(long longValue) {
            int beginIndex = this.pos - 1;
            this.next();
            while (this.ch >= '0' && this.ch <= '9') {
                this.next();
            }
            int endIndex = this.pos - 1;
            String text = this.path.substring(beginIndex, endIndex);
            double value = Double.parseDouble(text);
            return value += (double)longValue;
        }

        protected Object readValue() {
            this.skipWhitespace();
            if (JSONPathParser.isDigitFirst(this.ch)) {
                return this.readLongValue();
            }
            if (this.ch == '\"' || this.ch == '\'') {
                return this.readString();
            }
            if (this.ch == 'n') {
                String name = this.readName();
                if ("null".equals(name)) {
                    return null;
                }
                throw new JSONPathException(this.path);
            }
            throw new UnsupportedOperationException();
        }

        static boolean isDigitFirst(char ch) {
            return ch == '-' || ch == '+' || ch >= '0' && ch <= '9';
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Operator readOp() {
            Operator op = null;
            if (this.ch == '=') {
                this.next();
                op = Operator.EQ;
            } else if (this.ch == '!') {
                this.next();
                this.accept('=');
                op = Operator.NE;
            } else if (this.ch == '<') {
                this.next();
                if (this.ch == '=') {
                    this.next();
                    op = Operator.LE;
                } else {
                    op = Operator.LT;
                }
            } else if (this.ch == '>') {
                this.next();
                if (this.ch == '=') {
                    this.next();
                    op = Operator.GE;
                } else {
                    op = Operator.GT;
                }
            }
            if (op != null) return op;
            String name = this.readName();
            if ("not".equalsIgnoreCase(name)) {
                this.skipWhitespace();
                name = this.readName();
                if ("like".equalsIgnoreCase(name)) {
                    return Operator.NOT_LIKE;
                }
                if ("rlike".equalsIgnoreCase(name)) {
                    return Operator.NOT_RLIKE;
                }
                if ("in".equalsIgnoreCase(name)) {
                    return Operator.NOT_IN;
                }
                if (!"between".equalsIgnoreCase(name)) throw new UnsupportedOperationException();
                return Operator.NOT_BETWEEN;
            }
            if ("like".equalsIgnoreCase(name)) {
                return Operator.LIKE;
            }
            if ("rlike".equalsIgnoreCase(name)) {
                return Operator.RLIKE;
            }
            if ("in".equalsIgnoreCase(name)) {
                return Operator.IN;
            }
            if (!"between".equalsIgnoreCase(name)) throw new UnsupportedOperationException();
            return Operator.BETWEEN;
        }

        String readName() {
            this.skipWhitespace();
            if (this.ch != '\\' && !IOUtils.firstIdentifier(this.ch)) {
                throw new JSONPathException("illeal jsonpath syntax. " + this.path);
            }
            StringBuilder buf = new StringBuilder();
            while (!this.isEOF()) {
                if (this.ch == '\\') {
                    this.next();
                    buf.append(this.ch);
                    if (this.isEOF()) break;
                    this.next();
                    continue;
                }
                boolean identifierFlag = IOUtils.isIdent(this.ch);
                if (!identifierFlag) break;
                buf.append(this.ch);
                this.next();
            }
            if (this.isEOF() && IOUtils.isIdent(this.ch)) {
                buf.append(this.ch);
            }
            String propertyName = buf.toString();
            return propertyName;
        }

        String readString() {
            char quoate = this.ch;
            this.next();
            int beginIndex = this.pos - 1;
            while (this.ch != quoate && !this.isEOF()) {
                this.next();
            }
            String strValue = this.path.substring(beginIndex, this.isEOF() ? this.pos : this.pos - 1);
            this.accept(quoate);
            return strValue;
        }

        void accept(char expect) {
            if (this.ch != expect) {
                throw new JSONPathException("expect '" + expect + ", but '" + this.ch + "'");
            }
            if (!this.isEOF()) {
                this.next();
            }
        }

        public Segement[] explain() {
            Segement segment;
            if (this.path == null || this.path.isEmpty()) {
                throw new IllegalArgumentException();
            }
            Segement[] segements = new Segement[8];
            while ((segment = this.readSegement()) != null) {
                if (this.level == segements.length) {
                    Segement[] t = new Segement[this.level * 3 / 2];
                    System.arraycopy(segements, 0, t, 0, this.level);
                    segements = t;
                }
                segements[this.level++] = segment;
            }
            if (this.level == segements.length) {
                return segements;
            }
            Segement[] result = new Segement[this.level];
            System.arraycopy(segements, 0, result, 0, this.level);
            return result;
        }

        Segement buildArraySegement(String indexText) {
            int indexTextLen = indexText.length();
            char firstChar = indexText.charAt(0);
            char lastChar = indexText.charAt(indexTextLen - 1);
            int commaIndex = indexText.indexOf(44);
            if (indexText.length() > 2 && firstChar == '\'' && lastChar == '\'') {
                if (commaIndex == -1) {
                    String propertyName = indexText.substring(1, indexTextLen - 1);
                    return new PropertySegement(propertyName, false);
                }
                String[] indexesText = indexText.split(",");
                String[] propertyNames = new String[indexesText.length];
                for (int i = 0; i < indexesText.length; ++i) {
                    String indexesTextItem = indexesText[i];
                    propertyNames[i] = indexesTextItem.substring(1, indexesTextItem.length() - 1);
                }
                return new MultiPropertySegement(propertyNames);
            }
            int colonIndex = indexText.indexOf(58);
            if (commaIndex == -1 && colonIndex == -1) {
                int index = Integer.parseInt(indexText);
                return new ArrayAccessSegement(index);
            }
            if (commaIndex != -1) {
                String[] indexesText = indexText.split(",");
                int[] indexes = new int[indexesText.length];
                for (int i = 0; i < indexesText.length; ++i) {
                    indexes[i] = Integer.parseInt(indexesText[i]);
                }
                return new MultiIndexSegement(indexes);
            }
            if (colonIndex != -1) {
                String[] indexesText = indexText.split(":");
                int[] indexes = new int[indexesText.length];
                for (int i = 0; i < indexesText.length; ++i) {
                    String str = indexesText[i];
                    if (str.isEmpty()) {
                        if (i == 0) {
                            indexes[i] = 0;
                            continue;
                        }
                        throw new UnsupportedOperationException();
                    }
                    indexes[i] = Integer.parseInt(str);
                }
                int start = indexes[0];
                int end = indexes.length > 1 ? indexes[1] : -1;
                int step = indexes.length == 3 ? indexes[2] : 1;
                if (end >= 0 && end < start) {
                    throw new UnsupportedOperationException("end must greater than or equals start. start " + start + ",  end " + end);
                }
                if (step <= 0) {
                    throw new UnsupportedOperationException("step must greater than zero : " + step);
                }
                return new RangeSegement(start, end, step);
            }
            throw new UnsupportedOperationException();
        }
    }
}

