/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.sift.scale;

import com.alibaba.simpleimage.analyze.kdtree.IKDTreeDomain;
import com.alibaba.simpleimage.analyze.sift.scale.FeaturePoint;

public class KDFeaturePoint
extends IKDTreeDomain
implements Cloneable {
    private static final long serialVersionUID = 814942706491557514L;
    public float x;
    public float y;
    public float scale;
    public float orientation;

    public KDFeaturePoint() {
    }

    public KDFeaturePoint(FeaturePoint fp) {
        if (!fp.hasFeatures) {
            throw new IllegalArgumentException("While trying to generate integer vector: source FeaturePoint has no feature vector yet");
        }
        this.x = fp.x;
        this.y = fp.y;
        this.scale = fp.scale;
        this.orientation = fp.orientation;
        this.dim = fp.features.length;
        this.descriptor = new int[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            this.descriptor[d] = (int)(255.0 * (double)fp.features[d]);
            if (this.descriptor[d] >= 0 && this.descriptor[d] <= 255) continue;
            throw new IllegalArgumentException("Resulting integer descriptor k is not 0 <= k <= 255");
        }
    }

    public KDFeaturePoint clone() {
        KDFeaturePoint other = new KDFeaturePoint();
        other.dim = this.dim;
        other.x = this.x;
        other.y = this.y;
        other.scale = this.scale;
        other.orientation = this.orientation;
        other.descriptor = new int[this.dim];
        System.arraycopy(this.descriptor, 0, other.descriptor, 0, this.dim);
        return other;
    }
}

