/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.io;

import com.alibaba.simpleimage.codec.jpeg.JPEGMarkerException;
import com.alibaba.simpleimage.io.ImageInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ImageBitsInputStream
implements ImageInputStream {
    private InputStream in;
    private int b = 0;
    private int cnt = 0;

    public ImageBitsInputStream(InputStream input) {
        this.in = input;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        this.cnt = 0;
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.cnt = 0;
        return this.in.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        this.cnt = 0;
        return this.in.read(b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readBit() throws IOException, JPEGMarkerException {
        int bit = 0;
        if (this.cnt == 0) {
            this.b = this.in.read();
            this.cnt = 8;
            if (this.b == 255) {
                do {
                    this.b = this.in.read();
                } while (this.b == 255);
                if (this.b != 0) throw new JPEGMarkerException(this.b);
                this.b = 255;
                this.cnt = 8;
            } else if (this.b == -1) {
                throw new JPEGMarkerException(this.b);
            }
        }
        bit = this.b >> 7;
        --this.cnt;
        this.b <<= 1;
        return bit & 1;
    }

    public long readBits(int bit) throws IOException, JPEGMarkerException {
        if (bit < 0) {
            throw new IllegalArgumentException("bit must be greater than zero");
        }
        int v = 0;
        for (int i = 0; i != bit; ++i) {
            v = v << 1 | this.readBit();
        }
        return v;
    }

    public int skipBytes(int n) throws IOException {
        int total;
        this.cnt = 0;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)this.in.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        this.cnt = 0;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public short readShort() throws IOException {
        int ch2;
        this.cnt = 0;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public byte readByte() throws IOException {
        this.cnt = 0;
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public void resetBuffer() throws IOException {
        this.cnt = 0;
    }
}

