/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.font.FontManager;
import com.alibaba.simpleimage.render.DrawTextItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import org.apache.commons.lang.StringUtils;

public class FootnoteDrawTextItem
extends DrawTextItem {
    static final Color FONT_COLOR = new Color(255, 255, 255, 153);
    static final Color FONT_SHADOW_COLOR = new Color(170, 170, 170, 115);
    static final Font DEFAULT_COMPANY_NAME_FONT = FontManager.getFont("\u65b9\u6b63\u9ed1\u4f53");
    static final Font DEFAULT_DOMAIN_NAME_FONT = new Font("Arial", 0, 10);
    static final float TEXT_WIDTH_PERCENT = 0.8f;
    static final int MIN_FONT_SIZE = 10;
    protected float textWidthPercent;
    protected Font domainFont;
    protected String domainName;

    public FootnoteDrawTextItem(String text, String domainName) {
        super(text, FONT_COLOR, FONT_SHADOW_COLOR, DEFAULT_COMPANY_NAME_FONT, 10);
        this.domainName = domainName;
        this.textWidthPercent = 0.8f;
        this.domainFont = DEFAULT_DOMAIN_NAME_FONT;
    }

    public FootnoteDrawTextItem(String text, String domainName, float textWidthPercent, Font domainNameFont) {
        super(text, FONT_COLOR, FONT_SHADOW_COLOR, DEFAULT_COMPANY_NAME_FONT, 10);
        this.domainName = domainName;
        this.textWidthPercent = textWidthPercent;
        this.domainFont = domainNameFont;
    }

    public FootnoteDrawTextItem(String text, String domainName, Color fontColor, Color fontShadowColor, Font font, Font domainFont, int minFontSize, float textWidthPercent) {
        super(text, fontColor, fontShadowColor, font, minFontSize);
        this.domainName = domainName;
        this.domainFont = domainFont;
        this.textWidthPercent = textWidthPercent;
    }

    public void drawText(Graphics2D graphics, int width, int height) {
        if (StringUtils.isBlank((String)this.text) || StringUtils.isBlank((String)this.domainName)) {
            return;
        }
        int x = 0;
        int y = 0;
        int fontsize = (int)((float)width * this.textWidthPercent) / this.domainName.length();
        if (fontsize < this.minFontSize) {
            return;
        }
        float fsize = fontsize;
        Font font = this.domainFont.deriveFont(fsize);
        graphics.setFont(font);
        FontRenderContext context = graphics.getFontRenderContext();
        int sw = (int)font.getStringBounds(this.domainName, context).getWidth();
        x = width - sw - fontsize;
        y = height - fontsize;
        if (x <= 0 || y <= 0) {
            return;
        }
        if (this.fontShadowColor != null) {
            graphics.setColor(this.fontShadowColor);
            graphics.drawString(this.domainName, x + this.getShadowTranslation(fontsize), y + this.getShadowTranslation(fontsize));
        }
        graphics.setColor(this.fontColor);
        graphics.drawString(this.domainName, x, y);
        fsize = fontsize;
        font = this.defaultFont.deriveFont(fsize);
        graphics.setFont(font);
        context = graphics.getFontRenderContext();
        sw = (int)font.getStringBounds(this.text, context).getWidth();
        x = width - sw - fontsize;
        y = height - (int)((double)fontsize * 2.5);
        if (x <= 0 || y <= 0) {
            return;
        }
        if (this.fontShadowColor != null) {
            graphics.setColor(this.fontShadowColor);
            graphics.drawString(this.text, x + this.getShadowTranslation(fontsize), y + this.getShadowTranslation(fontsize));
        }
        graphics.setColor(this.fontColor);
        graphics.drawString(this.text, x, y);
    }

    public float getTextWidthPercent() {
        return this.textWidthPercent;
    }

    public Font getDomainFont() {
        return this.domainFont;
    }

    public void setTextWidthPercent(float textWidthPercent) {
        this.textWidthPercent = textWidthPercent;
    }

    public void setDomainFont(Font domainFont) {
        this.domainFont = domainFont;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }
}

