/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.sift.scale;

import com.alibaba.simpleimage.analyze.RefFloat;
import com.alibaba.simpleimage.analyze.sift.FloatArray;
import com.alibaba.simpleimage.analyze.sift.ImagePixelArray;
import com.alibaba.simpleimage.analyze.sift.scale.FeaturePoint;
import com.alibaba.simpleimage.analyze.sift.scale.GaussianArray;
import com.alibaba.simpleimage.analyze.sift.scale.ScalePeak;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OctaveSpace {
    OctaveSpace down;
    OctaveSpace up;
    ImagePixelArray baseImg;
    public float baseScale;
    public ImagePixelArray[] smoothedImgs;
    public ImagePixelArray[] diffImags;
    private ImagePixelArray[] magnitudes;
    private ImagePixelArray[] directions;

    public ImagePixelArray getLastGaussianImg() {
        if (this.smoothedImgs.length < 2) {
            throw new IllegalArgumentException("err: too few gaussian maps.");
        }
        return this.smoothedImgs[this.smoothedImgs.length - 2];
    }

    public void makeGaussianImgs(ImagePixelArray base, float baseScale, int scales, float sigma) {
        this.smoothedImgs = new ImagePixelArray[scales + 3];
        this.baseScale = baseScale;
        ImagePixelArray prev = base;
        this.smoothedImgs[0] = base;
        float w = sigma;
        float kTerm = (float)Math.sqrt(Math.pow(Math.pow(2.0, 1.0 / (double)scales), 2.0) - 1.0);
        for (int i = 1; i < this.smoothedImgs.length; ++i) {
            GaussianArray gauss = new GaussianArray(w * kTerm);
            prev = this.smoothedImgs[i] = gauss.convolve(prev);
            w = (float)((double)w * Math.pow(2.0, 1.0 / (double)scales));
        }
    }

    public void makeGaussianDiffImgs() {
        this.diffImags = new ImagePixelArray[this.smoothedImgs.length - 1];
        for (int sn = 0; sn < this.diffImags.length; ++sn) {
            this.diffImags[sn] = ImagePixelArray.minus(this.smoothedImgs[sn + 1], this.smoothedImgs[sn]);
        }
    }

    public ArrayList<ScalePeak> findPeaks(float dogThresh) {
        ArrayList<ScalePeak> peaks = new ArrayList<ScalePeak>();
        for (int level = 1; level < this.diffImags.length - 1; ++level) {
            ImagePixelArray current = this.diffImags[level];
            ImagePixelArray below = this.diffImags[level - 1];
            ImagePixelArray above = this.diffImags[level + 1];
            peaks.addAll(this.findPeaks4ThreeLayer(below, current, above, level, dogThresh));
            below = current;
        }
        return peaks;
    }

    public ArrayList<ScalePeak> filterAndLocalizePeaks(ArrayList<ScalePeak> peaks, float maximumEdgeRatio, float dValueLowThresh, float scaleAdjustThresh, int relocationMaximum) {
        ArrayList<ScalePeak> filtered = new ArrayList<ScalePeak>();
        int[][] processedMap = new int[this.diffImags[0].width][this.diffImags[0].height];
        for (ScalePeak peak : peaks) {
            if (this.isTooEdgelike(this.diffImags[peak.level], peak.x, peak.y, maximumEdgeRatio) || this.localizeIsWeak(peak, relocationMaximum, processedMap) || Math.abs(peak.local.scaleAdjust) > scaleAdjustThresh || Math.abs(peak.local.dValue) <= dValueLowThresh) continue;
            filtered.add(peak);
        }
        return filtered;
    }

    public void pretreatMagnitudeAndDirectionImgs() {
        this.magnitudes = new ImagePixelArray[this.smoothedImgs.length - 1];
        this.directions = new ImagePixelArray[this.smoothedImgs.length - 1];
        for (int s = 1; s < this.smoothedImgs.length - 1; ++s) {
            this.magnitudes[s] = new ImagePixelArray(this.smoothedImgs[s].width, this.smoothedImgs[s].height);
            this.directions[s] = new ImagePixelArray(this.smoothedImgs[s].width, this.smoothedImgs[s].height);
            int w = this.smoothedImgs[s].width;
            int h = this.smoothedImgs[s].height;
            for (int y = 1; y < h - 1; ++y) {
                for (int x = 1; x < w - 1; ++x) {
                    this.magnitudes[s].data[y * w + x] = (float)Math.sqrt(Math.pow(this.smoothedImgs[s].data[y * w + x + 1] - this.smoothedImgs[s].data[y * w + x - 1], 2.0) + Math.pow(this.smoothedImgs[s].data[(y + 1) * w + x] - this.smoothedImgs[s].data[(y - 1) * w + x], 2.0));
                    this.directions[s].data[y * w + x] = (float)Math.atan2(this.smoothedImgs[s].data[(y + 1) * w + x] - this.smoothedImgs[s].data[(y - 1) * w + x], this.smoothedImgs[s].data[y * w + x + 1] - this.smoothedImgs[s].data[y * w + x - 1]);
                }
            }
        }
    }

    public ArrayList<FeaturePoint> makeFeaturePoints(ArrayList<ScalePeak> localizedPeaks, float peakRelThresh, int scaleCount, float octaveSigma) {
        ArrayList<FeaturePoint> featurePoints = new ArrayList<FeaturePoint>();
        for (ScalePeak sp : localizedPeaks) {
            ArrayList<FeaturePoint> thisPointKeys = this.makeFeaturePoint(this.baseScale, sp, peakRelThresh, scaleCount, octaveSigma);
            thisPointKeys = this.createDescriptors(thisPointKeys, this.magnitudes[sp.level], this.directions[sp.level], 2.0f, 4, 8, 0.2f);
            for (FeaturePoint fp : thisPointKeys) {
                if (!fp.hasFeatures) {
                    throw new IllegalStateException("should not happen");
                }
                fp.x *= fp.imgScale;
                fp.y *= fp.imgScale;
                fp.scale *= fp.imgScale;
                featurePoints.add(fp);
            }
        }
        return featurePoints;
    }

    public void clear() {
        int i;
        for (i = 0; i < this.magnitudes.length; ++i) {
            this.magnitudes[i] = null;
        }
        for (i = 0; i < this.directions.length; ++i) {
            this.directions[i] = null;
        }
        this.directions = null;
        this.magnitudes = null;
    }

    private ArrayList<FeaturePoint> makeFeaturePoint(float imgScale, ScalePeak point, float peakRelThresh, int scaleCount, float octaveSigma) {
        float fpScale = (float)((double)octaveSigma * Math.pow(2.0, ((float)point.level + point.local.scaleAdjust) / (float)scaleCount));
        float sigma = 3.0f * fpScale;
        int radius = (int)(3.0 * (double)sigma / 2.0 + 0.5);
        int radiusSq = radius * radius;
        ImagePixelArray magnitude = this.magnitudes[point.level];
        ImagePixelArray direction = this.directions[point.level];
        int xMin = Math.max(point.x - radius, 1);
        int xMax = Math.min(point.x + radius, magnitude.width - 1);
        int yMin = Math.max(point.y - radius, 1);
        int yMax = Math.min(point.y + radius, magnitude.height - 1);
        float gaussianSigmaFactor = 2.0f * sigma * sigma;
        float[] boxes = new float[36];
        for (int y = yMin; y < yMax; ++y) {
            for (int x = xMin; x < xMax; ++x) {
                int boxIdx;
                int relX = x - point.x;
                int relY = y - point.y;
                if (relX * relX + relY * relY > radiusSq) continue;
                float gaussianWeight = (float)Math.exp(-((float)(relX * relX + relY * relY) / gaussianSigmaFactor));
                int n = boxIdx = this.findClosestRotationBox(direction.data[y * direction.width + x]);
                boxes[n] = boxes[n] + magnitude.data[y * magnitude.width + x] * gaussianWeight;
            }
        }
        this.averageBoxes(boxes);
        float maxGrad = 0.0f;
        int maxBox = 0;
        for (int b = 0; b < 36; ++b) {
            if (!(boxes[b] > maxGrad)) continue;
            maxGrad = boxes[b];
            maxBox = b;
        }
        RefPeakValueAndDegreeCorrection ref1 = new RefPeakValueAndDegreeCorrection();
        this.interpolateOrientation(boxes[maxBox == 0 ? 35 : maxBox - 1], boxes[maxBox], boxes[(maxBox + 1) % 36], ref1);
        boolean[] boxIsFeaturePoint = new boolean[36];
        for (int b = 0; b < 36; ++b) {
            boxIsFeaturePoint[b] = false;
            if (b == maxBox) {
                boxIsFeaturePoint[b] = true;
                continue;
            }
            if (boxes[b] < peakRelThresh * ref1.peakValue) continue;
            int leftI = b == 0 ? 35 : b - 1;
            int rightI = (b + 1) % 36;
            if (boxes[b] <= boxes[leftI] || boxes[b] <= boxes[rightI]) continue;
            boxIsFeaturePoint[b] = true;
        }
        ArrayList<FeaturePoint> featurePoints = new ArrayList<FeaturePoint>();
        float oneBoxRad = 0.17453294f;
        for (int b = 0; b < 36; ++b) {
            RefPeakValueAndDegreeCorrection ref2;
            int bRight;
            if (!boxIsFeaturePoint[b]) continue;
            int bLeft = b == 0 ? 35 : b - 1;
            if (!this.interpolateOrientation(boxes[bLeft], boxes[b], boxes[bRight = (b + 1) % 36], ref2 = new RefPeakValueAndDegreeCorrection())) {
                throw new IllegalStateException("BUG: Parabola fitting broken");
            }
            float degree = (float)((double)(((float)b + ref2.degreeCorrection) * oneBoxRad) - Math.PI);
            if ((double)degree < -Math.PI) {
                degree = (float)((double)degree + Math.PI * 2);
            } else if ((double)degree > Math.PI) {
                degree = (float)((double)degree - Math.PI * 2);
            }
            FeaturePoint fp = new FeaturePoint(this.smoothedImgs[point.level], (float)point.x + point.local.fineX, (float)point.y + point.local.fineY, imgScale, fpScale, degree);
            featurePoints.add(fp);
        }
        return featurePoints;
    }

    private boolean interpolateOrientation(float left, float middle, float right, RefPeakValueAndDegreeCorrection ref) {
        float a = (left + right - 2.0f * middle) / 2.0f;
        ref.peakValue = Float.NaN;
        ref.degreeCorrection = Float.NaN;
        if ((double)a == 0.0) {
            return false;
        }
        float c = ((left - middle) / a - 1.0f) / 2.0f;
        float b = middle - c * c * a;
        if ((double)c < -0.5 || (double)c > 0.5) {
            throw new IllegalStateException("InterpolateOrientation: off peak ]-0.5 ; 0.5[");
        }
        ref.degreeCorrection = c;
        ref.peakValue = b;
        return true;
    }

    private void averageBoxes(float[] boxes) {
        for (int sn = 0; sn < 4; ++sn) {
            float first = boxes[0];
            float last = boxes[boxes.length - 1];
            for (int sw = 0; sw < boxes.length; ++sw) {
                float cur = boxes[sw];
                float next = sw == boxes.length - 1 ? first : boxes[(sw + 1) % boxes.length];
                boxes[sw] = (last + cur + next) / 3.0f;
                last = cur;
            }
        }
    }

    private int findClosestRotationBox(float angle) {
        angle = (float)((double)angle + Math.PI);
        angle = (float)((double)angle / (Math.PI * 2));
        int idx = (int)(angle *= 36.0f);
        if (idx == 36) {
            idx = 0;
        }
        return idx;
    }

    private ArrayList<FeaturePoint> createDescriptors(ArrayList<FeaturePoint> featurePoints, ImagePixelArray magnitude, ImagePixelArray direction, float considerScaleFactor, int descDim, int directionCount, float fvGradHicap) {
        if (featurePoints.size() <= 0) {
            return featurePoints;
        }
        float dDim05 = (float)descDim / 2.0f;
        int radius = (int)(((double)descDim + 1.0) / 2.0 * Math.sqrt(2.0) * (double)(considerScaleFactor *= featurePoints.get((int)0).scale) + 0.5);
        ArrayList<FeaturePoint> survivors = new ArrayList<FeaturePoint>();
        float sigma2Sq = 2.0f * dDim05 * dDim05;
        for (FeaturePoint fp : featurePoints) {
            float angle = -fp.orientation;
            fp.createVector(descDim, descDim, directionCount);
            for (int y = -radius; y < radius; ++y) {
                for (int x = -radius; x < radius; ++x) {
                    float idxDir;
                    float dir;
                    float yR = (float)(Math.sin(angle) * (double)x + Math.cos(angle) * (double)y);
                    float xR = (float)(Math.cos(angle) * (double)x - Math.sin(angle) * (double)y);
                    if ((double)(yR /= considerScaleFactor) >= (double)dDim05 + 0.5 || (double)(xR /= considerScaleFactor) >= (double)dDim05 + 0.5 || (double)xR <= -((double)dDim05 + 0.5) || (double)yR <= -((double)dDim05 + 0.5)) continue;
                    int currentX = (int)((double)((float)x + fp.x) + 0.5);
                    int currentY = (int)((double)((float)y + fp.y) + 0.5);
                    if (currentX < 1 || currentX >= magnitude.width - 1 || currentY < 1 || currentY >= magnitude.height - 1) continue;
                    float magW = (float)Math.exp(-(xR * xR + yR * yR) / sigma2Sq) * magnitude.data[currentY * magnitude.width + currentX];
                    yR = (float)((double)yR + ((double)dDim05 - 0.5));
                    xR = (float)((double)xR + ((double)dDim05 - 0.5));
                    int[] xIdx = new int[2];
                    int[] yIdx = new int[2];
                    int[] dirIdx = new int[2];
                    float[] xWeight = new float[2];
                    float[] yWeight = new float[2];
                    float[] dirWeight = new float[2];
                    if (xR >= 0.0f) {
                        xIdx[0] = (int)xR;
                        xWeight[0] = 1.0f - (xR - (float)xIdx[0]);
                    }
                    if (yR >= 0.0f) {
                        yIdx[0] = (int)yR;
                        yWeight[0] = 1.0f - (yR - (float)yIdx[0]);
                    }
                    if (xR < (float)(descDim - 1)) {
                        xIdx[1] = (int)((double)xR + 1.0);
                        xWeight[1] = xR - (float)xIdx[1] + 1.0f;
                    }
                    if (yR < (float)(descDim - 1)) {
                        yIdx[1] = (int)((double)yR + 1.0);
                        yWeight[1] = yR - (float)yIdx[1] + 1.0f;
                    }
                    if ((double)(dir = direction.data[currentY * direction.width + currentX] - fp.orientation) <= -Math.PI) {
                        dir = (float)((double)dir + Math.PI);
                    }
                    if ((double)dir > Math.PI) {
                        dir = (float)((double)dir - Math.PI);
                    }
                    if ((double)(idxDir = (float)((double)(dir * (float)directionCount) / (Math.PI * 2))) < 0.0) {
                        idxDir += (float)directionCount;
                    }
                    dirIdx[0] = (int)idxDir;
                    dirIdx[1] = (dirIdx[0] + 1) % directionCount;
                    dirWeight[0] = 1.0f - (idxDir - (float)dirIdx[0]);
                    dirWeight[1] = idxDir - (float)dirIdx[0];
                    for (int iy = 0; iy < 2; ++iy) {
                        for (int ix = 0; ix < 2; ++ix) {
                            for (int d = 0; d < 2; ++d) {
                                int idx;
                                int n = idx = xIdx[ix] * fp.yDim * fp.oDim + yIdx[iy] * fp.oDim + dirIdx[d];
                                fp.features[n] = fp.features[n] + xWeight[ix] * yWeight[iy] * dirWeight[d] * magW;
                            }
                        }
                    }
                }
            }
            this.capAndNormalizeFV(fp, fvGradHicap);
            survivors.add(fp);
        }
        return survivors;
    }

    private void capAndNormalizeFV(FeaturePoint kp, float fvGradHicap) {
        int n;
        float norm = 0.0f;
        for (n = 0; n < kp.features.length; ++n) {
            norm = (float)((double)norm + Math.pow(kp.features[n], 2.0));
        }
        if ((double)(norm = (float)Math.sqrt(norm)) == 0.0) {
            throw new IllegalStateException("CapAndNormalizeFV cannot normalize with norm = 0.0");
        }
        for (n = 0; n < kp.features.length; ++n) {
            int n2 = n;
            kp.features[n2] = kp.features[n2] / norm;
            if (!(kp.features[n] > fvGradHicap)) continue;
            kp.features[n] = fvGradHicap;
        }
        norm = 0.0f;
        for (n = 0; n < kp.features.length; ++n) {
            norm = (float)((double)norm + Math.pow(kp.features[n], 2.0));
        }
        norm = (float)Math.sqrt(norm);
        n = 0;
        while (n < kp.features.length) {
            int n3 = n++;
            kp.features[n3] = kp.features[n3] / norm;
        }
    }

    private ArrayList<ScalePeak> findPeaks4ThreeLayer(ImagePixelArray below, ImagePixelArray current, ImagePixelArray above, int curLev, float dogThresh) {
        ArrayList<ScalePeak> peaks = new ArrayList<ScalePeak>();
        for (int y = 1; y < current.height - 1; ++y) {
            for (int x = 1; x < current.width - 1; ++x) {
                RefCheckMark ref = new RefCheckMark();
                ref.isMin = true;
                ref.isMax = true;
                float c = current.data[x + y * current.width];
                if (Math.abs(c) <= dogThresh) continue;
                this.checkMinMax(current, c, x, y, ref, true);
                this.checkMinMax(below, c, x, y, ref, false);
                this.checkMinMax(above, c, x, y, ref, false);
                if (!ref.isMin && !ref.isMax) continue;
                peaks.add(new ScalePeak(x, y, curLev));
            }
        }
        return peaks;
    }

    private void checkMinMax(ImagePixelArray layer, float c, int x, int y, RefCheckMark ref, boolean isCurrentLayer) {
        if (layer == null) {
            return;
        }
        if (ref.isMin && (layer.data[(y - 1) * layer.width + x - 1] <= c || layer.data[y * layer.width + x - 1] <= c || layer.data[(y + 1) * layer.width + x - 1] <= c || layer.data[(y - 1) * layer.width + x] <= c || !isCurrentLayer && layer.data[y * layer.width + x] < c || layer.data[(y + 1) * layer.width + x] <= c || layer.data[(y - 1) * layer.width + x + 1] <= c || layer.data[y * layer.width + x + 1] <= c || layer.data[(y + 1) * layer.width + x + 1] <= c)) {
            ref.isMin = false;
        }
        if (ref.isMax && (layer.data[(y - 1) * layer.width + x - 1] >= c || layer.data[y * layer.width + x - 1] >= c || layer.data[(y + 1) * layer.width + x - 1] >= c || layer.data[(y - 1) * layer.width + x] >= c || !isCurrentLayer && layer.data[y * layer.width + x] > c || layer.data[(y + 1) * layer.width + x] >= c || layer.data[(y - 1) * layer.width + x + 1] >= c || layer.data[y * layer.width + x + 1] >= c || layer.data[(y + 1) * layer.width + x + 1] >= c)) {
            ref.isMax = false;
        }
    }

    private boolean isTooEdgelike(ImagePixelArray space, int x, int y, float r) {
        float d_xx = space.data[(y + 1) * space.width + x] + space.data[(y - 1) * space.width + x] - 2.0f * space.data[y * space.width + x];
        float d_yy = space.data[y * space.width + x + 1] + space.data[y * space.width + x - 1] - 2.0f * space.data[y * space.width + x];
        float d_xy = 0.25f * (space.data[(y + 1) * space.width + x + 1] - space.data[(y + 1) * space.width + x - 1] - (space.data[(y - 1) * space.width + x + 1] - space.data[(y - 1) * space.width + x - 1]));
        float trHsq = d_xx + d_yy;
        trHsq *= trHsq;
        float detH = d_xx * d_yy - d_xy * d_xy;
        float r1sq = r + 1.0f;
        return !(trHsq / detH < (r1sq *= r1sq) / r);
    }

    private boolean localizeIsWeak(ScalePeak peak, int steps, int[][] processed) {
        boolean needToAdjust = true;
        int adjusted = steps;
        while (needToAdjust) {
            int x = peak.x;
            int y = peak.y;
            if (peak.level <= 0 || peak.level >= this.diffImags.length - 1) {
                return true;
            }
            ImagePixelArray space = this.diffImags[peak.level];
            if (x <= 0 || x >= space.width - 1) {
                return true;
            }
            if (y <= 0 || y >= space.height - 1) {
                return true;
            }
            RefFloat dp = new RefFloat();
            AdjustedArray adj = this.getAdjustment(peak, peak.level, x, y, dp);
            float adjS = adj.data[0];
            float adjY = adj.data[1];
            float adjX = adj.data[2];
            if ((double)Math.abs(adjX) > 0.5 || (double)Math.abs(adjY) > 0.5) {
                if (adjusted == 0) {
                    return true;
                }
                --adjusted;
                float distSq = adjX * adjX + adjY * adjY;
                if ((double)distSq > 2.0) {
                    return true;
                }
                peak.x = (int)((double)((float)peak.x + adjX) + 0.5);
                peak.y = (int)((double)((float)peak.y + adjY) + 0.5);
                continue;
            }
            if (processed[peak.x][peak.y] != 0) {
                return true;
            }
            processed[peak.x][peak.y] = 1;
            ScalePeak.LocalInfo local = new ScalePeak.LocalInfo(adjS, adjX, adjY);
            local.dValue = space.data[peak.y * space.width + peak.x] + 0.5f * dp.val;
            peak.local = local;
            needToAdjust = false;
        }
        return false;
    }

    private AdjustedArray getAdjustment(ScalePeak peak, int level, int x, int y, RefFloat ref) {
        ref.val = 0.0f;
        if (peak.level <= 0 || peak.level >= this.diffImags.length - 1) {
            throw new IllegalArgumentException("point.Level is not within [bottom-1;top-1] range");
        }
        ImagePixelArray b = this.diffImags[level - 1];
        ImagePixelArray c = this.diffImags[level];
        ImagePixelArray a = this.diffImags[level + 1];
        AdjustedArray h = new AdjustedArray(3, 3);
        h.data[0] = b.data[y * b.width + x] - 2.0f * c.data[y * c.width + x] + a.data[y * a.width + x];
        h.data[h.width] = h.data[1] = 0.25f * (a.data[(y + 1) * a.width + x] - a.data[(y - 1) * a.width + x] - (b.data[(y + 1) * b.width + x] - b.data[(y - 1) * b.width + x]));
        h.data[h.width * 2] = h.data[2] = 0.25f * (a.data[y * a.width + x + 1] - a.data[y * a.width + x - 1] - (b.data[y * b.width + x + 1] - b.data[y * b.width + x - 1]));
        h.data[1 * h.width + 1] = c.data[(y - 1) * c.width + x] - 2.0f * c.data[y * c.width + x] + c.data[(y + 1) * c.width + x];
        float f = 0.25f * (c.data[(y + 1) * c.width + x + 1] - c.data[(y + 1) * c.width + x - 1] - (c.data[(y - 1) * c.width + x + 1] - c.data[(y - 1) * c.width + x - 1]));
        h.data[2 + h.width] = f;
        h.data[1 + h.width * 2] = f;
        h.data[2 * h.width + 2] = c.data[y * c.width + x - 1] - 2.0f * c.data[y * c.width + x] + c.data[y * c.width + x + 1];
        AdjustedArray d = new AdjustedArray(1, 3);
        d.data[0] = 0.5f * (a.data[y * a.width + x] - b.data[y * b.width + x]);
        d.data[1] = 0.5f * (c.data[(y + 1) * c.width + x] - c.data[(y - 1) * c.width + x]);
        d.data[2] = 0.5f * (c.data[y * c.width + x + 1] - c.data[y * c.width + x - 1]);
        AdjustedArray back = d.clone();
        back.negate();
        h.solveLinear(back);
        ref.val = back.dot(d);
        return back;
    }

    static class RefPeakValueAndDegreeCorrection {
        float peakValue;
        float degreeCorrection;

        RefPeakValueAndDegreeCorrection() {
        }
    }

    static class RefCheckMark {
        boolean isMin;
        boolean isMax;

        RefCheckMark() {
        }
    }

    private static class AdjustedArray
    extends FloatArray
    implements Cloneable {
        public int width;
        public int height;

        public AdjustedArray(int width, int height) {
            this.width = width;
            this.height = height;
            this.data = new float[width * height];
        }

        public AdjustedArray clone() {
            AdjustedArray cp = new AdjustedArray(this.width, this.height);
            System.arraycopy(this.data, 0, cp.data, 0, this.data.length);
            return cp;
        }

        public float dot(AdjustedArray aa) {
            if (this.width != aa.width || this.width != 1 || aa.width != 1) {
                throw new IllegalArgumentException("Dotproduct only possible for two equal n x 1 matrices");
            }
            float sum = 0.0f;
            for (int y = 0; y < this.height; ++y) {
                sum += this.data[y * this.width + 0] * aa.data[y * aa.width + 0];
            }
            return sum;
        }

        public void negate() {
            for (int y = 0; y < this.data.length; ++y) {
                this.data[y] = -this.data[y];
            }
        }

        public void solveLinear(AdjustedArray vec) {
            int y;
            if (this.width != this.height || this.height != vec.height) {
                throw new IllegalArgumentException("Matrix not quadratic or vector dimension mismatch");
            }
            for (y = 0; y < this.height - 1; ++y) {
                int py;
                int yMaxIndex = y;
                float yMaxValue = Math.abs(this.data[y * this.width + y]);
                for (py = y; py < this.height; ++py) {
                    if (!(Math.abs(this.data[py * this.width + y]) > yMaxValue)) continue;
                    yMaxValue = Math.abs(this.data[py * this.width + y]);
                    yMaxIndex = py;
                }
                this.swapRow(y, yMaxIndex);
                vec.swapRow(y, yMaxIndex);
                for (py = y + 1; py < this.height; ++py) {
                    float elimMul = this.data[py * this.width + y] / this.data[y * this.width + y];
                    for (int x = 0; x < this.width; ++x) {
                        int n = py * this.width + x;
                        this.data[n] = this.data[n] - elimMul * this.data[y * this.width + x];
                    }
                    int n = py * vec.width + 0;
                    vec.data[n] = vec.data[n] - elimMul * vec.data[y * vec.width + 0];
                }
            }
            for (y = this.height - 1; y >= 0; --y) {
                float solY = vec.data[y * vec.width + 0];
                for (int x = this.width - 1; x > y; --x) {
                    solY -= this.data[y * this.width + x] * vec.data[x * vec.width + 0];
                }
                vec.data[y * vec.width + 0] = solY / this.data[y * this.width + y];
            }
        }

        private void swapRow(int r1, int r2) {
            if (r1 == r2) {
                return;
            }
            for (int x = 0; x < this.width; ++x) {
                float temp = this.data[r1 * this.width + x];
                this.data[r1 * this.width + x] = this.data[r2 * this.width + x];
                this.data[r2 * this.width + x] = temp;
            }
        }
    }
}

