/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceConstants;
import com.alibaba.ons.open.trace.core.dispatch.AsyncAppender;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncTraceAppender;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncTraceDispatcher;
import com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.alibaba.rocketmq.client.producer.MessageQueueSelector;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsClientSendMessageHookImpl;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class OrderProducerImpl
extends ONSClientAbstract
implements OrderProducer {
    private static final Logger log = ClientLogger.getLog();
    private final DefaultMQProducer defaultMQProducer;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private AsyncDispatcher traceDispatcher = null;

    public OrderProducerImpl(Properties properties) {
        super(properties);
        this.defaultMQProducer = new DefaultMQProducer((RPCHook)new ClientRPCHook(this.sessionCredentials));
        String producerGroup = properties.getProperty("ProducerId", "__ONS_PRODUCER_DEFAULT_GROUP");
        this.defaultMQProducer.setProducerGroup(producerGroup);
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.defaultMQProducer.setVipChannelEnabled(isVipChannelEnabled);
        String sendMsgTimeoutMillis = properties.getProperty("SendMsgTimeoutMillis", "3000");
        this.defaultMQProducer.setSendMsgTimeout(Integer.parseInt(sendMsgTimeoutMillis));
        this.defaultMQProducer.setInstanceName(this.buildIntanceName());
        this.defaultMQProducer.setNamesrvAddr(this.getNameServerAddr());
        try {
            Properties tempProperties = new Properties();
            tempProperties.put("AccessKey", this.sessionCredentials.getAccessKey());
            tempProperties.put("SecretKey", this.sessionCredentials.getSecretKey());
            tempProperties.put("MaxMsgSize", "128000");
            tempProperties.put("AsyncBufferSize", "2048");
            tempProperties.put("MaxBatchNum", "1");
            tempProperties.put("WakeUpNum", "1");
            tempProperties.put(OnsTraceConstants.NAMESRV_ADDR, this.getNameServerAddr());
            tempProperties.put("InstanceName", this.buildIntanceName());
            AsyncTraceAppender appender = new AsyncTraceAppender(tempProperties);
            this.traceDispatcher = new AsyncTraceDispatcher(tempProperties);
            this.traceDispatcher.start((AsyncAppender)appender, this.defaultMQProducer.getInstanceName());
            this.defaultMQProducer.getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)new OnsClientSendMessageHookImpl(this.traceDispatcher));
        }
        catch (Throwable e) {
            log.error("system mqtrace hook init failed ,maybe can't send msg trace data");
        }
    }

    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQProducer.start();
            }
        }
        catch (Exception e) {
            throw new ONSClientException(e.getMessage());
        }
    }

    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            if (this.traceDispatcher != null) {
                try {
                    this.traceDispatcher.flush();
                }
                catch (IOException e) {
                    log.error("system mqtrace hook shutdown failed ,maybe loss some trace data");
                }
            }
            this.defaultMQProducer.shutdown();
        }
    }

    public SendResult send(Message message, String shardingKey) {
        if (UtilAll.isBlank((String)shardingKey)) {
            throw new ONSClientException("'shardingKey' is blank.");
        }
        this.checkONSProducerServiceState(this.defaultMQProducer.getDefaultMQProducerImpl());
        com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        try {
            com.alibaba.rocketmq.client.producer.SendResult sendResultRMQ = this.defaultMQProducer.send(msgRMQ, new MessageQueueSelector(){

                public MessageQueue select(List<MessageQueue> mqs, com.alibaba.rocketmq.common.message.Message msg, Object shardingKey) {
                    int select = Math.abs(shardingKey.hashCode());
                    if (select < 0) {
                        select = 0;
                    }
                    return mqs.get(select % mqs.size());
                }
            }, (Object)shardingKey);
            SendResult sendResult = new SendResult();
            sendResult.setMessageId(sendResultRMQ.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            throw new ONSClientException("defaultMQProducer send order exception", (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }
}

