/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceConstants;
import com.alibaba.ons.open.trace.core.dispatch.AsyncAppender;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncTraceAppender;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncTraceDispatcher;
import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.FAQ;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsClientSendMessageHookImpl;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class ProducerImpl
extends ONSClientAbstract
implements Producer {
    private static final Logger log = ClientLogger.getLog();
    private final DefaultMQProducer defaultMQProducer;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private AsyncDispatcher traceDispatcher = null;

    public ProducerImpl(Properties properties) {
        super(properties);
        this.defaultMQProducer = new DefaultMQProducer((RPCHook)new ClientRPCHook(this.sessionCredentials));
        String producerGroup = properties.getProperty("ProducerId", "__ONS_PRODUCER_DEFAULT_GROUP");
        this.defaultMQProducer.setProducerGroup(producerGroup);
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.defaultMQProducer.setVipChannelEnabled(isVipChannelEnabled);
        if (properties.containsKey("SendMsgTimeoutMillis")) {
            this.defaultMQProducer.setSendMsgTimeout(Integer.valueOf(properties.get("SendMsgTimeoutMillis").toString()).intValue());
        } else {
            this.defaultMQProducer.setSendMsgTimeout(5000);
        }
        this.defaultMQProducer.setInstanceName(this.buildIntanceName());
        this.defaultMQProducer.setNamesrvAddr(this.getNameServerAddr());
        this.defaultMQProducer.setMaxMessageSize(0x400000);
        try {
            Properties tempProperties = new Properties();
            tempProperties.put("AccessKey", this.sessionCredentials.getAccessKey());
            tempProperties.put("SecretKey", this.sessionCredentials.getSecretKey());
            tempProperties.put("MaxMsgSize", "128000");
            tempProperties.put("AsyncBufferSize", "2048");
            tempProperties.put("MaxBatchNum", "1");
            tempProperties.put("WakeUpNum", "1");
            tempProperties.put(OnsTraceConstants.NAMESRV_ADDR, this.getNameServerAddr());
            tempProperties.put("InstanceName", this.buildIntanceName());
            AsyncTraceAppender appender = new AsyncTraceAppender(tempProperties);
            this.traceDispatcher = new AsyncTraceDispatcher(tempProperties);
            this.traceDispatcher.start((AsyncAppender)appender, this.defaultMQProducer.getInstanceName());
            this.defaultMQProducer.getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)new OnsClientSendMessageHookImpl(this.traceDispatcher));
        }
        catch (Throwable e) {
            log.error("system mqtrace hook init failed ,maybe can't send msg trace data");
        }
    }

    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQProducer.start();
            }
        }
        catch (Exception e) {
            throw new ONSClientException(e.getMessage());
        }
    }

    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            if (this.traceDispatcher != null) {
                try {
                    this.traceDispatcher.flush();
                }
                catch (IOException e) {
                    log.error("system mqtrace hook shutdown failed ,maybe loss some trace data");
                }
            }
            this.defaultMQProducer.shutdown();
        }
    }

    public SendResult send(Message message) {
        this.checkONSProducerServiceState(this.defaultMQProducer.getDefaultMQProducerImpl());
        com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        try {
            com.alibaba.rocketmq.client.producer.SendResult sendResultRMQ = this.defaultMQProducer.send(msgRMQ);
            SendResult sendResult = new SendResult();
            sendResult.setMessageId(sendResultRMQ.getMsgId());
            message.setMsgID(sendResultRMQ.getMsgId());
            return sendResult;
        }
        catch (Exception e) {
            log.error(String.format("Send message Exception, %s", message), (Throwable)e);
            this.checkProducerException(e, message);
            return null;
        }
    }

    private void checkProducerException(Exception e, Message message) {
        if (e instanceof MQClientException) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof RemotingConnectException) {
                    throw new ONSClientException(FAQ.errorMessage(String.format("Connect broker failed, Topic: %s", message.getTopic()), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&connect_broker_failed"));
                }
                if (e.getCause() instanceof RemotingTimeoutException) {
                    throw new ONSClientException(FAQ.errorMessage(String.format("Send message to broker timeout, %dms, Topic: %s", this.defaultMQProducer.getSendMsgTimeout(), message.getTopic()), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&send_msg_failed"));
                }
                if (e.getCause() instanceof MQBrokerException) {
                    MQBrokerException excep = (MQBrokerException)e.getCause();
                    throw new ONSClientException(FAQ.errorMessage(String.format("Receive a broker exception, Topic: %s, %s", message.getTopic(), excep.getErrorMessage()), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&broker_response_exception"));
                }
            } else {
                MQClientException excep = (MQClientException)((Object)e);
                if (-1 == excep.getResponseCode()) {
                    throw new ONSClientException(FAQ.errorMessage(String.format("Topic does not exist, Topic: %s", message.getTopic()), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&topic_not_exist"));
                }
                if (13 == excep.getResponseCode()) {
                    throw new ONSClientException(FAQ.errorMessage(String.format("ONS Client check message exception, Topic: %s", message.getTopic()), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&msg_check_failed"));
                }
            }
        }
        throw new ONSClientException("defaultMQProducer send exception", (Throwable)e);
    }

    public void sendOneway(Message message) {
        this.checkONSProducerServiceState(this.defaultMQProducer.getDefaultMQProducerImpl());
        com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        try {
            this.defaultMQProducer.sendOneway(msgRMQ);
        }
        catch (Exception e) {
            log.error(String.format("Send message oneway Exception, %s", message), (Throwable)e);
            this.checkProducerException(e, message);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }
}

