/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common;

import com.baomidou.kisso.SSOCache;
import com.baomidou.kisso.SSOStatistic;
import com.baomidou.kisso.SSOToken;
import com.baomidou.kisso.Token;
import com.baomidou.kisso.common.encrypt.AES;
import com.baomidou.kisso.common.encrypt.SSOEncrypt;
import com.baomidou.kisso.common.parser.FastJsonParser;
import com.baomidou.kisso.common.parser.SSOParser;
import com.baomidou.kisso.exception.KissoException;

public class SSOReflectHelper {
    private static SSOEncrypt encrypt = null;
    private static SSOCache cache = null;
    private static SSOStatistic statistic = null;
    private static SSOParser parser = null;

    public static Token getConfigToken(String tokenClass) {
        Token token = null;
        if (tokenClass == null || "".equals(tokenClass)) {
            token = new SSOToken();
        } else {
            try {
                Class<?> tc = Class.forName(tokenClass);
                if (tc.newInstance() instanceof Token) {
                    token = (Token)tc.newInstance();
                }
            }
            catch (Exception e) {
                throw new KissoException(e);
            }
        }
        return token;
    }

    public static SSOParser getConfigParser(String parserClass) {
        if (parser != null) {
            return parser;
        }
        if (parserClass == null || "".equals(parserClass)) {
            parser = new FastJsonParser();
        } else {
            try {
                Class<?> tc = Class.forName(parserClass);
                if (tc.newInstance() instanceof SSOParser) {
                    parser = (SSOParser)tc.newInstance();
                }
            }
            catch (Exception e) {
                throw new KissoException(" kisso Config \u3010 sso.parser.class \u3011 not find. or not instanceof SSOParser", e);
            }
        }
        return parser;
    }

    public static void setConfigParser(SSOParser configParser) {
        parser = configParser;
    }

    public static SSOEncrypt getConfigEncrypt(String encryptClass) {
        if (encrypt != null) {
            return encrypt;
        }
        if (encryptClass == null || "".equals(encryptClass)) {
            encrypt = new AES();
        } else {
            try {
                Class<?> tc = Class.forName(encryptClass);
                if (tc.newInstance() instanceof SSOEncrypt) {
                    encrypt = (SSOEncrypt)tc.newInstance();
                }
            }
            catch (Exception e) {
                throw new KissoException(e);
            }
        }
        return encrypt;
    }

    public static void setConfigEncrypt(SSOEncrypt configEncrypt) {
        encrypt = configEncrypt;
    }

    public static SSOCache getConfigCache(String cacheClass) {
        if (cache != null) {
            return cache;
        }
        if (cacheClass != null && !"".equals(cacheClass)) {
            try {
                Class<?> tc = Class.forName(cacheClass);
                if (tc.newInstance() instanceof SSOCache) {
                    cache = (SSOCache)tc.newInstance();
                }
            }
            catch (Exception e) {
                throw new KissoException(e);
            }
        }
        return cache;
    }

    public static void setConfigCache(SSOCache configcache) {
        cache = configcache;
    }

    public static SSOStatistic getConfigStatistic(String encryptClass) {
        if (statistic != null) {
            return statistic;
        }
        if (encryptClass != null && !"".equals(encryptClass)) {
            try {
                Class<?> tc = Class.forName(encryptClass);
                if (tc.newInstance() instanceof SSOStatistic) {
                    statistic = (SSOStatistic)tc.newInstance();
                }
            }
            catch (Exception e) {
                throw new KissoException(e);
            }
        }
        return statistic;
    }

    public static void setConfigStatistic(SSOStatistic configStatistic) {
        statistic = configStatistic;
    }
}

