/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.encrypt.Algorithm;
import com.baomidou.kisso.common.encrypt.MD5;
import com.baomidou.kisso.common.encrypt.SSOEncrypt;
import com.baomidou.kisso.common.util.Base64Util;
import com.baomidou.kisso.exception.KissoException;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AES
implements SSOEncrypt {
    private static final Logger logger = Logger.getLogger("AES");
    private SecretKeySpec secretKey;
    private static AES aes;

    public static AES getInstance() {
        if (aes == null) {
            aes = new AES();
        }
        return aes;
    }

    public AES() {
    }

    public AES(String str) {
        this.setKey(str);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public void setKey(String strKey) {
        try {
            byte[] bk = MD5.md5Raw(strKey.getBytes(SSOConfig.getSSOEncoding()));
            this.secretKey = new SecretKeySpec(bk, Algorithm.AES.getKey());
        }
        catch (Exception e) {
            logger.severe("Encrypt setKey is exception.");
            e.printStackTrace();
        }
    }

    public String encryptAES(String str) {
        byte[] encryptBytes = null;
        String encryptStr = null;
        try {
            Cipher cipher = Cipher.getInstance(Algorithm.AES.getKey());
            cipher.init(1, this.getSecretKey());
            encryptBytes = cipher.doFinal(str.getBytes());
            if (encryptBytes != null) {
                encryptStr = Base64Util.encryptBASE64(encryptBytes);
            }
        }
        catch (Exception e) {
            throw new KissoException(e);
        }
        return encryptStr;
    }

    public String decryptAES(String str) {
        byte[] decryptBytes = null;
        String decryptStr = null;
        try {
            Cipher cipher = Cipher.getInstance(Algorithm.AES.getKey());
            cipher.init(2, this.getSecretKey());
            byte[] scrBytes = Base64Util.decryptBASE64(str);
            decryptBytes = cipher.doFinal(scrBytes);
        }
        catch (Exception e) {
            throw new KissoException(e);
        }
        if (decryptBytes != null) {
            decryptStr = new String(decryptBytes);
        }
        return decryptStr;
    }

    public String encrypt(String value, String key) throws Exception {
        this.setKey(key);
        return this.encryptAES(value);
    }

    public String decrypt(String value, String key) throws Exception {
        this.setKey(key);
        return this.decryptAES(value);
    }
}

