/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.encrypt.ByteGroup;
import com.baomidou.kisso.common.encrypt.PKCS7Encoder;
import com.baomidou.kisso.common.encrypt.SHA1;
import com.baomidou.kisso.common.parser.api.JSONParser;
import com.baomidou.kisso.common.parser.api.XMLParser;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.exception.AESException;
import java.security.Key;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public class AESMsgCrypt {
    private static final Logger logger = Logger.getLogger("AseMsgCrypt");
    private byte[] aesKey;
    private String token;
    private String appId;

    public AESMsgCrypt(String token, String encodingAesKey, String appId) throws AESException {
        if (encodingAesKey.length() != 43) {
            throw new AESException(-10005);
        }
        this.token = token;
        this.appId = appId;
        this.aesKey = Base64.decode((String)(encodingAesKey + "="));
    }

    public byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    public int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    public String encrypt(String text) throws AESException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = RandomUtil.getCharacterAndNumber(16).getBytes(SSOConfig.CHARSET_ENCODING);
        byte[] textBytes = text.getBytes(SSOConfig.CHARSET_ENCODING);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] appidBytes = this.appId.getBytes(SSOConfig.CHARSET_ENCODING);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(appidBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return new String(Base64.encode((byte[])encrypted));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AESException(-10007);
        }
    }

    public String decrypt(String text) throws AESException {
        String from_appid;
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.decode((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new AESException(-10008, (Throwable)e);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), SSOConfig.CHARSET_ENCODING);
            from_appid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), SSOConfig.CHARSET_ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AESException(-10009);
        }
        if (!from_appid.equals(this.appId)) {
            throw new AESException(-10006);
        }
        return xmlContent;
    }

    public String encryptXMLMsg(String replyMsg, String timeStamp, String nonce) throws AESException {
        return this.encryptMsg(replyMsg, timeStamp, nonce, true);
    }

    public String encryptJSONMsg(String replyMsg, String timeStamp, String nonce) throws AESException {
        return this.encryptMsg(replyMsg, timeStamp, nonce, false);
    }

    protected String encryptMsg(String replyMsg, String timeStamp, String nonce, boolean isXMLParser) throws AESException {
        String encrypt = this.encrypt(replyMsg);
        if (timeStamp == null || "".equals(timeStamp)) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt);
        logger.fine("encryptMsg sha1: " + signature);
        if (isXMLParser) {
            return XMLParser.generate(encrypt, signature, timeStamp, nonce);
        }
        return JSONParser.generate(encrypt, signature, timeStamp, nonce);
    }

    public String decryptMsg(String msgSignature, String timeStamp, String nonce, String encrypt) throws AESException {
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt);
        logger.fine("decryptMsg msgSignature sha1: " + msgSignature + ", decryptMsg signature sha1: " + signature);
        if (!signature.equals(msgSignature)) {
            throw new AESException(-10001);
        }
        return this.decrypt(encrypt);
    }

    public String verifyUrl(String msgSignature, String timeStamp, String nonce, String echoStr) throws AESException {
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, echoStr);
        if (!signature.equals(msgSignature)) {
            throw new AESException(-10001);
        }
        return this.decrypt(echoStr);
    }
}

